/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.security.AccessController;
import javax.naming.NamingException;
import weblogic.cluster.ClusterService;
import weblogic.cluster.replication.ReplicationDebugLogger;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.cluster.replication.SecureReplicationInvocationHandler;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.Security;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLContextManager;

public class ReplicationServiceLocator {
    private boolean isReplicationSecured = false;
    private String replicationChannel;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String REPLICATION_SECURED_PROP = "weblogic.replication.secured";

    public ReplicationServiceLocator() {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            this.isReplicationSecured = clusterMBean.isSecureReplicationEnabled();
            this.replicationChannel = clusterMBean.getReplicationChannel();
        }
        if (System.getProperty(REPLICATION_SECURED_PROP) != null) {
            this.isReplicationSecured = Boolean.getBoolean(REPLICATION_SECURED_PROP);
        }
    }

    ReplicationServicesInternal replicationServicesLookup(ServerIdentity serverIdentity, Class clazz) throws NamingException {
        return this.replicationServicesLookup(serverIdentity, this.replicationChannel, clazz);
    }

    ReplicationServicesInternal replicationServicesLookup(ServerIdentity serverIdentity, String string, Class clazz) throws NamingException {
        int n = -1;
        if (ClusterService.getClusterService().isReplicationTimeoutEnabled()) {
            n = ClusterService.getClusterService().getHeartbeatTimeoutMillis();
        }
        return this.getReplicationServiceInternal(serverIdentity, string, clazz, n);
    }

    private ServerChannel getOutBoundChannel(String string, boolean bl) {
        ServerChannel serverChannel = ServerChannelManager.findOutboundServerChannel((String)string);
        if (serverChannel == null) {
            Protocol protocol = ProtocolManager.getDefaultProtocol();
            Protocol protocol2 = ProtocolManager.getDefaultSecureProtocol();
            if (bl) {
                protocol = ProtocolManager.getDefaultSecureProtocol();
                protocol2 = ProtocolManager.getDefaultProtocol();
            }
            if ((serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)protocol)) == null) {
                serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)protocol2);
            }
        }
        return serverChannel;
    }

    private SSLClientInfo getOutChannelSSLClientInfo(ServerChannel serverChannel) {
        SSLClientInfo sSLClientInfo;
        block3: {
            sSLClientInfo = null;
            if (serverChannel != null) {
                try {
                    sSLClientInfo = SSLContextManager.getChannelSSLClientInfo(serverChannel, kernelId);
                }
                catch (Exception exception) {
                    if (!ReplicationDebugLogger.isDebugEnabled()) break block3;
                    ReplicationDebugLogger.debug("Failed to load Channel Certificates. Exception: " + exception, exception);
                }
            }
        }
        return sSLClientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationServicesInternal getReplicationServiceInternal(ServerIdentity serverIdentity, String string, Class clazz, int n) throws NamingException {
        ReplicationServicesInternal replicationServicesInternal;
        block7: {
            ServerChannel serverChannel;
            String string2;
            boolean bl;
            SSLClientInfo sSLClientInfo;
            SSLClientInfo sSLClientInfo2;
            block5: {
                ReplicationServicesInternal replicationServicesInternal2;
                block6: {
                    sSLClientInfo2 = null;
                    sSLClientInfo = null;
                    bl = false;
                    try {
                        string2 = URLManager.findURL(serverIdentity, string, this.isReplicationSecured);
                        serverChannel = this.getOutBoundChannel(string, this.isReplicationSecured);
                        if (serverChannel != null) break block5;
                        replicationServicesInternal2 = null;
                        Object var12_12 = null;
                        if (!bl || sSLClientInfo == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var12_14 = null;
                            if (!bl || sSLClientInfo == null) break block8;
                            Security.setThreadSSLClientInfo(sSLClientInfo2);
                        }
                        throw throwable;
                    }
                    Security.setThreadSSLClientInfo(sSLClientInfo2);
                }
                return replicationServicesInternal2;
            }
            bl = serverChannel.getProtocol().isSecure();
            if (bl) {
                sSLClientInfo2 = Security.getThreadSSLClientInfo();
                sSLClientInfo = this.getOutChannelSSLClientInfo(serverChannel);
                if (sSLClientInfo != null) {
                    Security.setThreadSSLClientInfo(sSLClientInfo);
                }
            }
            replicationServicesInternal = SecureReplicationInvocationHandler.lookupService(string2, serverChannel.getChannelName(), n, clazz, bl);
            Object var12_13 = null;
            if (!bl || sSLClientInfo == null) break block7;
            Security.setThreadSSLClientInfo(sSLClientInfo2);
        }
        return replicationServicesInternal;
    }
}

