/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.jndi.Environment;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;

public class SecureReplicationInvocationHandler
implements InvocationHandler {
    private static final Class[] interfaces = new Class[]{ReplicationServicesInternal.class};
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final ReplicationServicesInternal delegate;
    private final boolean useSecuredChannel;
    private final String url;
    private AuthenticatedSubject cachedSubject;

    public static ReplicationServicesInternal lookupService(final String string, final String string2, final int n, final Class clazz, boolean bl) throws NamingException {
        ReplicationServicesInternal replicationServicesInternal = null;
        AuthenticatedSubject authenticatedSubject = SecureReplicationInvocationHandler.getSubjectForReplicationCalls(string, bl);
        try {
            replicationServicesInternal = (ReplicationServicesInternal)SecurityManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Environment environment = new Environment();
                    environment.setProviderUrl(string);
                    environment.setProviderChannel(string2);
                    if (n >= 0) {
                        environment.setRequestTimeout(n);
                    }
                    return (ReplicationServicesInternal)PortableRemoteObject.narrow((Object)environment.getInitialReference(clazz), ReplicationServicesInternal.class);
                }
            });
            return SecureReplicationInvocationHandler.makeSecureService(replicationServicesInternal, bl, string);
        }
        catch (PrivilegedActionException privilegedActionException) {
            NamingException namingException = new NamingException(privilegedActionException.getMessage());
            namingException.setRootCause(privilegedActionException.getCause());
            throw namingException;
        }
    }

    public static void checkPriviledges(AuthenticatedSubject authenticatedSubject, boolean bl) throws SecurityException {
        if (bl) {
            SecureReplicationInvocationHandler.checkPriviledgesForSecuredChannel(authenticatedSubject);
        } else {
            SecureReplicationInvocationHandler.checkPriviledgesForUnsecuredChannel(authenticatedSubject);
        }
    }

    private static ReplicationServicesInternal makeSecureService(ReplicationServicesInternal replicationServicesInternal, boolean bl, String string) {
        return (ReplicationServicesInternal)Proxy.newProxyInstance(replicationServicesInternal.getClass().getClassLoader(), interfaces, (InvocationHandler)new SecureReplicationInvocationHandler(replicationServicesInternal, bl, string));
    }

    private static AuthenticatedSubject getSubjectForReplicationCalls(String string, boolean bl) {
        try {
            AuthenticatedSubject authenticatedSubject = RemoteDomainSecurityHelper.getSubject(string);
            if (authenticatedSubject != null) {
                return authenticatedSubject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl ? KERNEL_ID : SecureReplicationInvocationHandler.getCurrentSubject();
    }

    private AuthenticatedSubject getSubjectForReplicationCalls() {
        AuthenticatedSubject authenticatedSubject = this.cachedSubject;
        if (authenticatedSubject == null) {
            try {
                authenticatedSubject = RemoteDomainSecurityHelper.getSubject(this.url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (authenticatedSubject != null) {
                this.cachedSubject = authenticatedSubject;
            }
        }
        return authenticatedSubject != null ? authenticatedSubject : (this.useSecuredChannel ? KERNEL_ID : SecureReplicationInvocationHandler.getCurrentSubject());
    }

    private static AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
            return SubjectUtils.getAnonymousSubject();
        }
        return authenticatedSubject;
    }

    private static void checkPriviledgesForSecuredChannel(AuthenticatedSubject authenticatedSubject) throws SecurityException {
        if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
            return;
        }
        ClusterLogger.logWrongPriviledgesForReplicationCalls((String)"users with Admin priviledges", (String)"secured");
        SecurityException securityException = new SecurityException("Insufficient priviledges for doing replication.");
        throw securityException;
    }

    private static void checkPriviledgesForUnsecuredChannel(AuthenticatedSubject authenticatedSubject) throws SecurityException {
        if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
            ClusterLogger.logWrongPriviledgesForReplicationCalls((String)"users without Admin priviledges", (String)"unsecured");
            SecurityException securityException = new SecurityException("Insufficient priviledges for doing replication.");
            throw securityException;
        }
    }

    private SecureReplicationInvocationHandler(ReplicationServicesInternal replicationServicesInternal, boolean bl, String string) {
        this.delegate = replicationServicesInternal;
        this.useSecuredChannel = bl;
        this.url = string;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ReplicationServicesInvocationAction replicationServicesInvocationAction = new ReplicationServicesInvocationAction(this.delegate, method, objectArray);
        AuthenticatedSubject authenticatedSubject = this.getSubjectForReplicationCalls();
        try {
            Object object2 = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)replicationServicesInvocationAction);
            if (replicationServicesInvocationAction.getInvocationException() != null) {
                throw replicationServicesInvocationAction.getInvocationException();
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw new RemoteException(invocationTargetException.getMessage());
        }
    }

    public class ReplicationServicesInvocationAction
    implements PrivilegedAction {
        private Object targetObject;
        private Method targetMethod;
        private Object[] targetArgs;
        private Throwable exception = null;

        public ReplicationServicesInvocationAction(Object object, Method method, Object[] objectArray) {
            this.targetObject = object;
            this.targetMethod = method;
            this.targetArgs = objectArray;
        }

        public Object run() {
            try {
                return this.targetMethod.invoke(this.targetObject, this.targetArgs);
            }
            catch (Throwable throwable) {
                this.exception = throwable;
                return null;
            }
        }

        public Throwable getInvocationException() {
            return this.exception;
        }
    }
}

