/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ROInfo;
import weblogic.cluster.replication.Replicatable;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.rmi.spi.HostID;

final class WrappedRO {
    public static final byte PRIMARY_STATUS = 0;
    public static final byte SECONDARY_STATUS = 1;
    public static final int INITIAL_VERSION_NUMBER = 0;
    static final int RO_NOT_FOUND = -1;
    private final Map map = Collections.synchronizedMap(new HashMap(3));
    private final Map<Object, Integer> versionMap = Collections.synchronizedMap(new HashMap(3));
    private byte status;
    private HostID otherHost;
    private int version;
    private final ROInfo roInfo;
    private final ROID id;
    final int channelIndex;

    WrappedRO(Replicatable replicatable, ROID rOID, byte by, int n) {
        this.roInfo = new ROInfo(rOID);
        this.status = by;
        this.version = n;
        this.otherHost = null;
        this.id = rOID;
        if (by == 0) {
            replicatable.becomePrimary(rOID);
        } else {
            this.roInfo.setSecondaryROInfo(replicatable.becomeSecondary(rOID));
        }
        this.addMapEntry(replicatable, n);
        this.channelIndex = ReplicationManager.replicationChannels != null ? (rOID.getValueAsInt() & Integer.MAX_VALUE) % ReplicationManager.replicationChannels.length : -1;
    }

    private void addMapEntry(Replicatable replicatable, int n) {
        this.map.put(replicatable.getKey(), replicatable);
        this.versionMap.put(replicatable.getKey(), n);
    }

    void addRO(Replicatable replicatable) {
        this.addMapEntry(replicatable, 1);
        if (this.status == 0) {
            replicatable.becomePrimary(this.id);
        } else {
            this.roInfo.setSecondaryROInfo(replicatable.becomeSecondary(this.id));
        }
    }

    void addRO(Replicatable replicatable, int n) {
        this.addMapEntry(replicatable, n);
        if (this.status == 0) {
            replicatable.becomePrimary(this.id);
        } else {
            this.roInfo.setSecondaryROInfo(replicatable.becomeSecondary(this.id));
        }
    }

    void removeAll() {
        this.map.clear();
        this.versionMap.clear();
    }

    boolean removeRO(Object object) {
        this.map.remove(object);
        this.versionMap.remove(object);
        return this.map.size() == 0;
    }

    Replicatable getRO(Object object) {
        return (Replicatable)this.map.get(object);
    }

    ROID getID() {
        return this.roInfo.getROID();
    }

    ROInfo getROInfo() {
        return this.roInfo;
    }

    HostID getOtherHost() {
        return this.otherHost;
    }

    byte getStatus() {
        return this.status;
    }

    int getVersion() {
        return this.version;
    }

    HostID setOtherHost(HostID hostID) {
        this.otherHost = hostID;
        return this.otherHost;
    }

    int getVersion(Object object) {
        Integer n = this.versionMap.get(object);
        if (n != null) {
            return n;
        }
        return -1;
    }

    Object getSecondaryROInfo() {
        return this.roInfo.getSecondaryROInfo();
    }

    void setOtherHostInfo(Object object) {
        this.roInfo.setSecondaryROInfo(object);
    }

    final int incrementVersion(Object object) {
        ++this.version;
        int n = this.getVersion(object) + 1;
        this.versionMap.put(object, n);
        return n;
    }

    final void decrementVersion(Object object) {
        --this.version;
        this.versionMap.put(object, this.getVersion(object) - 1);
    }

    final int getNumROS() {
        return this.map.size();
    }

    final void ensureStatus(byte by) {
        if (this.status != by) {
            this.status = by;
            if (by == 0) {
                this.roInfo.setSecondaryROInfo(null);
                this.otherHost = null;
                this.changeStatus(true);
            } else {
                this.changeStatus(false);
            }
        }
    }

    private void changeStatus(boolean bl) {
        for (Replicatable replicatable : this.map.values()) {
            if (bl) {
                replicatable.becomePrimary(this.roInfo.getROID());
                continue;
            }
            this.roInfo.setSecondaryROInfo(replicatable.becomeSecondary(this.roInfo.getROID()));
        }
    }

    Iterator keys() {
        return this.map.keySet().iterator();
    }

    Map getMap() {
        return this.map;
    }

    Map getVersionMap() {
        return this.versionMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WrappedRO) {
            WrappedRO wrappedRO = (WrappedRO)object;
            return wrappedRO.id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

