/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.UpgradeUtils;
import weblogic.cluster.migration.ScriptExecutor;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.ServiceLocationSelector;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.common.internal.PeerInfo;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;

public abstract class AbstractServiceLocationSelector
implements ServiceLocationSelector {
    protected static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();

    protected List getAcceptableServers(List list) {
        ArrayList<ServerMBean> arrayList = new ArrayList<ServerMBean>();
        UpgradeUtils upgradeUtils = UpgradeUtils.getInstance();
        for (ServerMBean serverMBean : list) {
            if (upgradeUtils.getServerVersion(serverMBean.getName()) == null) {
                arrayList.add(serverMBean);
                continue;
            }
            if (upgradeUtils.getServerVersion(serverMBean.getName()).compareTo((Object)PeerInfo.VERSION_920) <= -1) continue;
            arrayList.add(serverMBean);
        }
        return arrayList;
    }

    protected boolean isServerRunning(ServerMBean serverMBean) {
        boolean bl = false;
        String string = serverMBean.getName();
        ClusterMemberInfo clusterMemberInfo = ClusterService.getClusterService().getLocalMember();
        if (clusterMemberInfo != null && clusterMemberInfo.serverName().equals(string) && !AnnouncementManager.theOne().isBlocked()) {
            return true;
        }
        Collection collection = ClusterService.getClusterService().getRemoteMembers();
        for (ClusterMemberInfo clusterMemberInfo2 : collection) {
            if (!clusterMemberInfo2.serverName().equals(string)) continue;
            ClusterMBean clusterMBean = serverMBean.getCluster();
            if ("consensus".equalsIgnoreCase(clusterMBean.getMigrationBasis())) {
                String string2 = AbstractConsensusService.getInstance().getServerState(string);
                if (string2 != null && !string2.equals("RESUMING") && !string2.equals("RUNNING")) break;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean executePostScript(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, ServerMBean serverMBean2) {
        boolean bl = true;
        if (migratableTargetMBean.getPostScript() != null && migratableTargetMBean.isPostScriptFailureFatal() && serverMBean != null) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (serverMBean2 != null) {
                bl3 = true;
                bl2 = this.executePostScript(migratableTargetMBean, serverMBean2);
                if (!bl2 && DEBUG) {
                    AbstractServiceLocationSelector.p("Failed to run the postscript on " + serverMBean2 + " for " + migratableTargetMBean.getName());
                }
            }
            if (!bl2 && migratableTargetMBean.isNonLocalPostAllowed()) {
                bl3 = true;
                bl2 = this.executePostScript(migratableTargetMBean, serverMBean);
                if (!bl2 && DEBUG) {
                    AbstractServiceLocationSelector.p("Failed to run the postscript on " + serverMBean + " for " + migratableTargetMBean.getName());
                }
            }
            if (bl3 && !bl2) {
                bl = false;
            }
        }
        return bl;
    }

    protected boolean executePostScript(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean) {
        if (DEBUG) {
            AbstractServiceLocationSelector.p("Going to execute the post script " + migratableTargetMBean.getPostScript() + " for " + migratableTargetMBean.getName() + " on " + serverMBean);
        }
        return ScriptExecutor.runNMScript(migratableTargetMBean.getPostScript(), migratableTargetMBean, serverMBean);
    }

    protected static void p(Object object) {
        SingletonServicesDebugLogger.debug("ServiceLocationSelector: " + object);
    }

    public void migrationSuccessful(ServerMBean serverMBean, boolean bl) {
    }

    public abstract ServerMBean chooseServer();

    public abstract void setLastHost(ServerMBean var1);

    public abstract void setServerList(List var1);
}

