/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.List;
import weblogic.cluster.singleton.AbstractServiceLocationSelector;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManager;
import weblogic.management.configuration.ServerMBean;

public class BasicServiceLocationSelector
extends AbstractServiceLocationSelector {
    private String serviceName;
    private SingletonServicesStateManager stateManager;
    private ServerMBean upsServer = null;
    private int serverIndex = -1;
    private List serverList = null;
    private ServerMBean lastHost = null;
    private boolean indexSet = false;
    private boolean triedOnUPS = false;

    public BasicServiceLocationSelector(String string, SingletonServicesStateManager singletonServicesStateManager) {
        this.serviceName = string;
        this.stateManager = singletonServicesStateManager;
    }

    public void setUPS(ServerMBean serverMBean) {
        this.upsServer = serverMBean;
    }

    public ServerMBean chooseServer() {
        int n;
        if (this.serverList == null || this.serverList.size() == 0) {
            return null;
        }
        if (this.upsServer != null && !this.triedOnUPS && this.isServerRunning(this.upsServer)) {
            this.triedOnUPS = true;
            return this.upsServer;
        }
        if (!this.indexSet) {
            this.setIndex();
        }
        ServerMBean serverMBean = null;
        int n2 = n = (this.serverIndex + 1) % this.serverList.size();
        do {
            if ((serverMBean = (ServerMBean)this.serverList.get(n)) == null) continue;
            if (this.isServerRunning(serverMBean)) {
                this.serverIndex = n;
                break;
            }
            serverMBean = null;
        } while ((n = (n + 1) % this.serverList.size()) != n2);
        return serverMBean;
    }

    public void setLastHost(ServerMBean serverMBean) {
        this.lastHost = serverMBean;
        this.indexSet = false;
    }

    public void setServerList(List list) {
        this.serverList = this.getAcceptableServers(list);
        if (this.serverList.size() > 1 && this.upsServer != null) {
            this.serverList.remove(this.upsServer);
        }
    }

    private void setIndex() {
        if (this.lastHost != null && this.serverList != null) {
            for (int i = 0; i < this.serverList.size(); ++i) {
                ServerMBean serverMBean = (ServerMBean)this.serverList.get(i);
                if (!serverMBean.getName().equals(this.lastHost.getName())) continue;
                this.serverIndex = i;
                break;
            }
        }
        this.indexSet = true;
    }

    public void migrationSuccessful(ServerMBean serverMBean, boolean bl) {
        this.stateManager.storeServiceState(this.serviceName, new SingletonServicesState(1));
    }
}

