/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.ClusterLeaderListener;
import weblogic.cluster.singleton.ClusterMasterRemote;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigratableServersMonitorImpl;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.jndi.Environment;
import weblogic.protocol.LocalServerIdentity;

class ClusterMaster
implements MigratableServiceConstants,
SingletonService,
ClusterMasterRemote,
ClusterLeaderListener {
    private boolean isClusterMaster = false;
    private final MigratableServersMonitorImpl monitor;
    static final String CLUSTER_MASTER = "CLUSTER_MASTER";

    ClusterMaster(int n) {
        this.monitor = new MigratableServersMonitorImpl(ClusterService.getServices().getDefaultLeaseManager("wlsserver"), n);
    }

    public boolean isClusterMaster() {
        return this.isClusterMaster;
    }

    public void start() {
        if ("consensus".equals(MigratableServerService.theOne().getLeasingType())) {
            AbstractConsensusService.getInstance().addClusterLeaderListener(this);
        } else {
            SingletonServicesManager.getInstance().add(this.getName(), this);
        }
    }

    public void activate() {
        this.isClusterMaster = true;
        this.bindClusterMaster(this);
        this.monitor.start();
        ClusterLogger.logClusterMasterElected((String)LocalServerIdentity.getIdentity().getServerName());
    }

    public void deactivate() {
        if (!this.isClusterMaster) {
            return;
        }
        this.isClusterMaster = false;
        ClusterLogger.logRevokeClusterMasterRole((String)LocalServerIdentity.getIdentity().getServerName());
        this.monitor.stop();
    }

    public void localServerIsClusterLeader() {
        this.activate();
    }

    public void localServerLostClusterLeadership() {
        this.deactivate();
    }

    public String getName() {
        return CLUSTER_MASTER;
    }

    public void setServerLocation(String string, String string2) throws RemoteException {
        this.monitor.setServerLocation(string, string2);
    }

    public String getServerLocation(String string) throws RemoteException {
        return this.monitor.getCurrentMachine(string);
    }

    private void bindClusterMaster(final ClusterMaster clusterMaster) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    Context context = null;
                    try {
                        try {
                            Environment environment = new Environment();
                            environment.setCreateIntermediateContexts(true);
                            environment.setReplicateBindings(false);
                            context = environment.getInitialContext();
                            context.rebind("weblogic/cluster/singleton/ClusterMasterRemote", (Object)clusterMaster);
                        }
                        catch (NamingException namingException) {
                            throw new AssertionError((Object)("Unexpected exception" + namingException));
                        }
                        Object var4_4 = null;
                        if (context == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (context == null) throw throwable;
                        try {
                            context.close();
                            throw throwable;
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {}
                    context.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Unexpected exception" + exception));
        }
    }
}

