/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class ConfigMigrationProcessor
implements ConfigurationProcessor {
    private static final String MIG_TARGET_TYPE = "MigratableTarget";
    private static final HashMap migTar2ServerMap = new HashMap();
    private static final String CONNECTION_POOL_NAME = "_autogen_SingletonConnPool";
    private static final String JDBC_SYSTEM_RESOURCE = "_autogen_SingletonJDBCSystemResource";

    public static final ConfigMigrationProcessor getInstance() {
        return SingletonMaker.config;
    }

    private ConfigMigrationProcessor() {
    }

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        try {
            this.changeJMSServerTargets(domainMBean);
            this.changeJTAMigratableTargets(domainMBean);
        }
        catch (Exception exception) {
            throw new UpdateException(exception);
        }
    }

    public void setConnectionPoolProperties(String string, String string2, String string3, String string4, String string5, DomainMBean domainMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JDBCSystemResourceMBean jDBCSystemResourceMBean = null;
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            if (!this.isMigratableCluster(clusterMBeanArray[i])) continue;
            jDBCSystemResourceMBean = clusterMBeanArray[i].getDataSourceForAutomaticMigration();
            String string6 = clusterMBeanArray[i].getName() + JDBC_SYSTEM_RESOURCE;
            if (jDBCSystemResourceMBean == null) {
                jDBCSystemResourceMBean = domainMBean.createJDBCSystemResource(string6, string6 + "-jdbc.xml");
            }
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
            jDBCDataSourceBean.setName(string6);
            JDBCDriverParamsBean jDBCDriverParamsBean = jDBCDataSourceBean.getJDBCDriverParams();
            jDBCDriverParamsBean.setDriverName(string3);
            jDBCDriverParamsBean.setPassword(string2);
            jDBCDriverParamsBean.setUrl(string4);
            Properties properties = new Properties();
            properties.put("user", string);
            String[] stringArray = new String[]{CONNECTION_POOL_NAME};
            jDBCDataSourceBean.getJDBCDataSourceParams().setJNDINames(stringArray);
            JDBCMBeanConverter.setDriverProperties(jDBCDataSourceBean, properties);
            jDBCSystemResourceMBean.setTargets(new TargetMBean[]{clusterMBeanArray[i]});
            clusterMBeanArray[i].setDataSourceForAutomaticMigration(jDBCSystemResourceMBean);
        }
    }

    public void createMachine(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5) throws InvalidAttributeValueException {
        MachineMBean[] machineMBeanArray = domainMBean.getMachines();
        for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (!machineMBeanArray[i].getName().equals(string)) continue;
            return;
        }
        MachineMBean machineMBean = domainMBean.createMachine(string);
        NodeManagerMBean nodeManagerMBean = machineMBean.getNodeManager();
        nodeManagerMBean.setListenAddress(string2);
        nodeManagerMBean.setListenPort(Integer.parseInt(string3));
        if (string4.length() > 0) {
            nodeManagerMBean.setNMType(string4);
        }
        domainMBean.lookupServer(string5).setMachine(machineMBean);
    }

    public void setCandidateMachinesForAutomaticMigration(DomainMBean domainMBean) {
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            if (!this.isMigratableCluster(clusterMBeanArray[i])) continue;
            this.setCandidateMachines(clusterMBeanArray[i]);
        }
    }

    private void setCandidateMachines(ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        HashSet<MachineMBean> hashSet = new HashSet<MachineMBean>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            MachineMBean machineMBean = serverMBeanArray[i].getMachine();
            if (machineMBean == null) continue;
            hashSet.add(machineMBean);
        }
        MachineMBean[] machineMBeanArray = new MachineMBean[hashSet.size()];
        clusterMBean.setCandidateMachinesForMigratableServers(hashSet.toArray(machineMBeanArray));
    }

    private boolean isMigratableCluster(ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].isAutoMigrationEnabled()) continue;
            return true;
        }
        return false;
    }

    private void changeJMSServerTargets(DomainMBean domainMBean) throws Exception {
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = jMSServerMBeanArray[i].getTargets();
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                String string = targetMBeanArray[j].getType();
                if (!string.equals(MIG_TARGET_TYPE)) continue;
                MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)targetMBeanArray[j];
                TargetMBean[] targetMBeanArray2 = new TargetMBean[]{migratableTargetMBean.getUserPreferredServer()};
                jMSServerMBeanArray[i].setTargets(targetMBeanArray2);
            }
        }
        this.deleteMigratableTargets(domainMBean);
    }

    private void deleteMigratableTargets(DomainMBean domainMBean) {
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBeanArray[i].getMigratableTargets();
            for (int j = 0; j < migratableTargetMBeanArray.length; ++j) {
                this.addMigratableTargetToMap(migratableTargetMBeanArray[j]);
                domainMBean.destroyMigratableTarget(migratableTargetMBeanArray[j]);
            }
        }
    }

    private void changeJTAMigratableTargets(DomainMBean domainMBean) throws Exception {
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            ServerMBean[] serverMBeanArray = clusterMBeanArray[i].getServers();
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBeanArray[j].getJTAMigratableTarget();
                if (!serverMBeanArray[j].isAutoMigrationEnabled()) {
                    serverMBeanArray[j].setAutoMigrationEnabled(true);
                }
                this.addMigratableTargetToMap(jTAMigratableTargetMBean);
                domainMBean.destroyMigratableTarget(jTAMigratableTargetMBean);
            }
        }
    }

    private void addMigratableTargetToMap(MigratableTargetMBean migratableTargetMBean) {
        ServerMBean serverMBean = migratableTargetMBean.getUserPreferredServer();
        migTar2ServerMap.put(migratableTargetMBean.getName(), serverMBean.getName());
    }

    static HashMap getMTToServerMapping() {
        return migTar2ServerMap;
    }

    private static class SingletonMaker {
        private static final ConfigMigrationProcessor config = new ConfigMigrationProcessor();

        private SingletonMaker() {
        }
    }
}

