/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.MissedHeartbeatException;
import weblogic.cluster.singleton.QueryHelper;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;

public class DatabaseLeasingBasis
implements LeasingBasis {
    private static final boolean DEBUG = MigrationDebugLogger.isDebugEnabled();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected final JDBCSystemResourceMBean jdbcResource;
    protected final String TABLE_NAME;
    protected final int queryTimeoutSeconds;
    private boolean supportsTimeouts = false;
    private DataSource ds;
    private QueryHelper queryHelper;

    public DatabaseLeasingBasis(JDBCSystemResourceMBean jDBCSystemResourceMBean, int n, String string) {
        this.TABLE_NAME = string;
        this.jdbcResource = jDBCSystemResourceMBean;
        this.queryTimeoutSeconds = n;
    }

    private QueryHelper getQueryHelper(Connection connection) {
        if (this.queryHelper == null) {
            this.queryHelper = MigratableServerService.theOne().identifyVendorSpecificQuery(this.TABLE_NAME, connection);
            this.supportsTimeouts = this.queryHelper.getDBType() != 4 && this.queryHelper.getDBType() != 5;
        }
        return this.queryHelper;
    }

    public boolean acquire(String string, String string2, int n) throws LeasingException {
        if (DEBUG) {
            DatabaseLeasingBasis.p("tryAcquire(" + string + ", " + n + ")");
        }
        this.acquireLease(string, string2);
        return this.assumeLease(string, string2, n) == 1;
    }

    public void release(String string, String string2) throws IOException {
        int n;
        if (DEBUG) {
            DatabaseLeasingBasis.p("release(" + string + ")");
        }
        if ((n = this.abdicateLease(string, string2)) < 0 || n > 1) {
            throw new IOException("Could not release: \"" + string + "\"");
        }
    }

    public int renewAllLeases(int n, String string) throws MissedHeartbeatException {
        int n2;
        if (DEBUG) {
            DatabaseLeasingBasis.p("renewAllLeases(" + n + ")");
        }
        if ((n2 = this.renewAllLeases(string, n)) < 0) {
            throw new MissedHeartbeatException("Could not heartbeat");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renewLeases(String string, Set set, int n) throws IOException {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Unexpected exception", sQLException);
            }
            return -1;
        }
        PreparedStatement preparedStatement = null;
        String string2 = null;
        try {
            string2 = this.getQueryHelper(connection).getRenewLeasesQuery(string, set, n / 1000);
            if (DEBUG) {
                MigrationDebugLogger.debug("Query: " + string2);
            }
            preparedStatement = connection.prepareStatement(string2);
            if (this.supportsTimeouts) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            int n2 = preparedStatement.executeUpdate();
            Object var10_10 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string2);
                    MigrationDebugLogger.debug("Unexpected exception", sQLException);
                }
                int n3 = -1;
                Object var10_11 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return n3;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int renewAllLeases(String string, int n) {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Unexpected exception", sQLException);
            }
            return -1;
        }
        PreparedStatement preparedStatement = null;
        String string2 = null;
        try {
            string2 = this.getQueryHelper(connection).getRenewAllLeasesQuery(string, n / 1000);
            if (DEBUG) {
                MigrationDebugLogger.debug("Query: " + string2);
            }
            preparedStatement = connection.prepareStatement(string2);
            if (this.supportsTimeouts) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            int n2 = preparedStatement.executeUpdate();
            Object var9_9 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string2);
                    MigrationDebugLogger.debug("Unexpected exception", sQLException);
                }
                int n3 = -1;
                Object var9_10 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return n3;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int abdicateLease(String string, String string2) {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Unexpected exception", sQLException);
            }
            return -1;
        }
        PreparedStatement preparedStatement = null;
        String string3 = null;
        try {
            string3 = this.getQueryHelper(connection).getAbdicateLeaseQuery(string, string2);
            if (DEBUG) {
                MigrationDebugLogger.debug("Query: " + string3);
            }
            preparedStatement = connection.prepareStatement(string3);
            if (this.supportsTimeouts) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            int n = preparedStatement.executeUpdate();
            Object var9_9 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n;
        }
        catch (SQLException sQLException) {
            try {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string3);
                    MigrationDebugLogger.debug("Unexpected exception", sQLException);
                }
                int n = -1;
                Object var9_10 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return n;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int acquireLease(String string, String string2) {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Unexpected exception", sQLException);
            }
            return -1;
        }
        PreparedStatement preparedStatement = null;
        String string3 = null;
        try {
            string3 = this.getQueryHelper(connection).getAcquireLeaseQuery(string, string2);
            if (DEBUG) {
                MigrationDebugLogger.debug("Query: " + string3);
            }
            preparedStatement = connection.prepareStatement(string3);
            if (this.supportsTimeouts) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            int n = preparedStatement.executeUpdate();
            Object var9_9 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n;
        }
        catch (SQLException sQLException) {
            try {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string3);
                    MigrationDebugLogger.debug("Unexpected exception", sQLException);
                }
                int n = -1;
                Object var9_10 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return n;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int assumeLease(String string, String string2, int n) {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Unexpected exception", sQLException);
            }
            return -1;
        }
        PreparedStatement preparedStatement = null;
        String string3 = null;
        try {
            string3 = this.getQueryHelper(connection).getAssumeLeaseQuery(string, string2, n / 1000);
            if (DEBUG) {
                MigrationDebugLogger.debug("Query: " + string3);
            }
            preparedStatement = connection.prepareStatement(string3);
            if (this.supportsTimeouts) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            int n2 = preparedStatement.executeUpdate();
            Object var10_10 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string3);
                    MigrationDebugLogger.debug("Unexpected exception", sQLException);
                }
                int n3 = -1;
                Object var10_11 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return n3;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findPreviousOwner(String string) throws IOException {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (!MigrationDebugLogger.isDebugEnabled()) return null;
            MigrationDebugLogger.debug("Failed to get sql connection", sQLException);
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            try {
                string2 = this.getQueryHelper(connection).getPreviousLeaseOwnerQuery(string);
                if (DEBUG) {
                    MigrationDebugLogger.debug("Query: " + string2);
                }
                preparedStatement = connection.prepareStatement(string2);
                if (this.supportsTimeouts) {
                    preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    String string3 = resultSet.getString(1);
                    Object var8_9 = null;
                    this.closeResultSet(resultSet);
                    this.closePreparedStatement(preparedStatement);
                    this.closeSQLConnection(connection);
                    return string3;
                }
                Object var8_10 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return null;
            }
            catch (SQLException sQLException) {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string2);
                    MigrationDebugLogger.debug("Unexpected sql exception", sQLException);
                }
                Object var8_11 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findOwner(String string) throws IOException {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (!MigrationDebugLogger.isDebugEnabled()) throw new IOException(sQLException.getMessage());
            MigrationDebugLogger.debug("Failed to get sql connection", sQLException);
            throw new IOException(sQLException.getMessage());
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            try {
                string2 = this.getQueryHelper(connection).getLeaseOwnerQuery(string);
                if (DEBUG) {
                    MigrationDebugLogger.debug("Query: " + string2);
                }
                preparedStatement = connection.prepareStatement(string2);
                if (this.supportsTimeouts) {
                    preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    String string3 = resultSet.getString(1);
                    Object var8_9 = null;
                    this.closeResultSet(resultSet);
                    this.closePreparedStatement(preparedStatement);
                    this.closeSQLConnection(connection);
                    return string3;
                }
                Object var8_10 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                return null;
            }
            catch (SQLException sQLException) {
                if (!MigrationDebugLogger.isDebugEnabled()) throw new IOException(sQLException.getMessage());
                MigrationDebugLogger.debug("Attempted Query: " + string2);
                MigrationDebugLogger.debug("Unexpected sql exception", sQLException);
                throw new IOException(sQLException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findExpiredLeases(int n) {
        Connection connection = null;
        try {
            connection = this.getJDBCConnection();
        }
        catch (SQLException sQLException) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("Failed to get sql connection", sQLException);
            }
            return new String[0];
        }
        PreparedStatement preparedStatement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        String string = null;
        try {
            try {
                string = this.getQueryHelper(connection).getUnresponsiveMigratableServersQuery(n / 1000);
                if (DEBUG) {
                    MigrationDebugLogger.debug("Query: " + string);
                }
                preparedStatement = connection.prepareStatement(string);
                if (this.supportsTimeouts) {
                    preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                Object var9_8 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
            }
            catch (SQLException sQLException) {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Attempted Query: " + string);
                    MigrationDebugLogger.debug("Unexpected sql exception", sQLException);
                }
                Object var9_9 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            throw throwable;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected void closePreparedStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    protected void closeSQLConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void pingDB(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string = this.getQueryHelper(connection).getLeaseOwnerQuery("nonexistantlease");
        preparedStatement = connection.prepareStatement(string);
        if (this.supportsTimeouts) {
            preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
        }
        preparedStatement.executeQuery();
        this.closePreparedStatement(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Connection getJDBCConnection(JDBCSystemResourceMBean jDBCSystemResourceMBean) throws SQLException {
        Connection connection;
        Connection connection2;
        InitialContext initialContext;
        JDBCDataSourceBean jDBCDataSourceBean;
        block15: {
            block13: {
                Connection connection3;
                block14: {
                    jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
                    JDBCDataSourceParamsBean jDBCDataSourceParamsBean = jDBCSystemResourceMBean.getJDBCResource().getJDBCDataSourceParams();
                    if (this.ds != null) {
                        Connection connection4 = null;
                        try {
                            connection4 = this.ds.getConnection();
                            this.pingDB(connection4);
                            return connection4;
                        }
                        catch (SQLException sQLException) {
                            this.closeSQLConnection(connection4);
                            connection4 = this.createDirectConnection(jDBCDataSourceBean.getJDBCDriverParams());
                            this.pingDB(connection4);
                            return connection4;
                        }
                    }
                    String[] stringArray = jDBCDataSourceParamsBean.getJNDINames();
                    initialContext = null;
                    connection2 = null;
                    if (stringArray == null || stringArray.length <= 0) break block13;
                    initialContext = new InitialContext();
                    this.ds = (DataSource)initialContext.lookup(stringArray[0]);
                    connection2 = this.ds.getConnection();
                    this.pingDB(connection2);
                    connection3 = connection2;
                    Object var10_12 = null;
                    if (initialContext == null) break block14;
                    try {
                        initialContext.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                return connection3;
            }
            connection2 = this.createDirectConnection(jDBCDataSourceBean.getJDBCDriverParams());
            this.pingDB(connection2);
            connection = connection2;
            Object var10_13 = null;
            if (initialContext == null) break block15;
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return connection;
        catch (NamingException namingException) {
            Connection connection5;
            block16: {
                try {
                    this.closeSQLConnection(connection2);
                    connection2 = this.createDirectConnection(jDBCDataSourceBean.getJDBCDriverParams());
                    this.pingDB(connection2);
                    connection5 = connection2;
                    Object var10_14 = null;
                    if (initialContext == null) break block16;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var10_15 = null;
                        if (initialContext == null) break block17;
                        try {
                            initialContext.close();
                        }
                        catch (NamingException namingException2) {}
                    }
                    throw throwable;
                }
                try {
                    initialContext.close();
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
            }
            return connection5;
        }
    }

    protected Connection getJDBCConnection() throws SQLException {
        if (DatabaseLeasingBasis.isMultipool(this.jdbcResource)) {
            SQLException sQLException = null;
            String string = this.jdbcResource.getJDBCResource().getJDBCDataSourceParams().getDataSourceList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getJDBCSystemResources();
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string2 = stringTokenizer.nextToken().trim();
                    for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                        JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBeanArray[i].getJDBCResource();
                        if (jDBCDataSourceBean == null || !string2.equals(jDBCDataSourceBean.getName())) continue;
                        return this.getJDBCConnection(jDBCSystemResourceMBeanArray[i]);
                    }
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
            throw new SQLException("No living database found!");
        }
        return this.getJDBCConnection(this.jdbcResource);
    }

    private Connection createDirectConnection(JDBCDriverParamsBean jDBCDriverParamsBean) throws SQLException {
        String string = jDBCDriverParamsBean.getDriverName();
        String string2 = jDBCDriverParamsBean.getPassword();
        Properties properties = JDBCUtil.getProperties((JDBCPropertyBean[])jDBCDriverParamsBean.getProperties().getProperties());
        if (properties != null && string2 != null) {
            properties.setProperty("password", string2);
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(null);
            Driver driver = (Driver)constructor.newInstance(null);
            Connection connection = driver.connect(jDBCDriverParamsBean.getUrl(), properties);
            if (connection == null) {
                throw new SQLException("Failed to get connection to the database due to bad configuration.");
            }
            return connection;
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            throw new SQLException("Failed to get connection to the database " + throwable.getMessage());
        }
    }

    public static LeasingBasis createBasis(ServerMBean serverMBean, JDBCSystemResourceMBean jDBCSystemResourceMBean, int n, String string) throws ServiceFailureException {
        DatabaseLeasingBasis.checkSystemResource(serverMBean, jDBCSystemResourceMBean);
        if (DatabaseLeasingBasis.isMultipool(jDBCSystemResourceMBean)) {
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
            String string2 = jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList();
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getJDBCSystemResources();
            JDBCSystemResourceMBean jDBCSystemResourceMBean2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                    JDBCDataSourceBean jDBCDataSourceBean2 = jDBCSystemResourceMBeanArray[i].getJDBCResource();
                    if (jDBCDataSourceBean2 == null || !string4.equals(jDBCDataSourceBean2.getName())) continue;
                    jDBCSystemResourceMBean2 = jDBCSystemResourceMBeanArray[i];
                    break;
                }
                if (jDBCSystemResourceMBean2 == null) {
                    ClusterLogger.logMissingJDBCConfigurationForAutoMigration((String)serverMBean.getName());
                    String string5 = "Invalid migratable server configuration. The pool named  " + string4 + " which is supposed to be a part of the multipool was not found. ";
                    throw new ServiceFailureException(string5);
                }
                DatabaseLeasingBasis.checkSystemResource(serverMBean, jDBCSystemResourceMBean2);
                if (string3 == null) {
                    string3 = jDBCDataSourceBean.getJDBCDriverParams().getDriverName();
                    continue;
                }
                if (string3.equals(jDBCDataSourceBean.getJDBCDriverParams().getDriverName())) continue;
                ClusterLogger.logMissingJDBCConfigurationForAutoMigration((String)serverMBean.getName());
                String string6 = "Invalid migratable server configuration. All pools in   a multipool for Singleton Services must have the same driver.";
                throw new ServiceFailureException(string6);
            }
        }
        return new DatabaseLeasingBasis(jDBCSystemResourceMBean, n, string);
    }

    private static String getDriverName(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        if (!DatabaseLeasingBasis.isMultipool(jDBCSystemResourceMBean)) {
            if (DEBUG) {
                DatabaseLeasingBasis.p("Driver for " + jDBCSystemResourceMBean + " is" + jDBCSystemResourceMBean.getJDBCResource().getJDBCDriverParams().getDriverName());
            }
            return jDBCSystemResourceMBean.getJDBCResource().getJDBCDriverParams().getDriverName();
        }
        String string = jDBCSystemResourceMBean.getJDBCResource().getJDBCDataSourceParams().getDataSourceList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getJDBCSystemResources();
        JDBCSystemResourceMBean jDBCSystemResourceMBean2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBeanArray[i].getJDBCResource();
                if (jDBCDataSourceBean == null || !string2.equals(jDBCDataSourceBean.getName())) continue;
                jDBCSystemResourceMBean2 = jDBCSystemResourceMBeanArray[i];
                return DatabaseLeasingBasis.getDriverName(jDBCSystemResourceMBean2);
            }
        }
        throw new AssertionError((Object)("No driver found for jdbc resource: " + jDBCSystemResourceMBean));
    }

    private static boolean isMultipool(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
        return jDBCDataSourceBean.getJDBCDriverParams().getDriverName() == null && jDBCDataSourceBean.getJDBCDataSourceParams() != null && jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null;
    }

    private static void checkSystemResource(ServerMBean serverMBean, JDBCSystemResourceMBean jDBCSystemResourceMBean) throws ServiceFailureException {
        if (jDBCSystemResourceMBean == null) {
            ClusterLogger.logMissingJDBCConfigurationForAutoMigration((String)serverMBean.getName());
            String string = "Invalid migratable server configuration. The  DataSourceForAutomaticMigration was not set. Please refer to cluster documents for more information";
            throw new ServiceFailureException(string);
        }
        JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
        String[] stringArray = jDBCDataSourceBean.getJDBCDataSourceParams().getJNDINames();
        if (stringArray == null || stringArray.length == 0) {
            ClusterLogger.logMissingJDBCConfigurationForAutoMigration((String)serverMBean.getName());
            throw new ServiceFailureException("Invalid migratable server configuration");
        }
        if (jDBCDataSourceBean.getJDBCDriverParams().getDriverName() == null && !DatabaseLeasingBasis.isMultipool(jDBCSystemResourceMBean)) {
            ClusterLogger.logMissingJDBCConfigurationForAutoMigration((String)serverMBean.getName());
            throw new ServiceFailureException("Invalid migratable server configuration, please use a fully-populated JDBC resource");
        }
    }

    private static final void p(String string) {
        MigrationDebugLogger.debug("<DatabaseLeasingBasis>: " + string);
    }
}

