/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.ArrayList;
import java.util.List;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.DomainMigrationHistory;
import weblogic.cluster.singleton.MigrationData;
import weblogic.cluster.singleton.MigrationDataRuntimeMBeanImpl;
import weblogic.cluster.singleton.ServiceMigrationDataRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.MigrationDataRuntimeMBean;
import weblogic.management.runtime.ServiceMigrationDataRuntimeMBean;

public class DomainMigrationHistoryImpl
implements DomainMigrationHistory {
    public static final DomainMigrationHistoryImpl THE_ONE = new DomainMigrationHistoryImpl();
    private List serverMigrationList = new ArrayList();
    private List serviceMigrationList = new ArrayList();

    private DomainMigrationHistoryImpl() {
    }

    public synchronized void update(MigrationData migrationData) {
        if (migrationData.getMigrationType().equals("server")) {
            MigrationDataRuntimeMBean[] migrationDataRuntimeMBeanArray = this.getMigrationDataRuntimes();
            if (migrationDataRuntimeMBeanArray != null) {
                for (int i = 0; i < migrationDataRuntimeMBeanArray.length; ++i) {
                    if (!migrationDataRuntimeMBeanArray[i].getServerName().equals(migrationData.getServerName()) || migrationDataRuntimeMBeanArray[i].getMigrationStartTime() != migrationData.getMigrationStartTime()) continue;
                    ((MigrationDataRuntimeMBeanImpl)migrationDataRuntimeMBeanArray[i]).update(migrationData);
                    return;
                }
            }
            try {
                this.serverMigrationList.add(new MigrationDataRuntimeMBeanImpl(migrationData));
            }
            catch (ManagementException managementException) {
                ClusterLogger.logErrorUpdatingMigrationRuntimeInfo((Exception)((Object)managementException));
            }
        } else if (migrationData.getMigrationType().equals("service")) {
            ServiceMigrationDataRuntimeMBean[] serviceMigrationDataRuntimeMBeanArray = this.getServiceMigrationDataRuntimes();
            if (serviceMigrationDataRuntimeMBeanArray != null) {
                for (int i = 0; i < serviceMigrationDataRuntimeMBeanArray.length; ++i) {
                    if (!serviceMigrationDataRuntimeMBeanArray[i].getServerName().equals(migrationData.getServerName()) || serviceMigrationDataRuntimeMBeanArray[i].getMigrationStartTime() != migrationData.getMigrationStartTime()) continue;
                    ((ServiceMigrationDataRuntimeMBeanImpl)serviceMigrationDataRuntimeMBeanArray[i]).update(migrationData);
                    return;
                }
            }
            try {
                this.serviceMigrationList.add(new ServiceMigrationDataRuntimeMBeanImpl(migrationData));
            }
            catch (ManagementException managementException) {
                ClusterLogger.logErrorUpdatingMigrationRuntimeInfo((Exception)((Object)managementException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ClusterLogger.logErrorUpdatingMigrationRuntimeInfo((Exception)illegalArgumentException);
            }
        } else {
            ClusterLogger.logUnknownMigrationDataType((String)migrationData.getMigrationType());
        }
    }

    public synchronized MigrationDataRuntimeMBean[] getMigrationDataRuntimes() {
        if (this.serverMigrationList.size() == 0) {
            return null;
        }
        MigrationDataRuntimeMBean[] migrationDataRuntimeMBeanArray = new MigrationDataRuntimeMBean[this.serverMigrationList.size()];
        this.serverMigrationList.toArray(migrationDataRuntimeMBeanArray);
        return migrationDataRuntimeMBeanArray;
    }

    public synchronized ServiceMigrationDataRuntimeMBean[] getServiceMigrationDataRuntimes() {
        if (this.serviceMigrationList.size() == 0) {
            return null;
        }
        ServiceMigrationDataRuntimeMBean[] serviceMigrationDataRuntimeMBeanArray = new ServiceMigrationDataRuntimeMBean[this.serviceMigrationList.size()];
        this.serviceMigrationList.toArray(serviceMigrationDataRuntimeMBeanArray);
        return serviceMigrationDataRuntimeMBeanArray;
    }
}

