/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.ClusterReformationInProgressException;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseObtainedListener;
import weblogic.cluster.singleton.Leasing;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class LeaseManager
implements Leasing,
NakedTimerListener,
MigratableServiceConstants {
    private LeasingBasis basis;
    private int heartbeatPeriod;
    private int healthCheckPeriod;
    private int gracePeriod;
    private Map leaseObtainedListeners;
    private Timer timer;
    private String leaseType;
    private ArrayList leaseLostListeners;
    private int missedHeartbeats = 0;
    private static volatile Set outstandingLeasesSet = new HashSet();
    private final Set myLeasesSet = new HashSet();
    private final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    public static final String FAILED = "WLS_FAILED_SERVICE";
    public static final String DELIMITER = ".";
    public static final String DIVIDER = "/";
    private boolean warnedAboutLazyTimer = false;
    private long lastTimerTime = 0L;

    public LeaseManager(LeasingBasis leasingBasis, int n, int n2, int n3, String string) {
        this.basis = leasingBasis;
        this.heartbeatPeriod = n;
        this.healthCheckPeriod = n2;
        this.gracePeriod = n3;
        this.leaseType = string;
        this.leaseObtainedListeners = new HashMap();
        this.leaseLostListeners = new ArrayList();
        this.lastTimerTime = System.currentTimeMillis();
    }

    public boolean tryAcquire(String string) throws LeasingException {
        Set set = outstandingLeasesSet;
        synchronized (set) {
            if (this.leaseObtainedListeners.containsKey(this.qualifyLeaseName(string))) {
                throw new LeasingException("Previously registered to obtain lease");
            }
            try {
                if (this.isCurrentOwner(string)) {
                    return true;
                }
                if (this.basis.acquire(this.qualifyLeaseName(string), LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()), this.healthCheckPeriod)) {
                    this.addToOutStandingLeasesSet(string);
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                throw new LeasingException("tryAcquire()", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(String string, LeaseObtainedListener leaseObtainedListener) throws LeasingException {
        Set set = outstandingLeasesSet;
        synchronized (set) {
            if (this.leaseObtainedListeners.containsKey(this.qualifyLeaseName(string))) {
                throw new LeasingException("Previously registered to obtain lease");
            }
            if (this.isCurrentOwner(string)) {
                leaseObtainedListener.onAcquire(string);
                if (!outstandingLeasesSet.contains(this.qualifyLeaseName(string))) {
                    this.addToOutStandingLeasesSet(string);
                }
                return;
            }
            try {
                if (this.basis.acquire(this.qualifyLeaseName(string), LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()), this.healthCheckPeriod)) {
                    this.addToOutStandingLeasesSet(string);
                    leaseObtainedListener.onAcquire(string);
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.leaseObtainedListeners.put(this.qualifyLeaseName(string), leaseObtainedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String string) throws LeasingException {
        Set set = outstandingLeasesSet;
        synchronized (set) {
            if (this.leaseObtainedListeners.containsKey(this.qualifyLeaseName(string))) {
                this.leaseObtainedListeners.remove(this.qualifyLeaseName(string));
                return;
            }
            try {
                this.basis.release(this.qualifyLeaseName(string), LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()));
                this.removeFromOutStandingLeasesSet(string);
                if (this.DEBUG) {
                    LeaseManager.p("release " + string + " successful");
                }
            }
            catch (IOException iOException) {
                try {
                    this.basis.release(this.qualifyLeaseName(string), "WLS_FAILED_SERVICE/" + LocalServerIdentity.getIdentity().getServerName());
                    return;
                }
                catch (IOException iOException2) {
                    if (this.DEBUG) {
                        LeaseManager.p("release " + string + " failed");
                    }
                    throw new LeasingException("release()", iOException);
                }
            }
        }
    }

    public String findOwner(String string) throws LeasingException {
        try {
            return this.basis.findOwner(this.qualifyLeaseName(string));
        }
        catch (IOException iOException) {
            throw new LeasingException("findOwner()", iOException);
        }
    }

    public String findPreviousOwner(String string) throws LeasingException {
        try {
            return this.basis.findPreviousOwner(this.qualifyLeaseName(string));
        }
        catch (IOException iOException) {
            throw new LeasingException("findPreviousOwner()", iOException);
        }
    }

    public static String getOwnerIdentity(ServerIdentity serverIdentity) {
        return serverIdentity.getTransientIdentity().getIdentityAsLong() + DIVIDER + serverIdentity.getServerName();
    }

    public static String getServerNameFromOwnerIdentity(String string) {
        return string.substring(string.indexOf(DIVIDER) + 1).trim();
    }

    private boolean isCurrentOwner(String string) {
        try {
            String string2 = this.basis.findOwner(this.qualifyLeaseName(string));
            if (string2 != null && string2.equals(LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()))) {
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    private String qualifyLeaseName(String string) {
        return this.leaseType + DELIMITER + string;
    }

    private String dequalifyLeaseName(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(string.lastIndexOf(DELIMITER) + 1, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeaseLostListener(LeaseLostListener leaseLostListener) {
        ArrayList arrayList = this.leaseLostListeners;
        synchronized (arrayList) {
            this.leaseLostListeners.add(leaseLostListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLeaseLostListener(LeaseLostListener leaseLostListener) {
        ArrayList arrayList = this.leaseLostListeners;
        synchronized (arrayList) {
            int n = this.leaseLostListeners.indexOf(leaseLostListener);
            if (n > -1) {
                this.leaseLostListeners.remove(n);
            }
        }
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    LeasingBasis getLeasingBasis() {
        return this.basis;
    }

    public String[] findExpiredLeases() {
        try {
            int n;
            String[] stringArray = this.basis.findExpiredLeases(this.gracePeriod);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith(this.leaseType)) continue;
                arrayList.add(stringArray[n]);
            }
            stringArray = new String[arrayList.size()];
            n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringArray[n] = this.dequalifyLeaseName((String)iterator.next());
                ++n;
            }
            return stringArray;
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        try {
            this.timer.cancel();
            this.basis.release(this.qualifyLeaseName(""), LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        WorkManager workManager = WorkManagerFactory.getInstance().findOrCreate("WorkManagerForAaronLeaseManagerPatch", 2, -1);
        this.timer = TimerManagerFactory.getTimerManagerFactory().getTimerManager("MigratableServerTimerManager", workManager).schedule((TimerListener)this, 0L, (long)this.heartbeatPeriod);
        this.lastTimerTime = System.currentTimeMillis();
    }

    public void voidLeases() {
        this.voidLeases(LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void voidLeases(String string) {
        if (this.DEBUG) {
            LeaseManager.p("Voiding leases for " + string);
        }
        Set set = outstandingLeasesSet;
        synchronized (set) {
            block7: {
                try {
                    this.basis.renewAllLeases(-this.healthCheckPeriod * 3, string);
                    if (this.DEBUG) {
                        LeaseManager.p("Successfully voided leases for " + string);
                    }
                }
                catch (Exception exception) {
                    if (!this.DEBUG) break block7;
                    LeaseManager.p("Failed voiding leases for " + string + ":" + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        block23: {
            long l = System.currentTimeMillis();
            if (l - this.lastTimerTime > (long)(this.healthCheckPeriod * 3) && !this.warnedAboutLazyTimer) {
                this.warnedAboutLazyTimer = true;
                ClusterLogger.logDelayedLeaseRenewal((long)((l - this.lastTimerTime) / 1000L));
            }
            this.lastTimerTime = l;
            Set set = outstandingLeasesSet;
            synchronized (set) {
                Iterator iterator = this.leaseObtainedListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    LeaseObtainedListener leaseObtainedListener = (LeaseObtainedListener)this.leaseObtainedListeners.get(string);
                    try {
                        if (!this.basis.acquire(string, LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()), this.healthCheckPeriod)) continue;
                        this.addToOutStandingLeasesSet(this.dequalifyLeaseName(string));
                        leaseObtainedListener.onAcquire(this.dequalifyLeaseName(string));
                        iterator.remove();
                    }
                    catch (IOException iOException) {
                        if (this.DEBUG) {
                            LeaseManager.p("IOException during lease checking: " + iOException);
                        }
                        leaseObtainedListener.onException(iOException, string);
                    }
                    catch (LeasingException leasingException) {
                        if (this.DEBUG) {
                            LeaseManager.p("LeasingException during lease checking: " + leasingException);
                        }
                        leaseObtainedListener.onException(leasingException, string);
                    }
                }
            }
            try {
                set = outstandingLeasesSet;
                synchronized (set) {
                    if (outstandingLeasesSet.size() == 0) {
                        return;
                    }
                    int n = this.basis.renewLeases(LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity()), outstandingLeasesSet, this.healthCheckPeriod);
                    if (n != outstandingLeasesSet.size()) {
                        this.warnedAboutLazyTimer = false;
                        LeaseManager.p("Signal Lease Lost because total leases renewed = " + n + " .Outstanding leases=" + outstandingLeasesSet);
                        this.signalLeaseLost();
                        this.removeOutstandingLeases();
                    } else if (this.warnedAboutLazyTimer) {
                        this.warnedAboutLazyTimer = false;
                        ClusterLogger.logLeaseRenewedAfterDelay();
                    }
                }
                this.missedHeartbeats = 0;
            }
            catch (ClusterReformationInProgressException clusterReformationInProgressException) {
                if (this.DEBUG) {
                    LeaseManager.p("Consensus leasing basis is in reformation. will NOT signal lease lost. exception:" + clusterReformationInProgressException.getMessage());
                }
            }
            catch (Exception exception) {
                ++this.missedHeartbeats;
                if (this.DEBUG) {
                    LeaseManager.p("missed heartbeat " + this.missedHeartbeats + ", " + this.basis.getClass().getName() + ": " + exception + ")");
                }
                if (this.missedHeartbeats * this.heartbeatPeriod < this.healthCheckPeriod) break block23;
                if (this.DEBUG) {
                    LeaseManager.p("Signal Lease Lost because of missed heartbeats beyond healthCheckPeriod (" + this.missedHeartbeats + ", " + (this.missedHeartbeats * this.heartbeatPeriod >= this.healthCheckPeriod) + ", " + this.basis.getClass().getName() + ": " + exception + ")");
                }
                this.signalLeaseLost();
                this.removeOutstandingLeases();
            }
        }
    }

    private void removeOutstandingLeases() {
        Iterator iterator = this.myLeasesSet.iterator();
        while (iterator.hasNext()) {
            outstandingLeasesSet.remove(iterator.next());
        }
        this.myLeasesSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalLeaseLost() {
        if (this.DEBUG) {
            LeaseManager.p("signalLeaseLost() called on " + this + " with leaseLostListeners: " + this.leaseLostListeners.size());
        }
        ArrayList arrayList = this.leaseLostListeners;
        synchronized (arrayList) {
            for (final LeaseLostListener leaseLostListener : this.leaseLostListeners) {
                if (this.DEBUG) {
                    LeaseManager.p("Notifying " + leaseLostListener + " of " + this.missedHeartbeats + " missed heartbeats.");
                }
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        leaseLostListener.onRelease();
                    }
                });
            }
        }
    }

    private void addToOutStandingLeasesSet(String string) {
        String string2 = this.qualifyLeaseName(string);
        outstandingLeasesSet.add(string2);
        this.myLeasesSet.add(string2);
        if (this.DEBUG) {
            LeaseManager.p("Added service " + string + " successfully. " + "Total outstanding leases = " + outstandingLeasesSet);
        }
    }

    private void removeFromOutStandingLeasesSet(String string) {
        String string2 = this.qualifyLeaseName(string);
        outstandingLeasesSet.remove(string2);
        this.myLeasesSet.remove(string2);
        if (this.DEBUG) {
            LeaseManager.p("Removed service " + string + " successfully. " + "Total outstanding leases = " + outstandingLeasesSet);
        }
    }

    private static final void p(String string) {
        SingletonServicesDebugLogger.debug("LeaseManager: " + string);
    }
}

