/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.HashMap;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingBasis;

public class LeaseManagerFactory {
    private static final LeaseManagerFactory singleton = new LeaseManagerFactory();
    private LeasingBasis basis;
    private int heartbeatPeriod;
    private int healthCheckPeriod;
    private int gracePeriod;
    private HashMap leaseManagers;

    private LeaseManagerFactory() {
    }

    public static LeaseManagerFactory singleton() {
        return singleton;
    }

    public void initialize(LeasingBasis leasingBasis, int n, int n2, int n3) {
        this.basis = leasingBasis;
        this.heartbeatPeriod = n;
        this.healthCheckPeriod = n2;
        this.gracePeriod = n3;
        this.leaseManagers = new HashMap();
    }

    public synchronized LeaseManager getLeaseManager(String string) {
        if (this.leaseManagers.get(string) != null) {
            return (LeaseManager)this.leaseManagers.get(string);
        }
        LeaseManager leaseManager = new LeaseManager(this.basis, this.heartbeatPeriod, this.healthCheckPeriod, this.gracePeriod, string);
        this.leaseManagers.put(string, leaseManager);
        return leaseManager;
    }
}

