/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.ClusterMaster;
import weblogic.cluster.singleton.ClusterMasterRemote;
import weblogic.cluster.singleton.ClusterReformationInProgressException;
import weblogic.cluster.singleton.DomainMigrationHistoryImpl;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseObtainedListener;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.QueryHelper;
import weblogic.cluster.singleton.QueryHelperImpl;
import weblogic.cluster.singleton.ServerMigrationCoordinator;
import weblogic.cluster.singleton.ServerMigrationCoordinatorImpl;
import weblogic.cluster.singleton.ServerMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.ServiceMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.SingletonMaster;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.health.HealthMonitorService;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.DomainAccessSettable;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.AddressUtils;
import weblogic.store.io.jdbc.JDBCHelper;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class MigratableServerService
extends AbstractServerService
implements MigratableServiceConstants,
LeaseLostListener,
PropertyChangeListener,
LeaseObtainedListener,
NakedTimerListener {
    private String serverName;
    private MachineMBean machine;
    private ServerMBean server;
    private boolean failedAndShouldMigrate = false;
    private boolean isMigratableServer;
    private boolean isMigratableCluster;
    private ClusterMaster clusterMaster;
    private SingletonMaster singletonMaster;
    private ServerMigrationCoordinator coordinator;
    private int triggerIntervalMillis;
    private int idlePeriodsUntilTimeout;
    private static final boolean DEBUG = MigrationDebugLogger.isDebugEnabled();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static MigratableServerService theMigratableServerService;
    private LeaseManager serverLeaseManager;
    private LeaseManager servicesLeaseManager;
    private String leasingType;
    private boolean clusterMasterUpdated = false;
    private Timer timer;
    private static final String UNRESOLVEABLE_JNDI_NAME = "__UNKNOWN";
    boolean BEADriver = false;

    public void initialize() throws ServiceFailureException {
        theMigratableServerService = this;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess.isAdminServer()) {
            this.coordinator = new ServerMigrationCoordinatorImpl();
            this.bindServerMigrationCoordinator(this.coordinator);
        }
        this.server = runtimeAccess.getServer();
        this.isMigratableServer = this.server.isAutoMigrationEnabled();
        ClusterMBean clusterMBean = this.server.getCluster();
        if (clusterMBean != null) {
            this.leasingType = clusterMBean.getMigrationBasis();
        }
        this.serverName = this.server.getName();
        this.triggerIntervalMillis = clusterMBean == null ? 0 : clusterMBean.getHealthCheckIntervalMillis();
        int n = this.idlePeriodsUntilTimeout = clusterMBean == null ? 0 : clusterMBean.getHealthCheckPeriodsUntilFencing();
        if (this.isMigratableServer && clusterMBean == null) {
            throw new ServiceFailureException("Migratable server is not part of a cluster");
        }
        if (this.isMigratableServer) {
            MigratableServerService.verifyMachineConfiguration(this.server);
            runtimeAccess.getServerRuntime().addPropertyChangeListener(this);
            this.machine = this.getCurrentMachine();
            if (this.machine == null) {
                throw new AssertionError((Object)"Failed to find the current machine");
            }
            runtimeAccess.getServerRuntime().setCurrentMachine(this.machine.getName());
        } else {
            this.machine = this.server.getMachine();
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("MigratableServerService.initialize() : Final current machine = " + this.machine);
            }
            if (this.machine == null) {
                runtimeAccess.getServerRuntime().setCurrentMachine("");
            } else {
                runtimeAccess.getServerRuntime().setCurrentMachine(this.machine.getName());
            }
        }
        boolean bl = this.isMigratableCluster = this.isMigratableServer || MigratableServerService.isMigratableCluster(clusterMBean);
        if (DEBUG) {
            MigratableServerService.p("Initializing migratable service: " + this.isMigratableCluster);
        }
        if (clusterMBean != null && ClusterService.getServices().getDefaultLeasingBasis() != null) {
            this.servicesLeaseManager = ClusterService.getServices().getDefaultLeaseManager("service");
            this.singletonMaster = new SingletonMaster(this.servicesLeaseManager, this.triggerIntervalMillis);
            this.servicesLeaseManager.start();
            SingletonServicesManager.getInstance().start();
        }
        if (this.isMigratableCluster) {
            try {
                this.serverLeaseManager = ClusterService.getServices().getDefaultLeaseManager("wlsserver");
                this.serverLeaseManager.start();
                this.clusterMaster = new ClusterMaster(this.triggerIntervalMillis);
            }
            catch (Throwable throwable) {
                throw new ServiceFailureException("Failed to start singleton service because of: " + throwable, throwable);
            }
        }
    }

    public String getLeasingType() {
        return this.leasingType;
    }

    public static MigratableServerService theOne() {
        return theMigratableServerService;
    }

    public boolean isClusterMaster() {
        if (this.clusterMaster == null) {
            return false;
        }
        return this.clusterMaster.isClusterMaster();
    }

    String findClusterMaster() throws LeasingException {
        if (this.isClusterMaster()) {
            return this.serverName;
        }
        if (this.servicesLeaseManager == null) {
            return null;
        }
        return this.unwrapServerID(this.servicesLeaseManager.findOwner("CLUSTER_MASTER"));
    }

    ClusterMasterRemote getClusterMasterRemote() throws LeasingException {
        if (this.isClusterMaster()) {
            return this.clusterMaster;
        }
        String string = this.findClusterMaster();
        return this.getClusterMaster(string);
    }

    public boolean isSingletonMaster() {
        if (this.singletonMaster == null) {
            return false;
        }
        return this.singletonMaster.isSingletonMaster();
    }

    public String findSingletonMaster() throws LeasingException {
        if (this.isSingletonMaster()) {
            return this.serverName;
        }
        if (this.servicesLeaseManager == null) {
            return null;
        }
        return this.unwrapServerID(this.servicesLeaseManager.findOwner("SINGLETON_MASTER"));
    }

    public SingletonMonitorRemote getSingletonMasterRemote() throws LeasingException {
        return this.getSingletonMasterRemote(1);
    }

    public SingletonMonitorRemote getSingletonMasterRemote(int n) throws LeasingException {
        if (this.isSingletonMaster()) {
            return this.singletonMaster.getSingletonMonitor();
        }
        String string = null;
        LeasingException leasingException = new LeasingException("No singleton master found");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                string = this.findSingletonMaster();
                SingletonMonitorRemote singletonMonitorRemote = this.getSingletonMaster(string);
                if (singletonMonitorRemote != null) {
                    return singletonMonitorRemote;
                }
                leasingException = new LeasingException("Could not contact singleton master: " + string);
                continue;
            }
            catch (LeasingException leasingException2) {
                leasingException = leasingException2;
                if (!DEBUG) continue;
                MigratableServerService.p("getSingletonMasterRemote Failed - " + leasingException2.getCause());
            }
        }
        throw leasingException;
    }

    public static String findURLOfUnconnectedServer(final String string) {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() {
                try {
                    String string2 = MigratableServerService.getURLSuggestion(string);
                    Environment environment = new Environment();
                    environment.setProviderUrl(string2);
                    Context context = environment.getInitialContext();
                    context.lookup(MigratableServerService.UNRESOLVEABLE_JNDI_NAME);
                    return null;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    return null;
                }
                catch (NamingException namingException) {
                    return namingException;
                }
            }
        };
        try {
            Object object = SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedExceptionAction)privilegedExceptionAction);
            if (object != null) {
                return null;
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new AssertionError((Object)privilegedActionException);
        }
        try {
            return URLManager.findAdministrationURL(string);
        }
        catch (java.rmi.UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static String getURLSuggestion(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(string);
        String string2 = serverMBean.getDefaultProtocol();
        String string3 = serverMBean.getListenAddress();
        if (string3 == null || string3.equals("")) {
            string3 = "localhost";
        }
        if (serverMBean.isListenPortEnabled()) {
            int n = serverMBean.getListenPort();
            if (DEBUG) {
                MigratableServerService.p("Chosen url: " + string2 + "://" + string3 + ":" + n);
            }
            return string2 + "://" + string3 + ":" + n;
        }
        if (serverMBean.getSSL() != null && serverMBean.getSSL().isEnabled()) {
            SSLMBean sSLMBean = serverMBean.getSSL();
            if (!string2.endsWith("s")) {
                string2 = string2 + "s";
            }
            int n = sSLMBean.getListenPort();
            if (DEBUG) {
                MigratableServerService.p("chosen SSL url: " + string2 + "://" + string3 + ":" + n);
            }
            return string2 + "://" + string3 + ":" + n;
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            if (!networkAccessPointMBeanArray[i].isEnabled()) continue;
            String string4 = networkAccessPointMBeanArray[i].getListenAddress();
            if (string4 != null && !string4.equals("")) {
                string3 = string4;
            }
            if (DEBUG) {
                MigratableServerService.p("chosen NAP url: " + networkAccessPointMBeanArray[i].getProtocol() + "://" + string3 + ":" + networkAccessPointMBeanArray[i].getListenPort());
            }
            return networkAccessPointMBeanArray[i].getProtocol() + "://" + string3 + ":" + networkAccessPointMBeanArray[i].getListenPort();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private SingletonMonitorRemote getSingletonMaster(String string) throws LeasingException {
        SingletonMonitorRemote singletonMonitorRemote;
        Context context;
        block15: {
            String string2;
            Environment environment;
            block13: {
                SingletonMonitorRemote singletonMonitorRemote2;
                block14: {
                    if (string == null) {
                        return null;
                    }
                    environment = new Environment();
                    context = null;
                    string2 = null;
                    try {
                        string2 = URLManager.findAdministrationURL(string);
                    }
                    catch (java.rmi.UnknownHostException unknownHostException) {
                        string2 = MigratableServerService.findURLOfUnconnectedServer(string);
                    }
                    if (string2 != null) break block13;
                    singletonMonitorRemote2 = null;
                    Object var7_9 = null;
                    if (context == null) break block14;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                return singletonMonitorRemote2;
            }
            if (DEBUG) {
                MigratableServerService.p("Looking up SingletonMonitorRemote on " + string + " with url " + string2);
            }
            environment.setProviderUrl(string2);
            context = environment.getInitialContext();
            singletonMonitorRemote = (SingletonMonitorRemote)context.lookup("weblogic/cluster/singleton/SingletonMonitorRemote");
            Object var7_10 = null;
            if (context == null) break block15;
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return singletonMonitorRemote;
        catch (NamingException namingException) {
            try {
                throw new LeasingException("Error connecting to Singleton Monitor at " + string + " : " + namingException, namingException);
            }
            catch (Throwable throwable) {
                block16: {
                    Object var7_11 = null;
                    if (context == null) break block16;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ClusterMasterRemote getClusterMaster(String string) {
        ClusterMasterRemote clusterMasterRemote;
        Context context;
        block15: {
            String string2;
            Environment environment;
            block13: {
                ClusterMasterRemote clusterMasterRemote2;
                block14: {
                    if (string == null) {
                        return null;
                    }
                    environment = new Environment();
                    context = null;
                    string2 = MigratableServerService.findURLOfUnconnectedServer(string);
                    if (DEBUG) {
                        MigratableServerService.p("Looking up " + string + " at " + string2);
                    }
                    if (string2 != null) break block13;
                    clusterMasterRemote2 = null;
                    Object var7_9 = null;
                    if (context == null) break block14;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                return clusterMasterRemote2;
            }
            environment.setProviderUrl(string2);
            context = environment.getInitialContext();
            clusterMasterRemote = (ClusterMasterRemote)context.lookup("weblogic/cluster/singleton/ClusterMasterRemote");
            Object var7_10 = null;
            if (context == null) break block15;
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return clusterMasterRemote;
        catch (NamingException namingException) {
            ClusterMasterRemote clusterMasterRemote3;
            block16: {
                try {
                    if (DEBUG) {
                        namingException.printStackTrace();
                    }
                    clusterMasterRemote3 = null;
                    Object var7_11 = null;
                    if (context == null) break block16;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var7_12 = null;
                        if (context == null) break block17;
                        try {
                            context.close();
                        }
                        catch (NamingException namingException2) {}
                    }
                    throw throwable;
                }
                try {
                    context.close();
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
            }
            return clusterMasterRemote3;
        }
    }

    private String unwrapServerID(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/") == -1) {
            return string;
        }
        return string.substring(string.indexOf("/") + 1, string.length());
    }

    private static void verifyMachineConfiguration(ServerMBean serverMBean) throws ServiceFailureException {
        int n;
        ClusterMBean clusterMBean = serverMBean.getCluster();
        MachineMBean[] machineMBeanArray = clusterMBean.getCandidateMachinesForMigratableServers();
        MachineMBean[] machineMBeanArray2 = serverMBean.getCandidateMachines();
        HashSet<MachineMBean> hashSet = new HashSet<MachineMBean>();
        if (machineMBeanArray2 == null && machineMBeanArray == null) {
            ClusterLogger.logMisconfiguredMigratableCluster();
            throw new ServiceFailureException("Invalid migratable cluster configuration");
        }
        if (machineMBeanArray2 != null) {
            for (n = 0; n < machineMBeanArray2.length; ++n) {
                hashSet.add(machineMBeanArray2[n]);
            }
        }
        if (machineMBeanArray != null) {
            for (n = 0; n < machineMBeanArray.length; ++n) {
                hashSet.add(machineMBeanArray[n]);
            }
        }
        if (hashSet.size() < 2) {
            ClusterLogger.logMigratableServerNotTargetToAMachine((String)serverMBean.getName());
        }
    }

    public void start() throws ServiceFailureException {
        if (DEBUG) {
            MigratableServerService.p("Starting migratable service");
        }
        this.initialize();
        this.initializeMigrationMonitoring();
        if (this.singletonMaster != null) {
            this.singletonMaster.start();
        }
        if (this.isMigratableCluster) {
            this.clusterMaster.start();
            this.serverLeaseManager.addLeaseLostListener(this);
        }
        if (!this.isMigratableServer) {
            return;
        }
        if (this.isConsensusLeasing()) {
            WorkManager workManager = WorkManagerFactory.getInstance().findOrCreate("WorkManagerForConsensusLeasing", 2, -1);
            this.timer = TimerManagerFactory.getTimerManagerFactory().getTimerManager("ConsensusLeasingTimerManager", workManager).schedule((TimerListener)this, 0L, (long)this.triggerIntervalMillis);
            if (this.timer.isCancelled()) {
                this.timer = null;
            }
        } else {
            boolean bl = false;
            try {
                bl = this.serverLeaseManager.tryAcquire(this.serverName);
                this.updateClusterMaster();
            }
            catch (LeasingException leasingException) {
                ClusterLogger.logDatabaseUnreachable((String)"startup", (String)"database");
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Failed to obtain lease: " + leasingException, leasingException);
                }
                throw new ServiceFailureException("There was a problem contacting the database: " + leasingException, (Throwable)leasingException);
            }
            if (!bl) {
                throw new ServiceFailureException("There is either a problem contacting the database or there is another instance of " + this.serverName + " running");
            }
        }
    }

    public void timerExpired(Timer timer) {
        block13: {
            try {
                String string = null;
                boolean bl = false;
                try {
                    string = this.serverLeaseManager.findOwner(this.serverName);
                    if (string == null) {
                        if (MigrationDebugLogger.isDebugEnabled()) {
                            MigrationDebugLogger.debug("Found no owner for " + this.serverName + ", will acquire server lease");
                        }
                        if (this.acquireServerLease()) {
                            this.updateClusterMaster();
                            this.stopTimer(timer);
                            return;
                        }
                        if (MigrationDebugLogger.isDebugEnabled()) {
                            MigrationDebugLogger.debug("Could not acquire available server lease for " + this.serverName + " at this time, will retry");
                        }
                        return;
                    }
                    if (MigrationDebugLogger.isDebugEnabled()) {
                        MigrationDebugLogger.debug("Another owner was found for lease of: " + this.serverName + ", other owner: " + string);
                    }
                    bl = true;
                }
                catch (LeasingException leasingException) {
                    Throwable throwable = leasingException.getCause();
                    if (throwable != null && throwable instanceof ClusterReformationInProgressException) {
                        if (MigrationDebugLogger.isDebugEnabled()) {
                            MigrationDebugLogger.debug("Using PrimordialLeasingBasis to find owner for " + this.serverName);
                        }
                        if ((string = this.serverLeaseManager.findOwner(this.serverName)) != null) {
                            bl = true;
                        }
                    }
                    throw leasingException;
                }
                if (bl) {
                    String string2 = "Another server " + string + " has the consensus lease for: " + this.serverName;
                    this.failShutDown(string2);
                }
            }
            catch (LeasingException leasingException) {
                if (!MigrationDebugLogger.isDebugEnabled()) break block13;
                MigrationDebugLogger.debug("Got exception trying to obtain consensus lease: " + this.serverName, leasingException);
            }
        }
    }

    private void failShutDown(String string) {
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug(string);
        }
        try {
            this.stop();
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
        HealthMonitorService.subsystemFailedForceShutdown("MigratableServerService", string);
    }

    private synchronized void stopTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
        }
        if (this.timer != null) {
            this.timer = null;
        }
    }

    private boolean acquireServerLease() throws LeasingException {
        boolean bl = false;
        if (this.serverLeaseManager.tryAcquire(this.serverName)) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("MigratableServerService has obtained the consensus lease for: " + this.serverName + "\nWill cancel the timer and add the LeaseListener");
            }
            bl = true;
        }
        return bl;
    }

    private void initializeMigrationMonitoring() throws ServiceFailureException {
        try {
            ServerMigrationRuntimeMBeanImpl.initialize();
            ServiceMigrationRuntimeMBeanImpl.initialize();
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (runtimeAccess.isAdminServer()) {
                ((DomainAccessSettable)((Object)ManagementService.getDomainAccess(kernelId))).setDomainMigrationHistory(DomainMigrationHistoryImpl.THE_ONE);
                ServerHelper.exportObject((Remote)DomainMigrationHistoryImpl.THE_ONE);
            }
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        block6: {
            this.stopTimer(this.timer);
            if (this.singletonMaster != null) {
                this.singletonMaster.stop();
            }
            SingletonServicesManager.getInstance().stop();
            if (this.isMigratableCluster) {
                this.servicesLeaseManager.voidLeases();
                this.serverLeaseManager.stop();
            }
            if (!this.isMigratableServer) {
                return;
            }
            if (this.failedAndShouldMigrate) {
                return;
            }
            try {
                this.serverLeaseManager.release(this.serverName);
            }
            catch (LeasingException leasingException) {
                ClusterLogger.logDatabaseUnreachable((String)"shutdown", (String)this.getLeaseBasisLocation());
                if (!MigrationDebugLogger.isDebugEnabled()) break block6;
                MigrationDebugLogger.debug("Failed to obtain lease: " + leasingException, leasingException);
            }
        }
    }

    private boolean isConsensusLeasing() {
        return "consensus".equalsIgnoreCase(this.server.getCluster().getMigrationBasis());
    }

    private String getLeaseBasisLocation() {
        if (this.isConsensusLeasing()) {
            String string = AbstractConsensusService.getInstance().getLeasingBasisLocation();
            return string != null ? "leasing basis hosted by " + string : "consensus leasing basis";
        }
        return "database";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if ("State".equals(propertyChangeEvent.getPropertyName()) && "FAILED".equals(string = (String)propertyChangeEvent.getNewValue())) {
            this.failedAndShouldMigrate = true;
        }
    }

    private void bindServerMigrationCoordinator(final ServerMigrationCoordinator serverMigrationCoordinator) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    Context context = null;
                    try {
                        try {
                            Environment environment = new Environment();
                            environment.setCreateIntermediateContexts(true);
                            context = environment.getInitialContext();
                            context.bind("weblogic/cluster/singleton/ServerMigrationCoordinator", (Object)serverMigrationCoordinator);
                        }
                        catch (NamingException namingException) {
                            throw new AssertionError((Object)("Unexpected exception" + namingException));
                        }
                        Object var4_4 = null;
                        if (context == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (context == null) throw throwable;
                        try {
                            context.close();
                            throw throwable;
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {}
                    context.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Unexpected exception" + exception));
        }
    }

    private MachineMBean getConfiguredMachine() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(this.serverName).getMachine();
    }

    private boolean isLocalMachine(MachineMBean machineMBean) throws UnknownHostException {
        NodeManagerMBean nodeManagerMBean = machineMBean.getNodeManager();
        if (nodeManagerMBean == null) {
            return true;
        }
        InetAddress inetAddress = InetAddress.getByName(nodeManagerMBean.getListenAddress());
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("MigratableServerService.isLocalMachine() : Inet address = " + inetAddress);
        }
        for (int i = 0; i < AddressUtils.getIPAny().length; ++i) {
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("MigratableServerService.isLocalMachine() : AddressUtils.getIPAny[" + i + "]=" + AddressUtils.getIPAny()[i]);
            }
            if (!inetAddress.equals(AddressUtils.getIPAny()[i])) continue;
            MigrationDebugLogger.debug("MigratableServerService.isLocalMachine() : selected " + machineMBean);
            return true;
        }
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("MigratableServerService.isLocalMachine() : returned false");
        }
        return false;
    }

    public MachineMBean getCurrentMachine() {
        try {
            MachineMBean machineMBean = this.getConfiguredMachine();
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("MigratableServerService.getCurrentMachine() : configured machine = " + machineMBean);
            }
            if (machineMBean == null) {
                return null;
            }
            if (this.isLocalMachine(machineMBean)) {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("MigratableServerService.getCurrentMachine() : configured machine = " + machineMBean + " matches machine from local list ");
                }
                return machineMBean;
            }
            MachineMBean[] machineMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getMachines();
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug("MigratableServerService.getCurrentMachine() : now going to domain mbean to get list of machines = " + machineMBeanArray);
            }
            for (int i = 0; i < machineMBeanArray.length; ++i) {
                if (!this.isLocalMachine(machineMBeanArray[i])) continue;
                return machineMBeanArray[i];
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)("Unexpected exception" + unknownHostException));
        }
        return null;
    }

    private static boolean isMigratableCluster(ClusterMBean clusterMBean) {
        if (clusterMBean == null) {
            return false;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].isAutoMigrationEnabled()) continue;
            return true;
        }
        return false;
    }

    public void onRelease() {
        ClusterLogger.logServerFailedtoRenewLease((String)this.serverName, (String)this.getLeaseBasisLocation());
        ClusterLogger.logDatabaseUnreachableForLeaseRenewal((int)(this.idlePeriodsUntilTimeout * this.triggerIntervalMillis / 1000), (String)this.getLeaseBasisLocation());
        HealthMonitorService.subsystemFailedForceShutdown("ServerMigration", "Server" + this.serverName + " failed to renew lease in the " + this.getLeaseBasisLocation());
    }

    boolean isBEADriver() {
        return this.BEADriver;
    }

    QueryHelper identifyVendorSpecificQuery(String string, Connection connection) {
        Object object;
        String string2 = this.server.getCluster().getSingletonSQLQueryHelper();
        String string3 = this.server.getParent().getName();
        String string4 = this.server.getCluster().getName();
        try {
            object = connection.getMetaData().getDriverName().toLowerCase(Locale.ENGLISH);
            if (!((String)object).startsWith("oracle jdbc")) {
                this.BEADriver = true;
            }
        }
        catch (SQLException sQLException) {
            throw new AssertionError((Object)("Could not contact database to get vendor and version: " + sQLException));
        }
        if (string2 != null && string2.length() > 0) {
            try {
                object = Class.forName(string2);
                Constructor constructor = ((Class)object).getConstructor(null);
                QueryHelper queryHelper = (QueryHelper)constructor.newInstance(null);
                queryHelper.init(string, string3, string4, JDBCHelper.getDBMSType((DatabaseMetaData)connection.getMetaData(), null));
                return queryHelper;
            }
            catch (Throwable throwable) {
                ClusterLogger.logUnableToLoadCustomQueryHelper((String)string2, (Throwable)throwable);
                AssertionError assertionError = new AssertionError((Object)("Failed to load " + string2 + " because of " + throwable));
                ((Throwable)((Object)assertionError)).initCause(throwable);
                throw assertionError;
            }
        }
        try {
            return new QueryHelperImpl(string, string3, string4, JDBCHelper.getDBMSType((DatabaseMetaData)connection.getMetaData(), null));
        }
        catch (SQLException sQLException) {
            throw new AssertionError((Object)("Could not contact database to get vendor and version: " + sQLException));
        }
    }

    private static final void p(String string) {
        System.out.println("<MigratableServerService>: " + string);
    }

    public void onAcquire(String string) {
        this.updateClusterMaster();
    }

    public void onException(Exception exception, String string) {
    }

    private void updateClusterMaster() {
        block6: {
            if (this.clusterMasterUpdated) {
                return;
            }
            try {
                ClusterMasterRemote clusterMasterRemote = this.getClusterMasterRemote();
                if (clusterMasterRemote != null) {
                    clusterMasterRemote.setServerLocation(this.serverName, this.machine.getName());
                }
                this.clusterMasterUpdated = true;
            }
            catch (LeasingException leasingException) {
                if (DEBUG) {
                    leasingException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block6;
                remoteException.printStackTrace();
            }
        }
    }

    public void notifySingletonMasterShutdown() {
        block4: {
            try {
                SingletonMonitorRemote singletonMonitorRemote = this.getSingletonMasterRemote();
                if (DEBUG) {
                    MigratableServerService.p("MigratabaleServerService.notifyClusterMasterShutdown server: " + this.serverName + ", ClusterMaster: " + this.clusterMaster);
                }
                if (singletonMonitorRemote != null) {
                    singletonMonitorRemote.notifyShutdown(this.serverName);
                }
            }
            catch (LeasingException leasingException) {
                if (!DEBUG) break block4;
                MigratableServerService.p(leasingException.toString());
            }
        }
    }
}

