/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Vector;
import weblogic.cluster.singleton.MigratableServersMonitorImpl;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.ServerMigrationException;
import weblogic.cluster.singleton.ServerMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.SingletonLogger;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManagerFactory;

final class MigratableServerState {
    private static final boolean DEBUG = MigrationDebugLogger.isDebugEnabled();
    private final ServerMBean server;
    private final Vector candidateMachines;
    private MachineMBean currentMachine;
    private MachineMBean previousMachine;
    private int serverMigrationAttemptsCount = 0;
    private int numberOfTimesAllMachinesTriedCount = 0;
    private final RestartTask task;
    private MigratableServersMonitorImpl monitor;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MigratableServerState(ServerMBean serverMBean, MachineMBean machineMBean, MigratableServersMonitorImpl migratableServersMonitorImpl) {
        this.server = serverMBean;
        this.candidateMachines = MigratableServerState.getCandidateMachines(serverMBean);
        this.currentMachine = machineMBean;
        this.task = new RestartTask(this);
        this.monitor = migratableServersMonitorImpl;
    }

    public String toString() {
        return this.server + " on " + this.currentMachine;
    }

    private static Vector getCandidateMachines(ServerMBean serverMBean) {
        int n;
        HashSet<MachineMBean> hashSet = new HashSet<MachineMBean>();
        MachineMBean[] machineMBeanArray = serverMBean.getCandidateMachines();
        if (machineMBeanArray != null) {
            for (n = 0; n < machineMBeanArray.length; ++n) {
                hashSet.add(machineMBeanArray[n]);
            }
        }
        if ((machineMBeanArray = serverMBean.getCluster().getCandidateMachinesForMigratableServers()) != null) {
            for (n = 0; n < machineMBeanArray.length; ++n) {
                hashSet.add(machineMBeanArray[n]);
            }
        }
        return new Vector(hashSet);
    }

    public ServerMBean getServer() {
        return this.server;
    }

    MachineMBean getCurrentMachine() {
        return this.currentMachine;
    }

    MachineMBean getPreviousMachine() {
        return this.previousMachine;
    }

    private void migrateToANewMachine() {
        if (this.candidateMachines.size() <= 0) {
            return;
        }
        ++this.serverMigrationAttemptsCount;
        int n = this.candidateMachines.indexOf(this.currentMachine);
        int n2 = (n + 1) % this.candidateMachines.size();
        this.previousMachine = this.currentMachine;
        this.currentMachine = (MachineMBean)this.candidateMachines.get(n2);
        if (DEBUG) {
            MigratableServerState.p(this.server + " is migrating from " + this.previousMachine + " to " + this.currentMachine);
        }
        try {
            this.monitor.setServerLocation(this.server.getName(), this.currentMachine.getName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void serverUnresponsive() throws ServerMigrationException {
        if (this.serverMigrationAttemptsCount > this.candidateMachines.size()) {
            throw new ServerMigrationException("Failed to start the migratable server on one of the candidate machines", null);
        }
        if (!this.task.isTaskRunning()) {
            this.task.changeRunningState(true);
            String string = this.monitor.getCurrentMachine(this.server.getName());
            if (string != null && !string.equals(this.getCurrentMachine().getName())) {
                this.currentMachine = this.monitor.getMachine(string);
                if (DEBUG) {
                    MigratableServerState.p("Resetting MigratableServerState current machine to  " + string + " for server " + this.server);
                }
            }
            if (DEBUG) {
                MigratableServerState.p("Restarting server " + this.server);
            }
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)this.task);
        }
    }

    private boolean isRestartable() {
        if (this.serverMigrationAttemptsCount != 0 && this.serverMigrationAttemptsCount % this.candidateMachines.size() == 0) {
            try {
                Thread.sleep(this.getMillisToSleepBetweenRetryAttempts());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getAdditionalRetryAttempts() == -1) {
            return true;
        }
        return this.serverMigrationAttemptsCount <= this.candidateMachines.size() * (this.getAdditionalRetryAttempts() + 1);
    }

    private void startServer() throws IOException {
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(this.getCurrentMachine());
        ServerMigrationRuntimeMBeanImpl.getInstance().migrationStarted(this);
        try {
            if (DEBUG) {
                MigratableServerState.p("Sending start command to nm for " + this.server);
            }
            nodeManagerRuntime.start(this.server).waitForFinish();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void migrationComplete() {
        this.markAsMigratableAgain();
        ServerMigrationRuntimeMBeanImpl.getInstance().migrationCompleted(this);
    }

    void markAsMigratableAgain() {
        this.serverMigrationAttemptsCount = 0;
    }

    private String getCurrentStatus() {
        try {
            return NodeManagerRuntime.getInstance(this.getCurrentMachine()).getState(this.server);
        }
        catch (IOException iOException) {
            return "UNKNOWN";
        }
    }

    private int getAdditionalRetryAttempts() {
        return this.server.getCluster().getAdditionalAutoMigrationAttempts();
    }

    private long getMillisToSleepBetweenRetryAttempts() {
        return this.server.getCluster().getMillisToSleepBetweenAutoMigrationAttempts();
    }

    private static void p(Object object) {
        System.out.println("<MigratableServerState> " + object);
    }

    private static class RestartTask
    implements Runnable {
        private final MigratableServerState serverState;
        private boolean isTaskRunning = false;

        private RestartTask(MigratableServerState migratableServerState) {
            this.serverState = migratableServerState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string = this.serverState.getCurrentStatus();
                if (DEBUG) {
                    MigratableServerState.p("Current status of " + this.serverState + " is " + string);
                }
                if (string.equals("RUNNING")) {
                    this.serverState.migrationComplete();
                    Object var5_2 = null;
                    this.changeRunningState(false);
                    return;
                }
                MachineMBean machineMBean = this.serverState.currentMachine;
                while (string.equals("UNKNOWN") || string.equals("FAILED_NOT_RESTARTABLE")) {
                    block11: {
                        try {
                            if (DEBUG) {
                                MigratableServerState.p("Current status of " + this.serverState + " is " + string);
                            }
                            if (DEBUG) {
                                MigratableServerState.p(this.serverState + " is restartable? " + this.serverState.isRestartable());
                            }
                            if (this.serverState.isRestartable()) {
                                SingletonLogger.logServerMigrationStarting((String)this.serverState.server.getName(), (String)machineMBean.getName(), (String)this.serverState.currentMachine.getName());
                                this.serverState.migrateToANewMachine();
                                this.serverState.startServer();
                                break block11;
                            }
                            SingletonLogger.logServerMigrationFailed((String)this.serverState.server.getName(), (String)machineMBean.getName());
                            break;
                        }
                        catch (IOException iOException) {
                            SingletonLogger.logServerMigrationTargetUnreachable((String)this.serverState.server.getName(), (String)machineMBean.getName(), (String)this.serverState.currentMachine.getName());
                        }
                    }
                    string = this.serverState.getCurrentStatus();
                }
                if (string.equals("RUNNING")) {
                    SingletonLogger.logServerMigrationFinished((String)this.serverState.server.getName(), (String)machineMBean.getName(), (String)this.serverState.currentMachine.getName());
                    this.serverState.migrationComplete();
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.changeRunningState(false);
                throw throwable;
            }
            Object var5_3 = null;
            this.changeRunningState(false);
        }

        private synchronized void changeRunningState(boolean bl) {
            this.isTaskRunning = bl;
        }

        private synchronized boolean isTaskRunning() {
            return this.isTaskRunning;
        }
    }
}

