/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Set;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.MigratableServerState;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.ServerMigrationException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.collections.ConcurrentHashMap;

class MigratableServersMonitorImpl
implements NakedTimerListener,
MigratableServiceConstants {
    public static final String LEASE_TYPE = "wlsserver";
    private final boolean DEBUG = MigrationDebugLogger.isDebugEnabled();
    private final int leaseRenewInterval;
    private Timer timer;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private HashMap serverMachineTable;
    private final ConcurrentHashMap migratableServerMap = new ConcurrentHashMap();
    private ConcurrentHashMap previouslyUnresponsiveServers;
    private TimerManager timerManager = null;
    private final LeaseManager manager;

    MigratableServersMonitorImpl(LeaseManager leaseManager, int n) {
        this.manager = leaseManager;
        this.leaseRenewInterval = n;
        this.previouslyUnresponsiveServers = new ConcurrentHashMap();
        this.serverMachineTable = new HashMap();
    }

    void start() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        MachineMBean[] machineMBeanArray = domainMBean.getMachines();
        ClusterMBean clusterMBean = domainMBean.lookupServer(LocalServerIdentity.getIdentity().getServerName()).getCluster();
        if (this.DEBUG) {
            this.p("Processing Cluster " + clusterMBean.getName());
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        block2: for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (this.DEBUG) {
                this.p("Processing Machine " + machineMBeanArray[i].getName());
            }
            NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBeanArray[i]);
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                String string;
                if (this.DEBUG) {
                    this.p("Processing Server[" + j + "] " + serverMBeanArray[j].getName());
                }
                if (!serverMBeanArray[j].isAutoMigrationEnabled()) {
                    if (!this.DEBUG) continue;
                    this.p("Skipping server with Auto Migration Diabled " + serverMBeanArray[j].toString());
                    continue;
                }
                try {
                    string = nodeManagerRuntime.getState(serverMBeanArray[j]);
                }
                catch (IOException iOException) {
                    if (!this.DEBUG) continue block2;
                    this.p("IOException from machine " + machineMBeanArray[i].getName());
                    continue block2;
                }
                if (string.indexOf("FAILED") == -1 && string.indexOf("SHUTDOWN") == -1 && string.indexOf("UNKNOWN") == -1) {
                    if (this.serverMachineTable.get(serverMBeanArray[j].getName()) == null) {
                        ClusterLogger.logMonitoringMigratableServer((String)serverMBeanArray[j].getName());
                    }
                    this.serverMachineTable.put(serverMBeanArray[j].getName(), machineMBeanArray[i].getName());
                    if (!this.DEBUG) continue;
                    this.p("Found " + serverMBeanArray[j] + " living on " + machineMBeanArray[i]);
                    continue;
                }
                if (!this.DEBUG) continue;
                this.p(serverMBeanArray[j] + " is not active on " + machineMBeanArray[i]);
            }
        }
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("SingletonServiceTimerManager", "weblogic.kernel.System");
        this.timer = this.timerManager.schedule((TimerListener)this, 0L, (long)this.leaseRenewInterval);
    }

    void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void timerExpired(Timer timer) {
        String[] stringArray = this.manager.findExpiredLeases();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            if ("CLUSTER_MASTER".equals(stringArray[i]) || "SINGLETON_MASTER".equals(stringArray[i])) continue;
            concurrentHashMap.put((Object)stringArray[i], (Object)stringArray[i]);
            this.previouslyUnresponsiveServers.remove((Object)stringArray[i]);
            MigratableServerState migratableServerState = this.findOrCreateMigratableServerStateInfo(stringArray[i]);
            if (migratableServerState == null) continue;
            try {
                if (this.DEBUG) {
                    this.p("Sending server-unresponsive to " + migratableServerState);
                }
                migratableServerState.serverUnresponsive();
                continue;
            }
            catch (ServerMigrationException serverMigrationException) {
                ClusterLogger.logFailedToAutomaticallyMigrateServers2((String)migratableServerState.getServer().getName(), (Exception)serverMigrationException);
            }
        }
        Set set = this.previouslyUnresponsiveServers.keySet();
        for (String string : set) {
            MigratableServerState migratableServerState;
            if ("CLUSTER_MASTER".equals(string) || (migratableServerState = this.findOrCreateMigratableServerStateInfo(string)) == null) continue;
            migratableServerState.markAsMigratableAgain();
            try {
                migratableServerState.serverUnresponsive();
            }
            catch (ServerMigrationException serverMigrationException) {
                ClusterLogger.logFailedToAutomaticallyMigrateServers2((String)migratableServerState.getServer().getName(), (Exception)serverMigrationException);
            }
        }
        this.previouslyUnresponsiveServers = concurrentHashMap;
    }

    private MigratableServerState findOrCreateMigratableServerStateInfo(String string) {
        MigratableServerState migratableServerState = (MigratableServerState)this.migratableServerMap.get((Object)string);
        if (migratableServerState == null) {
            migratableServerState = this.createMigratableServerStateInfo(string);
            if (migratableServerState == null) {
                return null;
            }
            this.migratableServerMap.put((Object)string, (Object)migratableServerState);
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug(string + " failed to renew its lease");
            }
        }
        return migratableServerState;
    }

    private MigratableServerState createMigratableServerStateInfo(String string) {
        String string2 = this.getCurrentMachine(string);
        if (string2 == null) {
            return null;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        MachineMBean machineMBean = this.getMachine(domainMBean, string2);
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        if (serverMBean == null || machineMBean == null) {
            return null;
        }
        return new MigratableServerState(serverMBean, machineMBean, this);
    }

    public synchronized void setServerLocation(String string, String string2) throws RemoteException {
        if (this.serverMachineTable.get(string) == null) {
            ClusterLogger.logMonitoringMigratableServer((String)string);
        }
        this.serverMachineTable.put(string, string2);
        if (this.DEBUG) {
            this.p("Got a report: " + string + " is now on " + string2);
        }
    }

    public synchronized String getCurrentMachine(String string) {
        String string2 = (String)this.serverMachineTable.get(string);
        if (string2 != null) {
            return string2;
        }
        return this.getConfiguredMachine(string);
    }

    private String getConfiguredMachine(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(string);
        if (serverMBean == null) {
            return null;
        }
        if (serverMBean.getMachine() == null) {
            return null;
        }
        return serverMBean.getMachine().getName();
    }

    private void p(Object object) {
        System.out.println("<MigratableServersMonitorImpl> " + object);
    }

    MachineMBean getMachine(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return this.getMachine(domainMBean, string);
    }

    private MachineMBean getMachine(DomainMBean domainMBean, String string) {
        return domainMBean.lookupMachine(string);
    }
}

