/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import weblogic.cluster.singleton.MigrationData;
import weblogic.management.ManagementException;
import weblogic.management.runtime.MigrationDataRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public class MigrationDataRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements MigrationDataRuntimeMBean {
    private static int count;
    private String serverName;
    private String clusterMasterName;
    private String machineMigratedTo;
    private String machineMigratedFrom;
    private String clusterName;
    private int status;
    private long startTime;
    private long endTime;
    private String[] machinesAttempted;

    MigrationDataRuntimeMBeanImpl(RuntimeMBean runtimeMBean, MigrationData migrationData) throws ManagementException {
        super("MigrationData-" + migrationData.getServerName() + migrationData.getMigrationStartTime(), runtimeMBean, true);
        this.initialize(migrationData);
    }

    public MigrationDataRuntimeMBeanImpl(MigrationData migrationData) throws ManagementException {
        super("MigrationData-" + migrationData.getServerName() + migrationData.getMigrationStartTime());
        this.initialize(migrationData);
    }

    void initialize(MigrationData migrationData) {
        this.serverName = migrationData.getServerName();
        this.machineMigratedFrom = migrationData.getMachineMigratedFrom();
        this.machineMigratedTo = migrationData.getMachineMigratedTo();
        this.clusterMasterName = migrationData.getClusterMasterName();
        this.clusterName = migrationData.getClusterName();
        this.status = 1;
        this.startTime = migrationData.getMigrationStartTime();
        this.machinesAttempted = new String[1];
        this.machinesAttempted[0] = this.machineMigratedTo;
    }

    private static synchronized int getCount() {
        return count++;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMachineMigratedFrom() {
        return this.machineMigratedFrom;
    }

    public synchronized String[] getMachinesAttempted() {
        return this.machinesAttempted;
    }

    public String getMachineMigratedTo() {
        return this.machineMigratedTo;
    }

    public long getMigrationStartTime() {
        return this.startTime;
    }

    public long getMigrationEndTime() {
        return this.endTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterMasterName() {
        return this.clusterMasterName;
    }

    public synchronized void update(MigrationData migrationData) {
        this.machineMigratedFrom = migrationData.getMachineMigratedFrom();
        this.machineMigratedTo = migrationData.getMachineMigratedTo();
        this.status = migrationData.getStatus();
        if (this.status == 1) {
            String[] stringArray = this.machinesAttempted;
            this.machinesAttempted = new String[this.machinesAttempted.length + 1];
            System.arraycopy(stringArray, 0, this.machinesAttempted, 0, stringArray.length);
            this.machinesAttempted[this.machinesAttempted.length - 1] = this.machineMigratedTo;
        }
        this.endTime = migrationData.getMigrationEndTime();
    }
}

