/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.Locale;
import weblogic.cluster.singleton.QueryHelper;
import weblogic.cluster.singleton.QueryHelperImpl;

public class QueryDumper {
    public static final String TABLE_NAME = "dummyTable";
    public static final String MACHINE_TABLE_NAME = "dummyMachineTable";
    public static final String LEASE_NAME = "dummyLease";
    public static final int LEASE_TIMEOUT = 15;

    private static int getDBType(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.indexOf("oracle") != -1) {
                return 1;
            }
            if (string.indexOf("sybase") != -1) {
                return 3;
            }
            if (string.indexOf("microsoft") != -1 || string.indexOf("mssql") != -1) {
                return 4;
            }
            if (string.indexOf("informix") != -1) {
                return 5;
            }
            if (string.indexOf("db2") != -1) {
                return 6;
            }
            if (string.indexOf("mysql") != -1) {
                return 9;
            }
            if (string.indexOf("timesten") != -1) {
                return 7;
            }
            return 0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        QueryHelper queryHelper;
        if (stringArray.length < 1) {
            System.out.println("err: " + stringArray);
            System.exit(1);
        }
        if ((queryHelper = QueryDumper.getQueryHelper(string = stringArray[0], TABLE_NAME, "dummyDomain", "dummyCluster", QueryDumper.getDBType(stringArray[1]))) == null) {
            System.out.println("no query helper");
            System.exit(2);
        }
        String string2 = new String("165L/server1");
        String string3 = null;
        string3 = queryHelper.getAcquireLeaseQuery(LEASE_NAME, string2);
        System.out.println("getAcquireLeaseQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getAssumeLeaseQuery(LEASE_NAME, string2, 15);
        System.out.println("getAssumeLeaseQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getRenewLeaseQuery(LEASE_NAME, string2, 15);
        System.out.println("getRenewLeaseQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getAbdicateLeaseQuery(LEASE_NAME, string2);
        System.out.println("getAbdicateLeaseQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getRenewAllLeasesQuery(string2, 15);
        System.out.println("getRenewAllLeasesQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getLeaseOwnerQuery(LEASE_NAME);
        System.out.println("getLeaseOwnerQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getUnresponsiveMigratableServersQuery(60);
        System.out.println("getUnresponsiveMigratableServersQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getDeleteMachineQuery("dummyServer", MACHINE_TABLE_NAME);
        System.out.println("getDeleteMachineQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getInsertMachineQuery("dummyServer", "dummyMachine", MACHINE_TABLE_NAME);
        System.out.println("getInsertMachineQuery: \n\t" + string3 + "\n");
        string3 = queryHelper.getRetrieveMachineQuery("dummyServer", MACHINE_TABLE_NAME);
        System.out.println("getRetrieveMachineQuery: \n\t" + string3 + "\n");
    }

    private static QueryHelper getQueryHelper(String string, String string2, String string3, String string4, int n) {
        try {
            return new QueryHelperImpl(string2, string3, string4, n);
        }
        catch (Throwable throwable) {
            System.out.println("Error creating " + string + ": " + throwable);
            throwable.printStackTrace();
            return null;
        }
    }
}

