/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.util.Iterator;
import java.util.Set;

public abstract class QueryHelper {
    public static String TIME_AS_FRACTION_OF_DAY = "";
    private String TABLE_NAME;
    private String COLUMN_NAMES;
    private String INSERT_VALUES;
    private String WHERE_CLAUSE;
    private String SYSDATE;
    private String domainName;
    private String clusterName;
    private int dbType;

    public QueryHelper(String string, String string2, String string3, int n) {
        this.init(string, string2, string3, n);
    }

    public QueryHelper() {
    }

    protected void init(String string, String string2, String string3, int n) {
        this.dbType = n;
        this.TABLE_NAME = string;
        this.domainName = string2;
        this.clusterName = string3;
        if (n == 1 || n == 7) {
            TIME_AS_FRACTION_OF_DAY = "/86400";
        }
        this.INSERT_VALUES = ", '" + string2 + "' , '" + string3 + "' ";
        this.WHERE_CLAUSE = " AND DOMAINNAME='" + string2 + "' AND CLUSTERNAME='" + string3 + "'";
        this.COLUMN_NAMES = " ( SERVER, INSTANCE, DOMAINNAME, CLUSTERNAME, TIMEOUT ) ";
    }

    protected abstract String addToDate(String var1, int var2);

    protected abstract String compareDates(String var1, String var2);

    protected abstract String compareDates(String var1, String var2, boolean var3);

    protected abstract String getTimeFunction();

    protected int getDBType() {
        return this.dbType;
    }

    public String getLeaseOwnerQuery(String string) {
        return "SELECT INSTANCE FROM " + this.TABLE_NAME + " WHERE ( " + this.compareDates("TIMEOUT", this.getTimeFunction(), true) + ") AND SERVER ='" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getPreviousLeaseOwnerQuery(String string) {
        return "SELECT INSTANCE FROM " + this.TABLE_NAME + " WHERE SERVER ='" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getAcquireLeaseQuery(String string, String string2) {
        return "DELETE FROM " + this.TABLE_NAME + " WHERE (" + this.compareDates(this.getTimeFunction(), "TIMEOUT") + ") AND SERVER = '" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getAssumeLeaseQuery(String string, String string2, int n) {
        return "INSERT INTO " + this.TABLE_NAME + this.COLUMN_NAMES + " VALUES ( '" + string + "' , '" + string2 + "' " + this.INSERT_VALUES + ", " + this.addToDate(this.getTimeFunction(), n) + " )";
    }

    public String getRenewLeaseQuery(String string, String string2, int n) {
        return "UPDATE " + this.TABLE_NAME + " SET TIMEOUT = ( " + this.addToDate(this.getTimeFunction(), n) + ") WHERE SERVER = '" + string + "' AND INSTANCE ='" + string2 + "'" + this.WHERE_CLAUSE;
    }

    public String getRenewLeasesQuery(String string, Set set, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("'");
            stringBuilder.append(iterator.next());
            stringBuilder.append("'");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return "UPDATE " + this.TABLE_NAME + " SET TIMEOUT = ( " + this.addToDate(this.getTimeFunction(), n) + ") WHERE SERVER IN (" + stringBuilder.toString() + ") AND INSTANCE ='" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getRenewAllLeasesQuery(String string, int n) {
        return "UPDATE " + this.TABLE_NAME + " SET TIMEOUT = ( " + this.addToDate(this.getTimeFunction(), n) + ") WHERE INSTANCE ='" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getAbdicateLeaseQuery(String string, String string2) {
        return "DELETE FROM " + this.TABLE_NAME + " WHERE SERVER = '" + string + "' AND INSTANCE ='" + string2.toString() + "'" + this.WHERE_CLAUSE;
    }

    public String getUnresponsiveMigratableServersQuery(int n) {
        return "SELECT SERVER FROM " + this.TABLE_NAME + " WHERE ( " + this.compareDates(this.getTimeFunction(), "(" + this.addToDate("TIMEOUT", n) + "))") + this.WHERE_CLAUSE;
    }

    public String getInsertMachineQuery(String string, String string2, String string3) {
        return "INSERT INTO " + string3 + " VALUES ('" + string + "','" + string2 + "'" + this.INSERT_VALUES + ")";
    }

    public String getDeleteMachineQuery(String string, String string2) {
        return "DELETE FROM " + string2 + " WHERE SERVER = '" + string + "'" + this.WHERE_CLAUSE;
    }

    public String getRetrieveMachineQuery(String string, String string2) {
        return "SELECT HOSTMACHINE FROM " + string2 + " WHERE SERVER='" + string + "'" + this.WHERE_CLAUSE;
    }
}

