/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.QueryHelper;

public class QueryHelperImpl
extends QueryHelper {
    public QueryHelperImpl(String string, String string2, String string3, int n) {
        super(string, string2, string3, n);
    }

    protected String addToDate(String string, int n) {
        switch (this.getDBType()) {
            case 1: 
            case 7: {
                return "(" + string + " + (" + n + TIME_AS_FRACTION_OF_DAY + "))";
            }
            case 3: 
            case 4: {
                return "DATEADD(second, " + n + "," + string + ")";
            }
            case 9: {
                return "ADDDATE(" + string + ", INTERVAL " + n + " SECOND)";
            }
            case 5: {
                return string + " + " + n + " UNITS SECOND";
            }
            case 6: {
                return string + " + " + n + " SECONDS";
            }
        }
        throw new AssertionError((Object)"Unsupported database driver");
    }

    protected String compareDates(String string, String string2) {
        return this.compareDates(string, string2, false);
    }

    protected String compareDates(String string, String string2, boolean bl) {
        switch (this.getDBType()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return bl ? string + " >= " + string2 : string + " > " + string2;
            }
            case 3: 
            case 4: {
                return bl ? "DATEDIFF(second," + string + "," + string2 + ") <= 0" : "DATEDIFF(second," + string + "," + string2 + ") < 0";
            }
        }
        throw new AssertionError((Object)"Unsupported database driver");
    }

    protected String getTimeFunction() {
        switch (this.getDBType()) {
            case 1: {
                if (MigratableServerService.theOne() == null) {
                    return "CURRENT_DATE";
                }
                if (MigratableServerService.theOne().isBEADriver()) {
                    return "CURRENT_DATE";
                }
                return "SYSDATE";
            }
            case 7: {
                return "SYSDATE";
            }
            case 3: {
                return "GETDATE()";
            }
            case 4: {
                return "GETDATE()";
            }
            case 5: {
                return "(CURRENT YEAR TO SECOND)";
            }
            case 6: {
                return "CURRENT TIMESTAMP";
            }
            case 9: {
                return "NOW()";
            }
        }
        throw new AssertionError((Object)"Unsupported database driver");
    }
}

