/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManager;
import weblogic.cluster.singleton.SingletonServicesStateManagerRemote;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ReplicatedSingletonServicesStateManager
implements SingletonServicesStateManager,
SingletonServicesStateManagerRemote,
RecoverListener {
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    private static final int DEFAULT_SIZE = 32;
    private static final String VERSION_STRING = "ReplicatedSingletonServicesStateManager.Version";
    private static final Integer VERSION_NONE = new Integer(Integer.MAX_VALUE);
    private static final int EXECUTE_MESSAGE = 1;
    private static final int GET_ALL_SERVICES_STATE = 2;
    private static final int STORE_MESSAGE_FOR_NEXT_STATE_MANAGER = 3;
    private static final int GET_PENDING_MESSAGES = 4;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ConcurrentHashMap vmVideMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap vmVidePendingMessagesMap = new ConcurrentHashMap();
    private static String localServerName;
    private static ClusterMBean clusterMBean;
    private static int unicast_servers_to_send;
    private static int unicast_servers_to_recv;
    private final String instanceName;
    private final LeaseManager leaseManager;
    private final MulticastSession multicastSession;
    private boolean isActive = false;
    private Integer lastVersionSent = null;

    public ReplicatedSingletonServicesStateManager(String string, LeaseManager leaseManager) {
        String string2;
        this.leaseManager = leaseManager;
        this.instanceName = string;
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(32);
        vmVideMap.put(this.instanceName, concurrentHashMap);
        ArrayList arrayList = new ArrayList();
        vmVidePendingMessagesMap.put(this.instanceName, arrayList);
        ClusterService clusterService = ClusterService.getClusterService();
        if (clusterService == null) {
            throw new RuntimeException("This server is not in a cluster.");
        }
        this.multicastSession = clusterService.createMulticastSession(this, 1, false, true);
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        localServerName = LocalServerIdentity.getIdentity().getServerName();
        clusterMBean = domainMBean.lookupServer(localServerName).getCluster();
        int n = clusterMBean.getServers().length;
        try {
            string2 = System.getProperty("weblogic.cluster.singleton.SendPendingMessagesToServers", "3");
            unicast_servers_to_send = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            unicast_servers_to_send = 3;
        }
        unicast_servers_to_send = n > unicast_servers_to_send ? unicast_servers_to_send : n;
        try {
            string2 = System.getProperty("weblogic.cluster.singleton.ReceivePendingMessagesFromServers", String.valueOf(n));
            unicast_servers_to_recv = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            unicast_servers_to_recv = n;
        }
        unicast_servers_to_recv = n > unicast_servers_to_recv ? unicast_servers_to_recv : n;
        ReplicatedSingletonServicesStateManager.syncStateFromActiveStateManager(this.instanceName);
        if (ReplicatedSingletonServicesStateManager.getVersion(this.instanceName) == null) {
            ReplicatedSingletonServicesStateManager.incrementVersion(this.instanceName);
        }
    }

    public Serializable invoke(int n, Serializable serializable) {
        Serializable serializable2 = null;
        switch (n) {
            case 1001: {
                Map map = (Map)((Object)serializable);
                String string = (String)map.get("Sender");
                String string2 = (String)map.get("SvcName");
                SingletonServicesState singletonServicesState = (SingletonServicesState)map.get("SvcState");
                String string3 = null;
                try {
                    string3 = this.leaseManager.findOwner(string2);
                    if (string3 != null) {
                        string3 = LeaseManager.getServerNameFromOwnerIdentity(string3);
                    }
                }
                catch (LeasingException leasingException) {
                    // empty catch block
                }
                boolean bl = false;
                if (string3 == null || string3 != null && string.equals(string3)) {
                    bl = this.storeServiceState(string2, singletonServicesState);
                } else if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Ignoring the call for update state - " + singletonServicesState + " for service " + string2 + "as the sender - " + string + " does not match the current owner - " + string3);
                }
                serializable2 = new Boolean(bl);
                break;
            }
            case 1: {
                Message message = (Message)serializable;
                message.executeOnActiveStateManager(this);
                serializable2 = new Boolean(true);
                break;
            }
            case 2: {
                serializable2 = (Serializable)((Object)this.getAllServicesState());
                break;
            }
            case 3: {
                Message message = (Message)serializable;
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Adding pending message: " + message);
                }
                ReplicatedSingletonServicesStateManager.addLocalPendingMessages(this.instanceName, message);
                serializable2 = new Boolean(true);
                break;
            }
            case 4: {
                serializable2 = (Serializable)((Object)ReplicatedSingletonServicesStateManager.getLocalPendingMessages(this.instanceName));
                break;
            }
        }
        return serializable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkServiceState(String string, int n) {
        Map map;
        Map map2 = map = ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName);
        synchronized (map2) {
            SingletonServicesState singletonServicesState = (SingletonServicesState)map.get(string);
            if (singletonServicesState != null && singletonServicesState.getState() == n) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingletonServicesState getServiceState(String string) {
        Map map;
        Map map2 = map = ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName);
        synchronized (map2) {
            return (SingletonServicesState)map.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllServicesState() {
        Map map;
        Map map2 = map = ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName);
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeServiceState(String string, SingletonServicesState singletonServicesState) {
        boolean bl = false;
        if (this.isActive) {
            Map map = ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName);
            Integer n = null;
            Map map2 = map;
            synchronized (map2) {
                SingletonServicesState singletonServicesState2 = map.put(string, singletonServicesState);
                n = ReplicatedSingletonServicesStateManager.incrementVersion(this.instanceName);
            }
            bl = this.sendUpdateMessage(n, (Serializable)((Object)string), singletonServicesState, false, true);
        } else {
            bl = this.sendUpdateMessage(VERSION_NONE, (Serializable)((Object)string), singletonServicesState, false, false);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServiceState(String string) {
        boolean bl = false;
        try {
            Map map = ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName);
            Integer n = null;
            Map map2 = map;
            synchronized (map2) {
                SingletonServicesState singletonServicesState = (SingletonServicesState)map.remove(string);
                n = ReplicatedSingletonServicesStateManager.incrementVersion(this.instanceName);
            }
            bl = this.sendUpdateMessage(n, (Serializable)((Object)string), null, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public synchronized void syncState() {
        Integer n = ReplicatedSingletonServicesStateManager.getVersion(this.instanceName);
        if (this.lastVersionSent != null && this.lastVersionSent == n) {
            return;
        }
        HeartbeatMessage heartbeatMessage = new HeartbeatMessage(this.instanceName, n);
        boolean bl = false;
        if (ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) {
            return;
        }
        this.sendGroupMessage(heartbeatMessage);
        this.lastVersionSent = n;
    }

    public void leaseAcquired() {
        int n;
        this.isActive = true;
        TreeSet treeSet = new TreeSet();
        ArrayList arrayList = new ArrayList();
        List list = ReplicatedSingletonServicesStateManager.getLocalPendingMessages(this.instanceName);
        if (DEBUG) {
            ReplicatedSingletonServicesStateManager.p("Got " + list.size() + " local pending messages");
        }
        this.sortPendingMessages(list, treeSet, arrayList);
        Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
        int n2 = n = collection.size() > unicast_servers_to_recv ? unicast_servers_to_recv : collection.size();
        if (DEBUG) {
            ReplicatedSingletonServicesStateManager.p("Fetching pending messages from " + n + " remote members");
        }
        Set set = this.sortServersBasedonSeniority(collection);
        int n3 = 0;
        for (Object object : set) {
            Object object2 = object.serverName();
            Object object3 = ReplicatedSingletonServicesStateManager.getSingletonServicesStateManagerRemote((String)object2, clusterMBean.getHealthCheckIntervalMillis());
            if (object3 == null) continue;
            try {
                List list2 = (List)((Object)object3.invoke(4, null));
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Got " + list2.size() + " pending messages from " + (String)object2);
                }
                this.sortPendingMessages(list2, treeSet, arrayList);
            }
            catch (Exception exception) {
                continue;
            }
            if (++n3 != n) continue;
            break;
        }
        for (Object object2 : treeSet) {
            if (!((Message)object2).isPendingModeExecutionAllowed()) continue;
            ((Message)object2).executeOnActiveStateManager(this);
        }
        for (Object object3 : arrayList) {
            if (!((Message)object3).isPendingModeExecutionAllowed()) continue;
            ((Message)object3).executeOnActiveStateManager(this);
        }
    }

    private void sortPendingMessages(List list, Set set, List list2) {
        for (Message message : list) {
            if (message.messageID.equals(VERSION_NONE)) {
                if (list2.contains(message)) continue;
                list2.add(message);
                if (!DEBUG) continue;
                ReplicatedSingletonServicesStateManager.p("Added pending message for current state manager - " + message);
                continue;
            }
            if (!set.add(message) || !DEBUG) continue;
            ReplicatedSingletonServicesStateManager.p("Added message from previous state manager - " + message);
        }
    }

    public synchronized void lostLease() {
        this.isActive = false;
        this.lastVersionSent = null;
    }

    public synchronized GroupMessage createRecoverMessage() {
        if (this.isActive) {
            return new StateDumpMessage(this.instanceName, (Serializable)((Object)ReplicatedSingletonServicesStateManager.getLocalMap(this.instanceName)), ReplicatedSingletonServicesStateManager.getVersion(this.instanceName));
        }
        return new StateDumpMessage(this.instanceName, null, ReplicatedSingletonServicesStateManager.getVersion(this.instanceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getVersion(String string) {
        Map map;
        Integer n = null;
        Map map2 = map = ReplicatedSingletonServicesStateManager.getLocalMap(string);
        synchronized (map2) {
            SingletonServicesState singletonServicesState = (SingletonServicesState)map.get(VERSION_STRING);
            if (singletonServicesState != null) {
                n = (Integer)singletonServicesState.getStateData();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVersion(String string, Integer n) {
        Map map;
        SingletonServicesState singletonServicesState = new SingletonServicesState(1);
        singletonServicesState.setStateData(n);
        Map map2 = map = ReplicatedSingletonServicesStateManager.getLocalMap(string);
        synchronized (map2) {
            map.put(VERSION_STRING, singletonServicesState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer incrementVersion(String string) {
        Map map = ReplicatedSingletonServicesStateManager.getLocalMap(string);
        Integer n = null;
        Map map2 = map;
        synchronized (map2) {
            Integer n2 = ReplicatedSingletonServicesStateManager.getVersion(string);
            if (n2 == null) {
                n2 = new Integer(0);
            }
            int n3 = n2 % 0x7FFFFFFE + 1;
            n = new Integer(n3);
            ReplicatedSingletonServicesStateManager.setVersion(string, n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getLocalPendingMessages(String string) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = (ArrayList)vmVidePendingMessagesMap.get(string);
        synchronized (arrayList2) {
            if (arrayList == null) {
                return null;
            }
            ArrayList arrayList3 = (ArrayList)arrayList.clone();
            arrayList.clear();
            return arrayList3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLocalPendingMessages(String string, Message message) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = (ArrayList)vmVidePendingMessagesMap.get(string);
        synchronized (arrayList2) {
            if (arrayList == null) {
                return;
            }
            arrayList.add(message);
        }
    }

    private boolean sendUpdateMessage(Integer n, Serializable serializable, SingletonServicesState singletonServicesState, boolean bl, boolean bl2) {
        boolean bl3 = false;
        UpdateMessage updateMessage = new UpdateMessage(this.instanceName, n, serializable, singletonServicesState, bl);
        if (bl2) {
            if (!ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) {
                bl3 = this.sendGroupMessage(updateMessage);
            } else {
                this.sendPendingMessagesForNextStateManager(updateMessage, clusterMBean.getHealthCheckIntervalMillis());
                bl3 = true;
            }
        } else {
            Object object;
            SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = null;
            try {
                object = MigratableServerService.theOne().findSingletonMaster();
                if (object != null) {
                    singletonServicesStateManagerRemote = ReplicatedSingletonServicesStateManager.getSingletonServicesStateManagerRemote((String)object, clusterMBean.getHealthCheckIntervalMillis());
                }
            }
            catch (LeasingException leasingException) {
                // empty catch block
            }
            if (singletonServicesStateManagerRemote != null) {
                try {
                    object = (Boolean)singletonServicesStateManagerRemote.invoke(1, updateMessage);
                    bl3 = (Boolean)object;
                }
                catch (RemoteException remoteException) {}
            } else {
                this.sendPendingMessagesForNextStateManager(updateMessage, clusterMBean.getHealthCheckIntervalMillis());
                bl3 = true;
            }
        }
        return bl3;
    }

    private boolean sendGroupMessage(Message message) {
        boolean bl = false;
        if (!this.isActive) {
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Inactive state manager cannot send group message: " + message);
            }
            return false;
        }
        try {
            this.multicastSession.send(message);
            bl = true;
        }
        catch (IOException iOException) {
            ClusterLogger.logMulticastSendErrorMsg((String)("Error in sending message: " + iOException));
        }
        return bl;
    }

    private void sendPendingMessagesForNextStateManager(Message message, long l) {
        int n;
        if (!message.isPendingModeExecutionAllowed()) {
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Not sendPendingMessagesForNextStateManager - " + message);
            }
            return;
        }
        Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
        int n2 = n = collection.size() > unicast_servers_to_send ? unicast_servers_to_send : collection.size();
        if (DEBUG) {
            ReplicatedSingletonServicesStateManager.p("Total number of servers to push pending message = " + n);
        }
        Set set = this.sortServersBasedonSeniority(collection);
        int n3 = 0;
        for (ClusterMemberInfo clusterMemberInfo : set) {
            block6: {
                String string = clusterMemberInfo.serverName();
                try {
                    SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = ReplicatedSingletonServicesStateManager.getSingletonServicesStateManagerRemote(string, l);
                    if (singletonServicesStateManagerRemote == null) continue;
                    singletonServicesStateManagerRemote.invoke(3, message);
                    if (!DEBUG) break block6;
                    ReplicatedSingletonServicesStateManager.p("Sent pending message to " + string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (++n3 != n) continue;
            break;
        }
    }

    private Set sortServersBasedonSeniority(Collection collection) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof ClusterMemberInfo && object2 instanceof ClusterMemberInfo) {
                    Long l = new Long(((ClusterMemberInfo)object).joinTime());
                    Long l2 = new Long(((ClusterMemberInfo)object2).joinTime());
                    return l.compareTo(l2);
                }
                throw new IllegalArgumentException("Objects not instanceof ClusterMemberInfo");
            }
        });
        treeSet.addAll(collection);
        return treeSet;
    }

    private static SingletonServicesStateManagerRemote getSingletonServicesStateManagerRemote(String string, long l) {
        SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = null;
        try {
            String string2 = null;
            try {
                string2 = URLManager.findAdministrationURL(string);
            }
            catch (UnknownHostException unknownHostException) {
                MigratableServerService.theOne();
                string2 = MigratableServerService.findURLOfUnconnectedServer(string);
            }
            if (string2 == null) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Unable to find the admin url for active state manager - " + string);
                }
                return null;
            }
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Looking up SingletonServicesStateManagerRemote on " + string + " with url " + string2);
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("java.naming.provider.url", string2);
            hashtable.put("weblogic.jndi.requestTimeout", new Long(l));
            Environment environment = new Environment(hashtable);
            Context context = environment.getInitialContext();
            singletonServicesStateManagerRemote = (SingletonServicesStateManagerRemote)context.lookup("weblogic.cluster.singleton.SingletonServicesStateManager");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return singletonServicesStateManagerRemote;
    }

    private static void syncStateFromActiveStateManager(String string) {
        block6: {
            try {
                String string2 = MigratableServerService.theOne().findSingletonMaster();
                if (string2 == null || string2.equals(localServerName)) {
                    if (DEBUG) {
                        ReplicatedSingletonServicesStateManager.p("Not able to sync state as active state manager - " + string2 + " not yet available or the local state manager is the active one.");
                    }
                    return;
                }
                SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = ReplicatedSingletonServicesStateManager.getSingletonServicesStateManagerRemote(string2, clusterMBean.getHealthCheckIntervalMillis());
                if (singletonServicesStateManagerRemote != null) {
                    Map map = (Map)((Object)singletonServicesStateManagerRemote.invoke(2, (Serializable)((Object)string)));
                    if (DEBUG) {
                        ReplicatedSingletonServicesStateManager.p("New Services State Map:" + map);
                    }
                    ReplicatedSingletonServicesStateManager.replaceLocalMap(string, map);
                }
            }
            catch (Exception exception) {
                if (!DEBUG) break block6;
                ReplicatedSingletonServicesStateManager.p("Failed to get a state dump because of :" + exception);
            }
        }
    }

    private static Map getLocalMap(String string) {
        return (Map)vmVideMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceLocalMap(String string, Map map) {
        Map map2 = ReplicatedSingletonServicesStateManager.getLocalMap(string);
        if (map2 == null) {
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Local State Manager not yet initialized. Not replacing local map.");
            }
            return;
        }
        Map map3 = map2;
        synchronized (map3) {
            if (map2 == null) {
                return;
            }
            map2.clear();
            map2.putAll(map);
        }
    }

    private static void p(Object object) {
        SingletonServicesDebugLogger.debug("ReplicatedSingletonServicesStateManager: " + object);
    }

    protected static class StateDumpMessage
    extends Message {
        private static final long serialVersionUID = -3290218502688112771L;
        private Serializable stateDump;

        StateDumpMessage(String string, Serializable serializable, Integer n) {
            super(string, n);
            this.stateDump = serializable;
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Sending :" + this);
            }
        }

        public void execute(HostID hostID) {
            if (this.stateDump != null) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Executing: " + this);
                }
                ReplicatedSingletonServicesStateManager.replaceLocalMap(this.name, (Map)((Object)this.stateDump));
            }
        }

        public boolean isPendingModeExecutionAllowed() {
            return false;
        }

        public String toString() {
            return new String("StateDumpMessage for state manager:" + this.name + " MessageID:" + this.messageID);
        }
    }

    public static class HeartbeatMessage
    extends Message {
        private static final long serialVersionUID = -7435880529011603250L;
        private Integer version;

        public HeartbeatMessage(String string, Integer n) {
            super(string, n);
            this.version = n;
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Sending :" + this);
            }
        }

        public void execute(HostID hostID) {
            List list;
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Executing :" + this);
            }
            if (ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Server is shutting down. Not executing " + this);
                }
                return;
            }
            Map map = ReplicatedSingletonServicesStateManager.getLocalMap(this.name);
            if (map == null) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Local State Manager not yet initialized. Not executing " + this);
                }
                return;
            }
            Integer n = ReplicatedSingletonServicesStateManager.getVersion(this.name);
            if (n == null) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Local State Manager not yet initialized. Not executing " + this);
                }
                return;
            }
            if (!n.equals(this.version)) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Version mismatch for state manager:" + this.name + " Local Version#:" + n + " Master Version#:" + this.version);
                }
                ReplicatedSingletonServicesStateManager.syncStateFromActiveStateManager(this.name);
            }
            if ((list = ReplicatedSingletonServicesStateManager.getLocalPendingMessages(this.name)) != null && list.size() > 0) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Discarding pending messages that are still present even after starting to get heartbeat messages");
                }
                list.clear();
            }
        }

        public boolean isPendingModeExecutionAllowed() {
            return false;
        }

        public String toString() {
            return new String("HeartbeatMessage for state manager:" + this.name + " MessageID:" + this.messageID + " Value:" + this.version);
        }
    }

    public static class UpdateMessage
    extends Message {
        private static final long serialVersionUID = 5942110178350613494L;
        private Serializable key;
        private SingletonServicesState newValue;
        private Integer version;
        private boolean removeState = false;

        public UpdateMessage(String string, Integer n, Serializable serializable, SingletonServicesState singletonServicesState, boolean bl) {
            super(string, n);
            this.key = serializable;
            this.version = n;
            this.newValue = singletonServicesState;
            this.removeState = bl;
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Sending :" + this);
            }
        }

        public boolean equals(Object object) {
            if (this.isVersionValid()) {
                return super.equals(object);
            }
            boolean bl = false;
            if (object instanceof UpdateMessage) {
                UpdateMessage updateMessage = (UpdateMessage)object;
                if (updateMessage.key.equals(this.key) && updateMessage.newValue.equals(this.newValue) && updateMessage.removeState == this.removeState) {
                    bl = true;
                }
            }
            return bl;
        }

        public void executeOnActiveStateManager(ReplicatedSingletonServicesStateManager replicatedSingletonServicesStateManager) {
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Executing :" + this);
            }
            if (!this.removeState) {
                replicatedSingletonServicesStateManager.storeServiceState((String)((Object)this.key), this.newValue);
            } else {
                replicatedSingletonServicesStateManager.removeServiceState((String)((Object)this.key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(HostID hostID) {
            Map map;
            if (DEBUG) {
                ReplicatedSingletonServicesStateManager.p("Executing :" + this);
            }
            if ((map = ReplicatedSingletonServicesStateManager.getLocalMap(this.name)) == null) {
                if (DEBUG) {
                    ReplicatedSingletonServicesStateManager.p("Local State Manager not yet initialized. Not executing " + this);
                }
                return;
            }
            Map map2 = map;
            synchronized (map2) {
                Integer n = ReplicatedSingletonServicesStateManager.getVersion(this.name);
                int n2 = n == null ? 0 : n;
                Integer n3 = new Integer(n2 + 1);
                if (!n3.equals(this.version)) {
                    if (DEBUG) {
                        ReplicatedSingletonServicesStateManager.p("Missed Update Message for state manager:" + this.name + " Expected Version#:" + n3 + " Master Version#:" + this.version);
                    }
                    ReplicatedSingletonServicesStateManager.syncStateFromActiveStateManager(this.name);
                } else {
                    if (this.removeState) {
                        map.remove(this.key);
                    } else {
                        map.put(this.key, this.newValue);
                    }
                    ReplicatedSingletonServicesStateManager.setVersion(this.name, this.version);
                }
            }
        }

        public boolean isPendingModeExecutionAllowed() {
            return true;
        }

        public String toString() {
            String string = this.version.equals(VERSION_NONE) ? "None" : String.valueOf(this.version);
            return new String("UpdateMessage for state manager:" + this.name + " MessageID:" + string + " Key:" + this.key + " New Value:" + this.newValue + " DeleteState:" + this.removeState);
        }

        private boolean isVersionValid() {
            return !this.version.equals(VERSION_NONE);
        }
    }

    protected static abstract class Message
    implements Serializable,
    Comparable,
    GroupMessage {
        protected final String name;
        protected final Integer messageID;

        protected Message(String string, Integer n) {
            this.name = string;
            this.messageID = n;
        }

        public boolean equals(Object object) {
            if (!object.getClass().getName().equals(this.getClass().getName())) {
                return false;
            }
            Message message = (Message)object;
            return this.messageID.intValue() == message.messageID.intValue();
        }

        public int hashCode() {
            return this.messageID;
        }

        public int compareTo(Object object) {
            if (!object.getClass().getName().equals(this.getClass().getName())) {
                throw new ClassCastException();
            }
            Message message = (Message)object;
            return this.messageID.compareTo(message.messageID);
        }

        public abstract boolean isPendingModeExecutionAllowed();

        public void executeOnActiveStateManager(ReplicatedSingletonServicesStateManager replicatedSingletonServicesStateManager) {
        }

        public abstract void execute(HostID var1);
    }
}

