/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.security.AccessController;
import java.util.Map;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.ServerMigrationCoordinator;
import weblogic.cluster.singleton.ServerMigrationException;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;
import weblogic.utils.collections.ConcurrentHashMap;

public final class ServerMigrationCoordinatorImpl
implements ServerMigrationCoordinator,
MigratableServiceConstants {
    private final Map taskMap = new ConcurrentHashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(String string, String string2, String string3, boolean bl, boolean bl2) throws ServerMigrationException {
        ServerMigrationTask serverMigrationTask = (ServerMigrationTask)this.taskMap.get(string);
        if (serverMigrationTask == null) {
            serverMigrationTask = new ServerMigrationTask(string, string3);
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug(string + " New Migration Task " + serverMigrationTask);
            }
            this.taskMap.put(string, serverMigrationTask);
            try {
                this.stopServer(bl, serverMigrationTask);
                this.startServer(bl2, serverMigrationTask);
                Object var8_7 = null;
                this.taskMap.remove(string);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.taskMap.remove(string);
                throw throwable;
            }
        } else {
            throw new ServerMigrationException("Migration operation in progress", null);
        }
    }

    private void stopServer(boolean bl, ServerMigrationTask serverMigrationTask) throws ServerMigrationException {
        block4: {
            try {
                serverMigrationTask.stopMigratableServer();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Task failed", serverLifecycleException);
                }
                if (bl) break block4;
                throw new ServerMigrationException("Migration failed trying to stop the server", serverLifecycleException);
            }
        }
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("Stopped server");
        }
    }

    private void startServer(boolean bl, ServerMigrationTask serverMigrationTask) throws ServerMigrationException {
        block4: {
            try {
                serverMigrationTask.startMigratableServer();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                if (MigrationDebugLogger.isDebugEnabled()) {
                    MigrationDebugLogger.debug("Task failed", serverLifecycleException);
                }
                if (bl) break block4;
                throw new ServerMigrationException("Migration failed trying to start the server", serverLifecycleException);
            }
        }
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("Restarted server on target destination");
        }
    }

    void taskComplete(String string) {
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("Removing task " + string);
        }
        Object v = this.taskMap.remove(string);
        if (MigrationDebugLogger.isDebugEnabled()) {
            MigrationDebugLogger.debug("Removing task " + v);
        }
    }

    static /* synthetic */ AuthenticatedSubject access$300() {
        return kernelId;
    }

    private static class ServerMigrationTask {
        private final DomainAccess domainAccess = ManagementService.getDomainAccess(ServerMigrationCoordinatorImpl.access$300());
        private final String serverName;
        private final String destinationMachine;

        private ServerMigrationTask(String string, String string2) {
            this.serverName = string;
            this.destinationMachine = string2;
        }

        private void stopMigratableServer() throws ServerLifecycleException {
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = this.domainAccess.lookupServerLifecycleRuntime(this.serverName);
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.shutdown();
            this.waitForTask(serverLifeCycleTaskRuntimeMBean);
        }

        private void startMigratableServer() throws ServerLifecycleException {
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = this.domainAccess.lookupServerLifecycleRuntime(this.serverName);
            if (MigrationDebugLogger.isDebugEnabled()) {
                MigrationDebugLogger.debug(this.serverName + " is going to be started on " + this.destinationMachine);
            }
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.start(this.destinationMachine);
            this.waitForTask(serverLifeCycleTaskRuntimeMBean);
        }

        private synchronized void waitForTask(ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean) {
            while (serverLifeCycleTaskRuntimeMBean.isRunning()) {
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

