/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.DomainMigrationHistory;
import weblogic.cluster.singleton.DomainMigrationHistoryImpl;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigratableServerState;
import weblogic.cluster.singleton.MigrationData;
import weblogic.cluster.singleton.MigrationDataRuntimeMBeanImpl;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.management.runtime.MigrationDataRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerMigrationRuntimeMBean;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.work.WorkManagerFactory;

public final class ServerMigrationRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServerMigrationRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ServerMigrationRuntimeMBeanImpl singleton;
    private List migrationList = new ArrayList();

    private ServerMigrationRuntimeMBeanImpl(RuntimeMBean runtimeMBean) throws ManagementException {
        super("ServerMigrationRuntime", runtimeMBean, true);
    }

    static synchronized void initialize() throws ManagementException {
        ClusterRuntimeMBean clusterRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime();
        if (clusterRuntimeMBean == null) {
            return;
        }
        if (singleton == null) {
            singleton = new ServerMigrationRuntimeMBeanImpl(clusterRuntimeMBean);
        }
    }

    public static synchronized ServerMigrationRuntimeMBeanImpl getInstance() {
        Debug.assertion((singleton != null ? 1 : 0) != 0, (String)"Cannot use ServerMigrationRuntimeMBeanImpl without initialization");
        return singleton;
    }

    public boolean isClusterMaster() {
        return MigratableServerService.theOne().isClusterMaster();
    }

    public String getClusterMasterName() throws ManagementException {
        try {
            return MigratableServerService.theOne().findClusterMaster();
        }
        catch (LeasingException leasingException) {
            throw new ManagementException("Unable to determine ClusterMaster due to " + leasingException.getMessage());
        }
    }

    public MigrationDataRuntimeMBean[] getMigrationData() {
        if (this.migrationList.size() == 0) {
            return null;
        }
        MigrationDataRuntimeMBean[] migrationDataRuntimeMBeanArray = new MigrationDataRuntimeMBean[this.migrationList.size()];
        this.migrationList.toArray(migrationDataRuntimeMBeanArray);
        return migrationDataRuntimeMBeanArray;
    }

    void migrationCompleted(MigratableServerState migratableServerState) {
        MigrationDataRuntimeMBean[] migrationDataRuntimeMBeanArray = this.getMigrationData();
        if (migrationDataRuntimeMBeanArray != null) {
            for (int i = 0; i < migrationDataRuntimeMBeanArray.length; ++i) {
                if (!migrationDataRuntimeMBeanArray[i].getServerName().equals(migratableServerState.getServer().getName()) || migrationDataRuntimeMBeanArray[i].getStatus() != 1) continue;
                MigrationDataImpl migrationDataImpl = new MigrationDataImpl(migratableServerState, 0, migrationDataRuntimeMBeanArray[i].getMigrationStartTime());
                ((MigrationDataRuntimeMBeanImpl)migrationDataRuntimeMBeanArray[i]).update(migrationDataImpl);
                this.updateAdminServer(migrationDataImpl);
                return;
            }
        }
    }

    void migrationStarted(MigratableServerState migratableServerState) {
        MigrationDataRuntimeMBean[] migrationDataRuntimeMBeanArray = this.getMigrationData();
        if (migrationDataRuntimeMBeanArray != null) {
            for (int i = 0; i < migrationDataRuntimeMBeanArray.length; ++i) {
                if (!migrationDataRuntimeMBeanArray[i].getServerName().equals(migratableServerState.getServer().getName()) || migrationDataRuntimeMBeanArray[i].getStatus() != 1) continue;
                MigrationDataImpl migrationDataImpl = new MigrationDataImpl(migratableServerState, 1, migrationDataRuntimeMBeanArray[i].getMigrationStartTime());
                ((MigrationDataRuntimeMBeanImpl)migrationDataRuntimeMBeanArray[i]).update(migrationDataImpl);
                this.updateAdminServer(migrationDataImpl);
                return;
            }
        }
        try {
            MigrationDataImpl migrationDataImpl = new MigrationDataImpl(migratableServerState, 1, System.currentTimeMillis());
            this.updateAdminServer(migrationDataImpl);
            this.migrationList.add(new MigrationDataRuntimeMBeanImpl(this, migrationDataImpl));
        }
        catch (ManagementException managementException) {
            ClusterLogger.logErrorReportingMigrationRuntimeInfo((Exception)((Object)managementException));
        }
    }

    private void updateAdminServer(final MigrationData migrationData) {
        try {
            String string = ManagementService.getRuntimeAccess(kernelId).getAdminServerName();
            if (string == null) {
                return;
            }
            final DomainMigrationHistory domainMigrationHistory = this.getDomainMigrationHistoryRemote(string);
            if (domainMigrationHistory == null) {
                return;
            }
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    domainMigrationHistory.update(migrationData);
                }
            });
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            // empty catch block
        }
    }

    private DomainMigrationHistory getDomainMigrationHistoryRemote(String string) {
        try {
            Environment environment = new Environment();
            environment.setProviderUrl(URLManager.findAdministrationURL(string));
            DomainMigrationHistory domainMigrationHistory = (DomainMigrationHistory)PortableRemoteObject.narrow((Object)environment.getInitialReference(DomainMigrationHistoryImpl.class), DomainMigrationHistory.class);
            return domainMigrationHistory;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (NamingException namingException) {
            ClusterLogger.logErrorReportingMigrationRuntimeInfo((Exception)namingException);
            return null;
        }
    }

    private static final class MigrationDataImpl
    implements MigrationData {
        private final String serverName;
        private final String machineMigratedFrom;
        private final String machineMigratedTo;
        private final String clusterMasterName;
        private final String clusterName;
        private int status;
        private long endTime;
        private long startTime;

        MigrationDataImpl(MigratableServerState migratableServerState, int n, long l) {
            this.serverName = migratableServerState.getServer().getName();
            this.machineMigratedFrom = migratableServerState.getPreviousMachine() != null ? migratableServerState.getPreviousMachine().getName() : null;
            this.machineMigratedTo = migratableServerState.getCurrentMachine().getName();
            this.clusterMasterName = ManagementService.getRuntimeAccess(kernelId).getServerName();
            this.clusterName = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime().getName();
            this.startTime = l;
            this.status = n;
            if (n == 2 || n == 0) {
                this.endTime = System.currentTimeMillis();
            }
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMachineMigratedFrom() {
            return this.machineMigratedFrom;
        }

        public String getMachineMigratedTo() {
            return this.machineMigratedTo;
        }

        public long getMigrationStartTime() {
            return this.startTime;
        }

        public long getMigrationEndTime() {
            return this.endTime;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getClusterMasterName() {
            return this.clusterMasterName;
        }

        public String getMigrationType() {
            return "server";
        }
    }
}

