/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import weblogic.cluster.singleton.MigrationData;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServiceMigrationDataRuntimeMBean;

public class ServiceMigrationDataRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServiceMigrationDataRuntimeMBean {
    private static int count;
    private String serviceName;
    private String coordinatorName;
    private String migratedTo;
    private String migratedFrom;
    private String clusterName;
    private int status;
    private long startTime;
    private long endTime;
    private String[] destinationsAttempted;

    ServiceMigrationDataRuntimeMBeanImpl(RuntimeMBean runtimeMBean, MigrationData migrationData) throws ManagementException {
        super("MigrationData-" + migrationData.getServerName() + migrationData.getMigrationStartTime() + runtimeMBean.toString() + count++, runtimeMBean, true);
        this.initialize(migrationData);
    }

    public ServiceMigrationDataRuntimeMBeanImpl(MigrationData migrationData) throws ManagementException {
        super("MigrationData-" + migrationData.getServerName() + migrationData.getMigrationStartTime() + "-adminServer" + count++);
        this.initialize(migrationData);
    }

    void initialize(MigrationData migrationData) {
        this.serviceName = migrationData.getServerName();
        this.migratedFrom = migrationData.getMachineMigratedFrom();
        this.migratedTo = migrationData.getMachineMigratedTo();
        this.coordinatorName = migrationData.getClusterMasterName();
        this.clusterName = migrationData.getClusterName();
        this.status = 1;
        this.startTime = migrationData.getMigrationStartTime();
        this.destinationsAttempted = new String[1];
        this.destinationsAttempted[0] = this.migratedTo;
    }

    public String getServerName() {
        return this.serviceName;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMigratedFrom() {
        return this.migratedFrom;
    }

    public synchronized String[] getDestinationsAttempted() {
        return this.destinationsAttempted;
    }

    public String getMigratedTo() {
        return this.migratedTo;
    }

    public long getMigrationStartTime() {
        return this.startTime;
    }

    public long getMigrationEndTime() {
        return this.endTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getCoordinatorName() {
        return this.coordinatorName;
    }

    public synchronized void update(MigrationData migrationData) {
        this.migratedFrom = migrationData.getMachineMigratedFrom();
        this.migratedTo = migrationData.getMachineMigratedTo();
        this.status = migrationData.getStatus();
        if (this.status == 1) {
            String[] stringArray = this.destinationsAttempted;
            this.destinationsAttempted = new String[this.destinationsAttempted.length + 1];
            System.arraycopy(stringArray, 0, this.destinationsAttempted, 0, stringArray.length);
            this.destinationsAttempted[this.destinationsAttempted.length - 1] = this.migratedTo;
        }
        this.endTime = migrationData.getMigrationEndTime();
    }
}

