/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.DomainMigrationHistory;
import weblogic.cluster.singleton.DomainMigrationHistoryImpl;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigrationData;
import weblogic.cluster.singleton.ServiceMigrationDataRuntimeMBeanImpl;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServiceMigrationDataRuntimeMBean;
import weblogic.management.runtime.ServiceMigrationRuntimeMBean;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManagerFactory;

public final class ServiceMigrationRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServiceMigrationRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ServiceMigrationRuntimeMBeanImpl singleton;
    private List migrationList = new ArrayList();

    private ServiceMigrationRuntimeMBeanImpl(RuntimeMBean runtimeMBean) throws ManagementException {
        super("ServiceMigrationRuntime", runtimeMBean, true);
    }

    static synchronized void initialize() throws ManagementException {
        ClusterRuntimeMBean clusterRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime();
        if (clusterRuntimeMBean == null) {
            return;
        }
        if (singleton == null) {
            singleton = new ServiceMigrationRuntimeMBeanImpl(clusterRuntimeMBean);
        }
    }

    public static synchronized ServiceMigrationRuntimeMBeanImpl getInstance() {
        return singleton;
    }

    public boolean isClusterMaster() {
        return MigratableServerService.theOne().isClusterMaster();
    }

    public String getClusterMasterName() throws ManagementException {
        try {
            return MigratableServerService.theOne().findClusterMaster();
        }
        catch (LeasingException leasingException) {
            throw new ManagementException("Unable to determine ClusterMaster due to " + leasingException.getMessage());
        }
    }

    public ServiceMigrationDataRuntimeMBean[] getMigrationData() {
        if (this.migrationList.size() == 0) {
            return null;
        }
        ServiceMigrationDataRuntimeMBean[] serviceMigrationDataRuntimeMBeanArray = new ServiceMigrationDataRuntimeMBean[this.migrationList.size()];
        this.migrationList.toArray(serviceMigrationDataRuntimeMBeanArray);
        return serviceMigrationDataRuntimeMBeanArray;
    }

    synchronized void migrationCompleted(String string, String string2, String string3) {
        ServiceMigrationDataRuntimeMBean[] serviceMigrationDataRuntimeMBeanArray = this.getMigrationData();
        if (serviceMigrationDataRuntimeMBeanArray != null) {
            for (int i = 0; i < serviceMigrationDataRuntimeMBeanArray.length; ++i) {
                if (!serviceMigrationDataRuntimeMBeanArray[i].getServerName().equals(string) || serviceMigrationDataRuntimeMBeanArray[i].getStatus() != 1) continue;
                MigrationDataImpl migrationDataImpl = new MigrationDataImpl(string, string2, string3, 0, serviceMigrationDataRuntimeMBeanArray[i].getMigrationStartTime());
                ((ServiceMigrationDataRuntimeMBeanImpl)serviceMigrationDataRuntimeMBeanArray[i]).update(migrationDataImpl);
                this.updateAdminServer(migrationDataImpl);
                return;
            }
        }
    }

    synchronized void migrationStarted(String string, String string2, String string3) {
        ServiceMigrationDataRuntimeMBean[] serviceMigrationDataRuntimeMBeanArray = this.getMigrationData();
        if (serviceMigrationDataRuntimeMBeanArray != null) {
            for (int i = 0; i < serviceMigrationDataRuntimeMBeanArray.length; ++i) {
                if (!serviceMigrationDataRuntimeMBeanArray[i].getServerName().equals(string) || serviceMigrationDataRuntimeMBeanArray[i].getStatus() != 1) continue;
                MigrationDataImpl migrationDataImpl = new MigrationDataImpl(string, string2, string3, 1, serviceMigrationDataRuntimeMBeanArray[i].getMigrationStartTime());
                ((ServiceMigrationDataRuntimeMBeanImpl)serviceMigrationDataRuntimeMBeanArray[i]).update(migrationDataImpl);
                this.updateAdminServer(migrationDataImpl);
                return;
            }
        }
        try {
            MigrationDataImpl migrationDataImpl = new MigrationDataImpl(string, string2, string3, 1, System.currentTimeMillis());
            this.updateAdminServer(migrationDataImpl);
            this.migrationList.add(new ServiceMigrationDataRuntimeMBeanImpl(this, migrationDataImpl));
        }
        catch (ManagementException managementException) {
            ClusterLogger.logErrorReportingMigrationRuntimeInfo((Exception)((Object)managementException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ClusterLogger.logErrorReportingMigrationRuntimeInfo((Exception)illegalArgumentException);
        }
    }

    private void updateAdminServer(final MigrationData migrationData) {
        try {
            String string = ManagementService.getRuntimeAccess(kernelId).getAdminServerName();
            if (string == null) {
                return;
            }
            final DomainMigrationHistory domainMigrationHistory = this.getDomainMigrationHistoryRemote(string);
            if (domainMigrationHistory == null) {
                return;
            }
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    domainMigrationHistory.update(migrationData);
                }
            });
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            // empty catch block
        }
    }

    private DomainMigrationHistory getDomainMigrationHistoryRemote(String string) {
        try {
            Environment environment = new Environment();
            environment.setProviderUrl(URLManager.findAdministrationURL(string));
            DomainMigrationHistory domainMigrationHistory = (DomainMigrationHistory)PortableRemoteObject.narrow((Object)environment.getInitialReference(DomainMigrationHistoryImpl.class), DomainMigrationHistory.class);
            return domainMigrationHistory;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (NamingException namingException) {
            ClusterLogger.logErrorReportingMigrationRuntimeInfo((Exception)namingException);
            return null;
        }
    }

    private static final class MigrationDataImpl
    implements MigrationData {
        private final String serverName;
        private final String machineMigratedFrom;
        private final String machineMigratedTo;
        private final String clusterMasterName;
        private final String clusterName;
        private int status;
        private long endTime;
        private long startTime;

        MigrationDataImpl(String string, String string2, String string3, int n, long l) {
            this.serverName = string;
            this.machineMigratedFrom = string2;
            this.machineMigratedTo = string3;
            this.clusterMasterName = ManagementService.getRuntimeAccess(kernelId).getServerName();
            this.clusterName = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime().getName();
            this.startTime = l;
            this.status = n;
            if (n == 2 || n == 0) {
                this.endTime = System.currentTimeMillis();
            }
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMachineMigratedFrom() {
            return this.machineMigratedFrom;
        }

        public String getMachineMigratedTo() {
            return this.machineMigratedTo;
        }

        public long getMigrationStartTime() {
            return this.startTime;
        }

        public long getMigrationEndTime() {
            return this.endTime;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getClusterMasterName() {
            return this.clusterMasterName;
        }

        public String getMigrationType() {
            return "service";
        }

        public String toString() {
            return this.getServerName() + " " + this.getMachineMigratedFrom() + " " + this.getMachineMigratedTo() + " " + this.getMigrationStartTime() + " " + this.getMigrationType();
        }
    }
}

