/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.cluster.singleton.MissedHeartbeatException;

public class SimpleLeasingBasis
implements LeasingBasis {
    private final boolean DEBUG = false;
    private final Map leaseTable;

    public SimpleLeasingBasis() {
        this(new HashMap());
    }

    public SimpleLeasingBasis(Map map) {
        this.leaseTable = map;
    }

    protected Map getLeaseTable() {
        return this.leaseTable;
    }

    public synchronized boolean acquire(String string, String string2, int n) {
        LeaseEntry leaseEntry = (LeaseEntry)this.leaseTable.get(string);
        if (leaseEntry == null || leaseEntry.timestamp + (long)leaseEntry.leaseTimeout < System.currentTimeMillis()) {
            this.leaseTable.put(string, new LeaseEntry(string2, string, n));
            return true;
        }
        if (string2.equalsIgnoreCase(leaseEntry.owner)) {
            leaseEntry.leaseTimeout = n;
            return true;
        }
        return false;
    }

    public synchronized void release(String string, String string2) throws IOException {
        LeaseEntry leaseEntry = (LeaseEntry)this.leaseTable.get(string);
        if (leaseEntry == null || !leaseEntry.owner.equals(string2)) {
            throw new IOException("Lease \"" + string + "\" is not currently owned");
        }
        this.leaseTable.remove(string);
    }

    public synchronized String findOwner(String string) {
        LeaseEntry leaseEntry = (LeaseEntry)this.leaseTable.get(string);
        if (leaseEntry == null) {
            return null;
        }
        if (leaseEntry.timestamp + (long)leaseEntry.leaseTimeout < System.currentTimeMillis()) {
            return null;
        }
        return leaseEntry.owner.toString();
    }

    public synchronized String findPreviousOwner(String string) {
        LeaseEntry leaseEntry = (LeaseEntry)this.leaseTable.get(string);
        if (leaseEntry == null) {
            return null;
        }
        return leaseEntry.owner;
    }

    public synchronized int renewAllLeases(int n, String string) throws MissedHeartbeatException {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.leaseTable.entrySet()) {
            LeaseEntry leaseEntry = (LeaseEntry)entry.getValue();
            if (!leaseEntry.owner.equals(string)) continue;
            leaseEntry.timestamp = System.currentTimeMillis();
            leaseEntry.leaseTimeout = n;
            hashMap.put(entry.getKey(), leaseEntry);
        }
        this.leaseTable.putAll(hashMap);
        return hashMap.size();
    }

    public int renewLeases(String string, Set set, int n) throws MissedHeartbeatException {
        HashMap<String, LeaseEntry> hashMap = new HashMap<String, LeaseEntry>();
        for (String string2 : set) {
            LeaseEntry leaseEntry = (LeaseEntry)this.leaseTable.get(string2);
            if (leaseEntry == null || !leaseEntry.owner.equals(string)) continue;
            leaseEntry.timestamp = System.currentTimeMillis();
            leaseEntry.leaseTimeout = n;
            hashMap.put(string2, leaseEntry);
        }
        this.leaseTable.putAll(hashMap);
        return hashMap.size();
    }

    public synchronized String[] findExpiredLeases(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : this.leaseTable.entrySet()) {
            LeaseEntry leaseEntry = (LeaseEntry)entry.getValue();
            if (leaseEntry.timestamp + (long)leaseEntry.leaseTimeout + (long)n >= System.currentTimeMillis()) continue;
            arrayList.add(leaseEntry.getLeaseName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static final void p(String string) {
        System.out.println("<SimpleLeasingBasis>: " + string);
    }

    public static final class LeaseEntry
    implements Serializable {
        private static final long serialVersionUID = 2765581341661213160L;
        private long timestamp = System.currentTimeMillis();
        private final String owner;
        private final String leaseName;
        private int leaseTimeout;

        public LeaseEntry(String string, String string2, int n) {
            this.owner = string;
            this.leaseName = string2;
            this.leaseTimeout = n;
        }

        public boolean equals(Object object) {
            if (object instanceof LeaseEntry) {
                return ((LeaseEntry)object).owner.equals(this.owner) && ((LeaseEntry)object).leaseName.equals(this.leaseName);
            }
            return false;
        }

        public int hashCode() {
            return this.leaseName.hashCode() ^ this.owner.hashCode();
        }

        public Object getLeaseName() {
            return this.leaseName;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public String toString() {
            return "[LeaseEntry owner " + this.owner + ", lease name " + this.leaseName + ", timestamp " + this.timestamp + "]";
        }
    }
}

