/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.ClusterLeaderListener;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseObtainedListener;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.SingletonMonitor;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.health.HealthMonitorService;
import weblogic.jndi.Environment;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class SingletonMaster
implements MigratableServiceConstants,
LeaseObtainedListener,
LeaseLostListener,
ClusterLeaderListener {
    private boolean isSingletonMaster = false;
    private final LeaseManager manager;
    private final SingletonMonitor monitor;
    public static final String SINGLETON_MASTER = "SINGLETON_MASTER";
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    SingletonMaster(LeaseManager leaseManager, int n) {
        this.manager = leaseManager;
        this.monitor = new SingletonMonitor(leaseManager, n);
        this.bind("weblogic.cluster.singleton.SingletonServicesStateManager", this.monitor.getSingletonServicesStateManager(), false);
    }

    void start() {
        if (DEBUG) {
            SingletonMaster.p("Starting Singleton Master Service. Beginning attempts to claim the SingletonMaster lock.");
        }
        if ("consensus".equals(MigratableServerService.theOne().getLeasingType())) {
            AbstractConsensusService.getInstance().addClusterLeaderListener(this);
        } else {
            try {
                this.manager.acquire(SINGLETON_MASTER, this);
            }
            catch (LeasingException leasingException) {
                this.manager.stop();
            }
        }
    }

    void stop() {
        if (DEBUG) {
            SingletonMaster.p("Stopping Singleton Master service.");
        }
        this.cleanup();
    }

    public synchronized boolean isSingletonMaster() {
        return this.isSingletonMaster;
    }

    public void localServerIsClusterLeader() {
        try {
            String string;
            if (DEBUG) {
                SingletonMaster.p("Local Server is the Cluster Leader. Going to acquire the SingletonMaster lease.");
            }
            if ((string = this.manager.findOwner(SINGLETON_MASTER)) != null) {
                String string2;
                String string3 = LeaseManager.getServerNameFromOwnerIdentity(string);
                if (!LocalServerIdentity.getIdentity().getServerName().equals(string3) && SingletonMonitor.canMigrateLease(string2 = AbstractConsensusService.getInstance().getServerState(string3))) {
                    if (DEBUG) {
                        SingletonMaster.p(string3 + " is marked as " + string2 + ". Voiding all its leases");
                    }
                    this.manager.voidLeases(string);
                }
            }
            this.manager.acquire(SINGLETON_MASTER, this);
        }
        catch (LeasingException leasingException) {
            String string = "Got LeasingException " + leasingException + " while trying to acquire SingletonMaster lease";
            HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
        }
    }

    public void localServerLostClusterLeadership() {
        this.onRelease();
    }

    public synchronized void onAcquire(String string) {
        if (this.isSingletonMaster) {
            return;
        }
        this.isSingletonMaster = true;
        if (DEBUG) {
            SingletonMaster.p("Acquired the SingletonMaster lease. This server is now responsible for SingletonService management.");
        }
        this.manager.addLeaseLostListener(this);
        this.monitor.start();
        this.bind("weblogic/cluster/singleton/SingletonMonitorRemote", this.monitor, false);
        if ("consensus".equals(MigratableServerService.theOne().getLeasingType())) {
            AbstractConsensusService.getInstance().addConsensusServiceGroupViewListener(this.monitor);
        }
    }

    public void onException(Exception exception, String string) {
        if (DEBUG) {
            SingletonMaster.p("Encountered an exeption while trying to get the SingletonMaster lease. We are ignoring the exception and continuing to try to get the lease.", exception);
        }
    }

    public synchronized void onRelease() {
        if (!this.isSingletonMaster) {
            return;
        }
        if (DEBUG) {
            SingletonMaster.p("The SingletonMaster lease has been lost. This server will no longer perform SingletonService monitoring. It is unusual to lose a lease on a running server.This message often indicates a network connectivity problem.");
        }
        this.cleanup();
    }

    private synchronized void cleanup() {
        if (!this.isSingletonMaster) {
            return;
        }
        this.isSingletonMaster = false;
        this.monitor.stop();
        this.manager.removeLeaseLostListener(this);
        try {
            this.manager.release(SINGLETON_MASTER);
        }
        catch (LeasingException leasingException) {
            // empty catch block
        }
        this.unbindMigrator();
        if (!"consensus".equals(MigratableServerService.theOne().getLeasingType())) {
            if (!ManagementService.getRuntimeAccess(KERNEL_ID).getServerRuntime().isShuttingDown()) {
                this.start();
            }
        } else {
            AbstractConsensusService.getInstance().removeConsensusServiceGroupViewListener(this.monitor);
        }
    }

    private void bind(final String string, final Object object, final boolean bl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    Context context = null;
                    try {
                        try {
                            Environment environment = new Environment();
                            environment.setCreateIntermediateContexts(true);
                            environment.setReplicateBindings(bl);
                            context = environment.getInitialContext();
                            context.rebind(string, object);
                        }
                        catch (NamingException namingException) {
                            throw new AssertionError((Object)("Unexpected exception" + namingException));
                        }
                        Object var4_4 = null;
                        if (context == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (context == null) throw throwable;
                        try {
                            context.close();
                            throw throwable;
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {}
                    context.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Unexpected exception" + exception));
        }
    }

    private void unbindMigrator() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    Context context = null;
                    try {
                        try {
                            Environment environment = new Environment();
                            context = environment.getContext();
                            context.unbind("weblogic/cluster/singleton/SingletonMonitorRemote");
                        }
                        catch (NamingException namingException) {
                            throw new AssertionError((Object)("Unexpected exception" + namingException));
                        }
                        Object var4_4 = null;
                        if (context == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (context == null) throw throwable;
                        try {
                            context.close();
                            throw throwable;
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {}
                    context.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Unexpected exception" + exception));
        }
    }

    SingletonMonitor getSingletonMonitor() {
        return this.monitor;
    }

    private static final void p(String string) {
        SingletonServicesDebugLogger.debug("SingletonMaster: " + string);
    }

    private static final void p(String string, Exception exception) {
        SingletonServicesDebugLogger.debug("SingletonMaster: " + string, exception);
    }
}

