/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.migration.ExactlyOnceServiceLocationSelector;
import weblogic.cluster.migration.FailureRecoveryServiceLocationSelector;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.RemoteMigratableServiceCoordinator;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.BasicServiceLocationSelector;
import weblogic.cluster.singleton.ClusterMasterRemote;
import weblogic.cluster.singleton.ConsensusServiceGroupViewListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MemberDeathDetector;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.MigratableServiceConstants;
import weblogic.cluster.singleton.MigrationDebugLogger;
import weblogic.cluster.singleton.RemoteSingletonServicesControl;
import weblogic.cluster.singleton.ReplicatedSingletonServicesStateManager;
import weblogic.cluster.singleton.ServiceLocationSelector;
import weblogic.cluster.singleton.ServiceMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.SingletonDataObject;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.cluster.singleton.SingletonMonitorServiceTracker;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManager;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.internal.TxDebug;
import weblogic.work.WorkManagerFactory;

public class SingletonMonitor
implements NakedTimerListener,
MigratableServiceConstants,
SingletonMonitorRemote,
ConsensusServiceGroupViewListener {
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    public static final String LEASE_TYPE = "service";
    private final int leaseRenewInterval;
    private Timer timer;
    private boolean active = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private SingletonMonitorServiceTracker serviceTracker;
    private TimerManager timerManager = null;
    private LeaseManager manager;
    private ClusterMBean cluster;
    private DomainMBean domain;
    private SingletonServicesStateManager stateManager;
    ServiceMigrationRuntimeMBeanImpl runtimeMBean;
    private MemberDeathDetector memberDeathDetector;
    HashSet currentlyRunningMigrations = new HashSet();

    SingletonMonitor(LeaseManager leaseManager, int n) {
        this.manager = leaseManager;
        this.leaseRenewInterval = n;
        this.serviceTracker = new SingletonMonitorServiceTracker(leaseManager);
        this.stateManager = new ReplicatedSingletonServicesStateManager("default-singleton-statemanager", leaseManager);
    }

    private ServiceMigrationRuntimeMBeanImpl getRuntimeMBean() {
        if (this.runtimeMBean != null) {
            return this.runtimeMBean;
        }
        this.runtimeMBean = ServiceMigrationRuntimeMBeanImpl.getInstance();
        return this.runtimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (DEBUG) {
            this.p("Starting singleton monitor");
        }
        this.domain = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.cluster = this.domain.lookupServer(LocalServerIdentity.getIdentity().getServerName()).getCluster();
        this.getRuntimeMBean();
        this.serviceTracker.initialize(this.cluster, this.domain);
        DomainMBean domainMBean = this.domain;
        domainMBean.addBeanUpdateListener(this.serviceTracker);
        DeploymentEventManager.addDeploymentEventListener(this.serviceTracker, false);
        ClusterService.getServices().addClusterMembersListener(this.serviceTracker);
        this.stateManager.leaseAcquired();
        SingletonMonitor singletonMonitor = this;
        synchronized (singletonMonitor) {
            this.active = true;
        }
        if (DEBUG) {
            this.p("Scheduling monitoring service to check lease status every " + this.leaseRenewInterval + " millis.");
        }
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("SingletonServiceTimerManager", "weblogic.kernel.System");
        this.timer = this.timerManager.schedule((TimerListener)this, 0L, (long)this.leaseRenewInterval);
        if (ClusterService.getClusterService().isMemberDeathDetectorEnabled() && !"consensus".equals(MigratableServerService.theOne().getLeasingType())) {
            ClusterExtensionLogger.logStartingMemberDeathDetector();
            this.memberDeathDetector = this.initializeMemberDeathDetector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        SingletonMonitor singletonMonitor = this;
        synchronized (singletonMonitor) {
            this.active = false;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.stateManager.lostLease();
        if (this.memberDeathDetector != null) {
            this.memberDeathDetector.stop();
        }
    }

    public void register(String string) {
        this.serviceTracker.register(string);
    }

    public void registerJTA(String string) {
        this.serviceTracker.registerJTA(string);
    }

    public void unregister(String string) {
        this.serviceTracker.unregister(string);
    }

    public String findServiceLocation(String string) {
        try {
            String string2 = this.manager.findOwner(string);
            ServerMBean serverMBean = null;
            if (string2 != null && this.isServiceActive(string)) {
                serverMBean = this.domain.lookupServer(LeaseManager.getServerNameFromOwnerIdentity(string2));
            }
            return serverMBean == null ? null : serverMBean.getName();
        }
        catch (LeasingException leasingException) {
            return null;
        }
    }

    private boolean isServiceActive(String string) {
        MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
        if (migratableTargetMBean != null && migratableTargetMBean instanceof JTAMigratableTargetMBean) {
            return true;
        }
        return this.stateManager.checkServiceState(string, 1) || this.stateManager.checkServiceState(string, 2);
    }

    private void checkFailedLeases(Collection collection) {
        if (DEBUG) {
            this.p("Checking Failed Leases");
        }
        Map map = this.stateManager.getAllServicesState();
        for (Map.Entry entry : map.entrySet()) {
            Serializable serializable = (Serializable)entry.getKey();
            SingletonServicesState singletonServicesState = (SingletonServicesState)entry.getValue();
            if (singletonServicesState.getState() != 0) continue;
            if (DEBUG) {
                this.p(serializable + " - Detected that it is in Failed State.");
            }
            collection.add(serializable);
        }
    }

    private void checkExpiredLeases(Collection collection) {
        if (DEBUG) {
            this.p("Checking existant, but expired leases");
        }
        String[] stringArray = this.manager.findExpiredLeases();
        for (int i = 0; i < stringArray.length; ++i) {
            if (DEBUG) {
                this.p(stringArray[i] + " - Its an expired lease.");
            }
            SingletonDataObject singletonDataObject = (SingletonDataObject)this.serviceTracker.get(stringArray[i]);
            String string = null;
            if (singletonDataObject == null) {
                SingletonService singletonService = SingletonServicesManager.getInstance().getService(stringArray[i]);
                if (singletonService != null) {
                    string = stringArray[i];
                }
            } else {
                string = singletonDataObject.getName();
            }
            if (string == null) {
                if (!DEBUG) continue;
                this.p(stringArray[i] + " - But the expired lease corresponds to no registered " + "singleton service, ignoring it");
                continue;
            }
            if (collection.contains(string)) continue;
            if (!this.startMigration(string, -1L)) {
                if (!DEBUG) continue;
                this.p(string + " - In the middle of migration. Not starting new one.");
                continue;
            }
            collection.add(string);
        }
    }

    private void checkRegisteredSingletons(Collection collection) {
        if (DEBUG) {
            this.p("Checking for registered Migratable Targets and Singleton Services without a lease");
        }
        for (SingletonDataObject singletonDataObject : this.serviceTracker.values()) {
            String string = singletonDataObject.getName();
            try {
                if (!this.startMigration(string, -1L)) {
                    if (!DEBUG) continue;
                    this.p(string + " - In the middle of migration. Not starting new one.");
                    continue;
                }
                String string2 = this.manager.findOwner(string);
                if (string2 != null) {
                    if (DEBUG) {
                        this.p(string + " - Found an owner - " + string2);
                    }
                    if (singletonDataObject.isJTA() && this.stateManager.getServiceState(string) == null) {
                        ServerMBean serverMBean = this.domain.lookupServer(LeaseManager.getServerNameFromOwnerIdentity(string2));
                        ServiceLocationSelector serviceLocationSelector = this.getServiceLocationSelector(singletonDataObject.getName());
                        serviceLocationSelector.migrationSuccessful(serverMBean, true);
                    }
                    this.endMigration(string);
                    continue;
                }
                if (DEBUG) {
                    this.p(string + " - Detected that it has no lease.");
                }
                collection.add(string);
            }
            catch (LeasingException leasingException) {
                this.endMigration(string);
                ClusterLogger.logExceptionWhileMigratingService((String)(string != null ? string : "an unknown service"), (Exception)leasingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean restartInPlace(String string, ServerMBean serverMBean, int n, ServiceLocationSelector serviceLocationSelector) {
        MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
        if (migratableTargetMBean == null) {
            return false;
        }
        if (!migratableTargetMBean.getRestartOnFailure()) {
            return false;
        }
        if (n == -1 || n != 0 && n != 1 && n != 2) {
            return false;
        }
        if (serverMBean == null) {
            return false;
        }
        int n2 = 0;
        while (true) {
            block21: {
                Object var10_13;
                if (n2 >= migratableTargetMBean.getNumberOfRestartAttempts()) {
                    return false;
                }
                RemoteSingletonServicesControl remoteSingletonServicesControl = this.getRemoteSingletonServicesControl(serverMBean.getName());
                if (remoteSingletonServicesControl == null) {
                    return false;
                }
                if (this.getRuntimeMBean() != null) {
                    this.getRuntimeMBean().migrationStarted(string, serverMBean.getName(), serverMBean.getName());
                }
                try {
                    boolean bl;
                    try {
                        if (DEBUG) {
                            this.p("Trying to re-start service " + string + " on " + serverMBean);
                        }
                        remoteSingletonServicesControl.restartService(string);
                        serviceLocationSelector.migrationSuccessful(serverMBean, true);
                        bl = true;
                        var10_13 = null;
                    }
                    catch (MigrationException migrationException) {
                        if (DEBUG) {
                            migrationException.printStackTrace();
                        }
                        var10_13 = null;
                        if (this.getRuntimeMBean() != null) {
                            this.getRuntimeMBean().migrationCompleted(string, serverMBean.getName(), serverMBean.getName());
                        }
                        break block21;
                    }
                    catch (RemoteException remoteException) {
                        if (DEBUG) {
                            remoteException.printStackTrace();
                        }
                        var10_13 = null;
                        if (this.getRuntimeMBean() != null) {
                            this.getRuntimeMBean().migrationCompleted(string, serverMBean.getName(), serverMBean.getName());
                        }
                        break block21;
                    }
                    if (this.getRuntimeMBean() == null) return bl;
                    this.getRuntimeMBean().migrationCompleted(string, serverMBean.getName(), serverMBean.getName());
                    return bl;
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    if (this.getRuntimeMBean() != null) {
                        this.getRuntimeMBean().migrationCompleted(string, serverMBean.getName(), serverMBean.getName());
                    }
                    throw throwable;
                }
            }
            try {
                Thread.sleep(migratableTargetMBean.getSecondsBetweenRestarts() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void timerExpired(Timer timer) {
        if (!this.isActive()) {
            return;
        }
        if (DEBUG) {
            this.p("Now checking lease statuses.");
        }
        HashSet hashSet = new HashSet();
        this.checkRegisteredSingletons(hashSet);
        this.checkExpiredLeases(hashSet);
        this.checkFailedLeases(hashSet);
        for (final String string : hashSet) {
            if (this.stateManager.checkServiceState(string, 4)) {
                if (DEBUG) {
                    this.p(string + " - needs to be manually migrated. Cannot auto-migrate");
                }
                this.endMigration(string);
                continue;
            }
            MigrationDebugLogger.debug(string + " - Will attempt to auto-migrate.");
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        try {
                                            Object object;
                                            ServerMBean serverMBean;
                                            Object object2;
                                            SingletonDataObject singletonDataObject;
                                            if (!SingletonMonitor.this.isActive()) {
                                                Object var16_1 = null;
                                                break block27;
                                            }
                                            Object object3 = SingletonMonitor.this.serviceTracker.get(string);
                                            if (object3 != null && (singletonDataObject = (SingletonDataObject)object3).isAppScopedSingleton()) {
                                                object2 = singletonDataObject.getTargets().iterator();
                                                boolean bl = true;
                                                while (object2.hasNext()) {
                                                    serverMBean = (ServerMBean)object2.next();
                                                    try {
                                                        object = SingletonMonitor.this.getRemoteSingletonServicesControl(serverMBean.getName());
                                                        if (object == null) continue;
                                                        if (!object.isServiceRegistered(string)) break;
                                                        bl = false;
                                                        break;
                                                    }
                                                    catch (Exception exception) {
                                                    }
                                                }
                                                if (bl) {
                                                    if (DEBUG) {
                                                        SingletonMonitor.this.p(string + " - belongs to app " + singletonDataObject.getAppName() + " which is not active. Skipping its migration");
                                                    }
                                                    break block28;
                                                }
                                            }
                                            int n = 0;
                                            object2 = null;
                                            ServiceLocationSelector serviceLocationSelector = SingletonMonitor.this.getServiceLocationSelector(string);
                                            serverMBean = null;
                                            object = SingletonMonitor.this.findServiceLocation(string);
                                            if (object != null) {
                                                serverMBean = SingletonMonitor.this.domain.lookupServer((String)object);
                                            }
                                            ServerMBean serverMBean2 = null;
                                            int n2 = -1;
                                            SingletonServicesState singletonServicesState = SingletonMonitor.this.stateManager.getServiceState(string);
                                            if (singletonServicesState != null && (n2 = singletonServicesState.getState()) == 0) {
                                                serverMBean2 = SingletonMonitor.this.domain.lookupServer((String)((Object)singletonServicesState.getStateData()));
                                            }
                                            if (serverMBean2 == null) {
                                                try {
                                                    serverMBean2 = SingletonMonitor.this.findPreviousServer(string);
                                                }
                                                catch (LeasingException leasingException) {
                                                    // empty catch block
                                                }
                                            }
                                            List list = null;
                                            list = SingletonMonitor.this.getAllCandidateServers(string);
                                            if (list == null) {
                                                list = SingletonMonitor.this.serviceTracker.getServerList(string);
                                            }
                                            serviceLocationSelector.setServerList(list);
                                            if (serverMBean2 != null) {
                                                serviceLocationSelector.setLastHost(serverMBean2);
                                            }
                                            if (DEBUG) {
                                                String string2 = n2 >= 0 ? SingletonServicesStateManager.STRINGIFIED_STATE[n2] : null;
                                                SingletonMonitor.this.p(string + " - LastState: " + string2 + " LastLocation: " + serverMBean2);
                                            }
                                            if (SingletonMonitor.this.restartInPlace(string, serverMBean2, n2, serviceLocationSelector)) {
                                                MigrationDebugLogger.debug(string + " - Restarted in place...");
                                                break block29;
                                            }
                                            do {
                                                boolean bl;
                                                block32: {
                                                    if (!SingletonMonitor.this.isActive()) {
                                                        break block30;
                                                    }
                                                    object2 = serviceLocationSelector.chooseServer();
                                                    if (object2 == null) break block31;
                                                    if (DEBUG) {
                                                        SingletonMonitor.this.p(string + " - Will attempt to auto-migrate " + " from " + serverMBean + " to " + object2);
                                                    }
                                                    bl = false;
                                                    try {
                                                        bl = SingletonMonitor.this.migrate(string, serverMBean, (ServerMBean)object2, true);
                                                    }
                                                    catch (Exception exception) {
                                                        if (!DEBUG) break block32;
                                                        SingletonMonitor.this.p(string + " - Exception while migrating service it " + " from " + serverMBean + " to " + object2 + " : " + exception);
                                                    }
                                                }
                                                if (bl) {
                                                    serviceLocationSelector.migrationSuccessful((ServerMBean)object2, true);
                                                    break block31;
                                                }
                                                try {
                                                    String string3;
                                                    String[] stringArray = SingletonMonitor.this.manager.findExpiredLeases();
                                                    List<String> list2 = Arrays.asList(stringArray);
                                                    if (list2.contains(string) || (string3 = SingletonMonitor.this.manager.findOwner(string)) == null) continue;
                                                    if (DEBUG) {
                                                        SingletonMonitor.this.p(string + " - Its no more a bad lease. It also has a " + "owner " + string3 + ".No need to migrate it");
                                                    }
                                                    break block31;
                                                }
                                                catch (LeasingException leasingException) {
                                                    // empty catch block
                                                }
                                            } while (++n != list.size());
                                            ClusterLogger.logNoSuitableServerFoundForSingletonService((String)string);
                                            break block31;
                                        }
                                        catch (Throwable throwable) {
                                            Object var16_6 = null;
                                            SingletonMonitor.this.endMigration(string);
                                            throw throwable;
                                        }
                                    }
                                    SingletonMonitor.this.endMigration(string);
                                    return;
                                }
                                Object var16_2 = null;
                                SingletonMonitor.this.endMigration(string);
                                return;
                            }
                            Object var16_3 = null;
                            SingletonMonitor.this.endMigration(string);
                            return;
                        }
                        Object var16_4 = null;
                        SingletonMonitor.this.endMigration(string);
                        return;
                    }
                    Object var16_5 = null;
                    SingletonMonitor.this.endMigration(string);
                }
            });
        }
        this.stateManager.syncState();
    }

    private synchronized boolean isActive() {
        return !ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown() && this.active;
    }

    public boolean migrate(String string, String string2, boolean bl, boolean bl2) throws RemoteException {
        return this.migrate(string, string2);
    }

    public boolean migrateJTA(String string, String string2, boolean bl, boolean bl2) throws RemoteException {
        return this.migrate(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrate(String string, String string2) throws RemoteException {
        boolean bl;
        block10: {
            Object object;
            ServerMBean serverMBean = null;
            try {
                object = this.findServiceLocation(string);
                if (object != null) {
                    serverMBean = this.domain.lookupServer((String)object);
                }
            }
            catch (Exception exception) {
                throw new RemoteException("Unavailable to migrate, current location could not be determined because of an error: " + exception);
            }
            object = this.domain.lookupServer(string2);
            if (object == null) {
                throw new RemoteException("No server named " + string2 + " found.");
            }
            boolean bl2 = false;
            try {
                boolean bl3;
                if (!this.startMigration(string, 3 * this.leaseRenewInterval)) {
                    if (DEBUG) {
                        this.p("Timed out while waiting for auto-migration of " + string + " to complete");
                    }
                    throw new RemoteException("Timed out while waiting for auto-migration of " + string + " to complete");
                }
                bl2 = true;
                if (DEBUG) {
                    this.p(string + " - Manually migrating from " + serverMBean + " to " + object);
                }
                if (bl3 = this.migrate(string, serverMBean, (ServerMBean)object, false)) {
                    ServiceLocationSelector serviceLocationSelector = this.getServiceLocationSelector(string);
                    serviceLocationSelector.migrationSuccessful((ServerMBean)object, false);
                }
                bl = bl3;
                Object var9_10 = null;
                if (!bl2) break block10;
                this.endMigration(string);
            }
            catch (Throwable throwable) {
                block11: {
                    Object var9_11 = null;
                    if (!bl2) break block11;
                    this.endMigration(string);
                }
                throw throwable;
            }
        }
        return bl;
    }

    private SingletonServiceMBean getSingletonServiceMBean(String string) {
        return this.domain.lookupSingletonService(string);
    }

    private MigratableTargetMBean getMigratableTarget(String string) {
        MigratableTargetMBean migratableTargetMBean = null;
        migratableTargetMBean = this.domain.lookupMigratableTarget(string);
        if (migratableTargetMBean != null) {
            return migratableTargetMBean;
        }
        ServerMBean[] serverMBeanArray = this.domain.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            migratableTargetMBean = serverMBeanArray[i].getJTAMigratableTarget();
            if (migratableTargetMBean == null || !migratableTargetMBean.getName().equals(string)) continue;
            return migratableTargetMBean;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivateJTA(String string, String string2) throws RemoteException {
        block11: {
            try {
                String string3;
                if (!this.startMigration(string, 3 * this.leaseRenewInterval)) {
                    if (!DEBUG) throw new RemoteException("Timed out while waiting for JTA MT auto-migration of " + string + " to complete");
                    this.p(string + " - Timed out while waiting for JTA MT auto-migration " + "to complete");
                    throw new RemoteException("Timed out while waiting for JTA MT auto-migration of " + string + " to complete");
                }
                if (DEBUG) {
                    this.p(string + " - Going to deactivate JTA MT with host " + string2);
                }
                if ((string3 = this.findServiceLocation(string)) == null || string3.equals(string2)) {
                    if (DEBUG) {
                        this.p(string + " - Current location of JTA MT = " + string3 + ".No need to deactivate");
                    }
                    this.stateManager.removeServiceState(string);
                    Object var7_4 = null;
                    this.endMigration(string);
                    return;
                }
                RemoteSingletonServicesControl remoteSingletonServicesControl = this.getRemoteSingletonServicesControl(string3);
                if (remoteSingletonServicesControl != null) {
                    if (DEBUG) {
                        this.p(string + " - Going to deactivate JTA MT on " + string3);
                    }
                    remoteSingletonServicesControl.deactivateService(string);
                    this.stateManager.removeServiceState(string);
                    break block11;
                }
                try {
                    String string4 = this.manager.findOwner(string);
                    if (string4 != null) {
                        throw new RemoteException("Could not deactivate JTA service " + string + ", " + string3 + " could not be reached.");
                    }
                }
                catch (LeasingException leasingException) {
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.endMigration(string);
                throw throwable;
            }
        }
        Object var7_5 = null;
        this.endMigration(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean migrate(String string, ServerMBean serverMBean, ServerMBean serverMBean2, boolean bl) {
        boolean bl2;
        if (string == null) {
            return true;
        }
        if (this.serviceTracker.get(string) == null && SingletonServicesManager.getInstance().getService(string) == null) {
            if (!DEBUG) return true;
            this.p(string + " - No such service is registered, despite there being a lease for it." + " Ignoring for now.");
            return true;
        }
        RemoteSingletonServicesControl remoteSingletonServicesControl = null;
        RemoteSingletonServicesControl remoteSingletonServicesControl2 = null;
        try {
            try {
                block19: {
                    if (this.getRuntimeMBean() != null) {
                        this.getRuntimeMBean().migrationStarted(string, serverMBean != null ? serverMBean.getName() : "inactive", serverMBean2 != null ? serverMBean2.getName() : "no target");
                    }
                    if (serverMBean != null) {
                        remoteSingletonServicesControl = this.getRemoteSingletonServicesControl(serverMBean.getName());
                    }
                    if ((remoteSingletonServicesControl2 = this.getRemoteSingletonServicesControl(serverMBean2.getName())) == null) {
                        String string2 = string + " - Error talking to destination server - " + serverMBean2 + " . Can't migrate.";
                        if (!DEBUG) throw new MigrationException(string2);
                        this.p(string2);
                        throw new MigrationException(string2);
                    }
                    MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
                    if (remoteSingletonServicesControl == null) {
                        if (DEBUG) {
                            this.p(string + " - Error talking to source server, it may have crashed. " + "Continuing with its migration to " + serverMBean2);
                        }
                    } else {
                        if (this.getMigratableTarget(string) instanceof JTAMigratableTargetMBean && serverMBean.getName().equals(string)) {
                            ClusterLogger.logAttemptedJTAMigrationFromLivingServer((String)serverMBean.getName());
                            boolean bl3 = true;
                            Object var10_13 = null;
                            if (this.getRuntimeMBean() == null) return bl3;
                            this.getRuntimeMBean().migrationCompleted(string, serverMBean != null ? serverMBean.getName() : "inactive", serverMBean2 != null ? serverMBean2.getName() : "no target");
                            return bl3;
                        }
                        try {
                            if (DEBUG) {
                                this.p(string + " - Attempting to deactivate it" + " on the source server - " + serverMBean);
                            }
                            remoteSingletonServicesControl.deactivateService(string);
                        }
                        catch (PeerGoneException peerGoneException) {
                            if (!DEBUG) break block19;
                            this.p(string + " - Error talking to source server - " + serverMBean + " . It may have crashed. Continuing with the migration.");
                        }
                    }
                }
                if (DEBUG) {
                    this.p(string + " - Attempting to activate the service" + " on the target server - " + serverMBean2);
                }
                remoteSingletonServicesControl2.activateService(string);
                if (DEBUG) {
                    this.p(string + " - Service succesfully activated on remote server - " + serverMBean2.getName());
                }
                bl2 = true;
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) throw new MigrationException("Exception - " + remoteException);
                this.p("Error communicating to remote server, or no named service registered", remoteException);
                throw new MigrationException("Exception - " + remoteException);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (this.getRuntimeMBean() == null) throw throwable;
            this.getRuntimeMBean().migrationCompleted(string, serverMBean != null ? serverMBean.getName() : "inactive", serverMBean2 != null ? serverMBean2.getName() : "no target");
            throw throwable;
        }
        Object var10_14 = null;
        if (this.getRuntimeMBean() == null) return bl2;
        this.getRuntimeMBean().migrationCompleted(string, serverMBean != null ? serverMBean.getName() : "inactive", serverMBean2 != null ? serverMBean2.getName() : "no target");
        return bl2;
    }

    private RemoteMigratableServiceCoordinator getRemoteMigratableServiceCoordinator() {
        String string;
        try {
            string = URLManager.findAdministrationURL(this.domain.getAdminServerName());
            if (DEBUG) {
                this.p("Admin URL for looking up RemoteMigratableServiceCoordinator:" + string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        Environment environment = new Environment();
        environment.setProviderUrl(string);
        try {
            Context context = environment.getInitialContext();
            return (RemoteMigratableServiceCoordinator)context.lookup("weblogic.cluster.migration.migratableServiceCoordinator");
        }
        catch (NamingException namingException) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Unexpected exception while getting RemoteMigratableServiceCoordinator", (Throwable)namingException);
            }
            return null;
        }
    }

    private ServerMBean findPreviousServer(String string) throws LeasingException {
        String string2;
        if (DEBUG) {
            this.p(string + " - Finding its previous location");
        }
        if ((string2 = this.manager.findPreviousOwner(string)) == null) {
            if (DEBUG) {
                this.p(string + " - Couldn't find its current or previous location");
            }
            return null;
        }
        if (DEBUG) {
            this.p(string + " - Its previous location is: " + LeaseManager.getServerNameFromOwnerIdentity(string2));
        }
        return this.domain.lookupServer(LeaseManager.getServerNameFromOwnerIdentity(string2));
    }

    private boolean isServerRunning(String string) {
        try {
            ClusterMasterRemote clusterMasterRemote;
            if (DEBUG) {
                this.p("Checking if " + string + " is running.");
            }
            if ((clusterMasterRemote = MigratableServerService.theOne().getClusterMasterRemote()) == null) {
                return true;
            }
            String string2 = clusterMasterRemote.getServerLocation(string);
            if (string2 == null) {
                return false;
            }
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            MachineMBean machineMBean = domainMBean.lookupMachine(string2);
            ServerMBean serverMBean = domainMBean.lookupServer(string);
            NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
            String string3 = nodeManagerRuntime.getState(serverMBean);
            if (DEBUG) {
                this.p("Current state of " + string + " is: " + string3);
            }
            if (!(string3 == null || string3.equals("STARTING") || string3.equals("RUNNING") || string3.equals("STANDBY") || string3.equals("ADMIN") || string3.equals("RESUMING") || string3.equals("UNKNOWN"))) {
                if (DEBUG) {
                    this.p("We consider that state NON-RUNNING.");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (DEBUG) {
                this.p("Error while talking to NM, considering server down.", iOException);
            }
            return false;
        }
        catch (LeasingException leasingException) {
            if (DEBUG) {
                this.p("Error while talking to remote ClusterMaster, considering server down.", leasingException);
            }
            return false;
        }
        if (DEBUG) {
            this.p("We consider that state RUNNING.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RemoteSingletonServicesControl getRemoteSingletonServicesControl(String string) {
        RemoteSingletonServicesControl remoteSingletonServicesControl;
        Context context;
        block17: {
            String string2;
            Environment environment;
            block15: {
                RemoteSingletonServicesControl remoteSingletonServicesControl2;
                block16: {
                    environment = new Environment();
                    context = null;
                    string2 = null;
                    if (!this.isServerRunning(string)) {
                        return null;
                    }
                    try {
                        string2 = URLManager.findAdministrationURL(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        string2 = MigratableServerService.findURLOfUnconnectedServer(string);
                    }
                    if (DEBUG) {
                        this.p("Contacting " + string + " at " + string2 + " to perform migration tasks.");
                    }
                    if (string2 != null) break block15;
                    remoteSingletonServicesControl2 = null;
                    Object var8_9 = null;
                    if (context == null) break block16;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                return remoteSingletonServicesControl2;
            }
            environment.setProviderUrl(string2);
            environment.setRequestTimeout(10000L);
            remoteSingletonServicesControl = (RemoteSingletonServicesControl)PortableRemoteObject.narrow((Object)environment.getInitialReference(SingletonServicesManager.class), RemoteSingletonServicesControl.class);
            Object var8_10 = null;
            if (context == null) break block17;
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return remoteSingletonServicesControl;
        catch (NamingException namingException) {
            RemoteSingletonServicesControl remoteSingletonServicesControl3;
            block18: {
                try {
                    if (DEBUG) {
                        this.p("Could not find RemoteSingletonServicesControl on " + string, namingException);
                    }
                    remoteSingletonServicesControl3 = null;
                    Object var8_11 = null;
                    if (context == null) break block18;
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var8_12 = null;
                        if (context == null) break block19;
                        try {
                            context.close();
                        }
                        catch (NamingException namingException2) {}
                    }
                    throw throwable;
                }
                try {
                    context.close();
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
            }
            return remoteSingletonServicesControl3;
        }
    }

    private List getAllCandidateServers(String string) {
        List<ServerMBean> list = null;
        ServerMBean[] serverMBeanArray = null;
        MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
        if (migratableTargetMBean != null) {
            serverMBeanArray = migratableTargetMBean.getAllCandidateServers();
        } else {
            SingletonServiceMBean singletonServiceMBean = this.getSingletonServiceMBean(string);
            if (singletonServiceMBean != null) {
                serverMBeanArray = singletonServiceMBean.getAllCandidateServers();
            }
        }
        if (serverMBeanArray != null && serverMBeanArray.length > 0) {
            list = Arrays.asList(serverMBeanArray);
        }
        return list;
    }

    private ServerMBean getUserPreferedServer(String string) {
        ServerMBean serverMBean = null;
        MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
        if (migratableTargetMBean != null) {
            serverMBean = migratableTargetMBean.getUserPreferredServer();
        }
        return serverMBean;
    }

    private void p(Object object) {
        SingletonServicesDebugLogger.debug("SingletonMonitor: " + object);
    }

    private void p(Object object, Exception exception) {
        SingletonServicesDebugLogger.debug("SingletonMonitor: " + object, exception);
    }

    public ServiceLocationSelector getServiceLocationSelector(String string) {
        Object object;
        MigratableTargetMBean migratableTargetMBean = this.getMigratableTarget(string);
        if (migratableTargetMBean != null) {
            object = migratableTargetMBean.getMigrationPolicy();
            if (((String)object).equals("exactly-once")) {
                return new ExactlyOnceServiceLocationSelector(migratableTargetMBean, this.stateManager);
            }
            if (((String)object).equals("failure-recovery")) {
                return new FailureRecoveryServiceLocationSelector(migratableTargetMBean, this.stateManager);
            }
        }
        object = new BasicServiceLocationSelector(string, this.stateManager);
        SingletonServiceMBean singletonServiceMBean = this.getSingletonServiceMBean(string);
        if (singletonServiceMBean != null) {
            ((BasicServiceLocationSelector)object).setUPS(singletonServiceMBean.getUserPreferredServer());
        }
        return object;
    }

    public SingletonServicesStateManager getSingletonServicesStateManager() {
        return this.stateManager;
    }

    public void memberAdded(String string) {
    }

    public void memberRemoved(String string) {
        for (SingletonDataObject singletonDataObject : this.serviceTracker.values()) {
            String string2 = singletonDataObject.getName();
            try {
                String string3;
                String string4;
                String string5 = this.manager.findOwner(string2);
                if (string5 == null || !(string4 = LeaseManager.getServerNameFromOwnerIdentity(string5)).equals(string) || !SingletonMonitor.canMigrateLease(string3 = AbstractConsensusService.getInstance().getServerState(string))) continue;
                if (DEBUG) {
                    this.p(string + " is marked as " + string3 + ". Voiding all its leases");
                }
                this.manager.voidLeases(string5);
                break;
            }
            catch (LeasingException leasingException) {
            }
        }
    }

    public static boolean canMigrateLease(String string) {
        boolean bl = false;
        if (string != null && (string.equals("FAILED_NOT_RESTARTABLE") || string.equals("FAILED_RESTARTING") || string.equals("FAILED") || string.equals("ACTIVATE_LATER") || string.equals("STARTING"))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startMigration(String string, long l) {
        HashSet hashSet = this.currentlyRunningMigrations;
        synchronized (hashSet) {
            long l2 = System.currentTimeMillis();
            while (this.currentlyRunningMigrations.contains(string)) {
                if (l < 0L || l2 + l < System.currentTimeMillis()) {
                    return false;
                }
                try {
                    if (DEBUG) {
                        this.p("Going to wait for " + l + " ms. to get lock for " + string);
                    }
                    this.currentlyRunningMigrations.wait(l);
                }
                catch (Exception exception) {}
            }
            this.currentlyRunningMigrations.add(string);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean endMigration(String string) {
        HashSet hashSet = this.currentlyRunningMigrations;
        synchronized (hashSet) {
            this.currentlyRunningMigrations.notify();
            return this.currentlyRunningMigrations.remove(string);
        }
    }

    protected MemberDeathDetector initializeMemberDeathDetector() {
        MemberDeathDetector memberDeathDetector = null;
        try {
            memberDeathDetector = SingletonMonitor.getMemberDeathDetector();
            memberDeathDetector.start();
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
        return memberDeathDetector;
    }

    public void notifyShutdown(String string) {
        if (this.memberDeathDetector != null) {
            this.memberDeathDetector.removeMember(string);
        }
    }

    private static MemberDeathDetector getMemberDeathDetector() throws ServiceFailureException {
        try {
            Class clazz = SingletonMonitor.getMemberDeathDetectorClass();
            Method method = clazz.getMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            return (MemberDeathDetector)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new ServiceFailureException("Unable to find class: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new ServiceFailureException("No such method: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl.getInstance()");
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new ServiceFailureException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new ServiceFailureException(illegalAccessException.getCause());
        }
    }

    private static Class getMemberDeathDetectorClass() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("weblogic.cluster.messaging.internal.MemberDeathDetectorImpl");
        return clazz;
    }
}

