/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.SingletonDataObject;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventListener;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.j2ee.descriptor.wl.SingletonServiceBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.configuration.TargetMBean;

public class SingletonMonitorServiceTracker
implements ClusterMembersChangeListener,
DeploymentEventListener,
BeanUpdateListener {
    private static final boolean DEBUG = false;
    private ClusterMBean cluster;
    private DomainMBean domain;
    private HashMap allSingletons;
    private LeaseManager manager;
    private ArrayList allServers;

    SingletonMonitorServiceTracker(LeaseManager leaseManager) {
        this.manager = leaseManager;
    }

    void initialize(ClusterMBean clusterMBean, DomainMBean domainMBean) {
        this.cluster = clusterMBean;
        this.domain = domainMBean;
        this.allServers = new ArrayList();
        this.populateServerList();
        this.allSingletons = new HashMap();
        this.addAppscopedSingletons();
        this.addStaticallyDeployedSingletons();
    }

    public synchronized Object get(Object object) {
        return this.allSingletons.get(object);
    }

    public synchronized void remove(Object object) {
        this.allSingletons.remove(object);
    }

    public synchronized void put(Object object, Object object2) {
        this.allSingletons.put(object, object2);
    }

    public synchronized Collection values() {
        return ((HashMap)this.allSingletons.clone()).values();
    }

    private synchronized void addStaticallyDeployedSingletons() {
        MigratableTargetMBean[] migratableTargetMBeanArray = this.domain.getMigratableTargets();
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            if (migratableTargetMBeanArray[i].getMigrationPolicy().equals("manual") || !this.cluster.equals(migratableTargetMBeanArray[i].getCluster())) continue;
            this.allSingletons.put(migratableTargetMBeanArray[i].getName(), new SingletonDataObject(migratableTargetMBeanArray[i].getName()));
        }
        SingletonServiceMBean[] singletonServiceMBeanArray = this.domain.getSingletonServices();
        for (int i = 0; i < singletonServiceMBeanArray.length; ++i) {
            if (singletonServiceMBeanArray[i].getCluster() == null || !singletonServiceMBeanArray[i].getCluster().getName().equals(this.cluster.getName()) || this.allSingletons.containsKey(singletonServiceMBeanArray[i].getName())) continue;
            this.allSingletons.put(singletonServiceMBeanArray[i].getName(), new SingletonDataObject(singletonServiceMBeanArray[i].getName()));
        }
        ServerMBean[] serverMBeanArray = this.domain.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBeanArray[i].getJTAMigratableTarget();
            if (jTAMigratableTargetMBean == null || !jTAMigratableTargetMBean.getMigrationPolicy().equals("failure-recovery") || !this.cluster.equals(jTAMigratableTargetMBean.getCluster())) continue;
            this.allSingletons.put(jTAMigratableTargetMBean.getName(), new SingletonDataObject(jTAMigratableTargetMBean.getName(), true));
        }
    }

    private synchronized void addAppscopedSingletons() {
        AppDeploymentMBean[] appDeploymentMBeanArray = this.domain.getAppDeployments();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            SingletonServiceBean[] singletonServiceBeanArray;
            ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(appDeploymentMBeanArray[i].getApplicationIdentifier());
            if (applicationContextInternal == null) continue;
            WeblogicApplicationBean weblogicApplicationBean = null;
            try {
                singletonServiceBeanArray = applicationContextInternal.getApplicationDescriptor();
                if (singletonServiceBeanArray == null) continue;
                weblogicApplicationBean = singletonServiceBeanArray.getWeblogicApplicationDescriptor();
            }
            catch (IOException iOException) {
                continue;
            }
            catch (XMLStreamException xMLStreamException) {
                continue;
            }
            if (weblogicApplicationBean == null || (singletonServiceBeanArray = weblogicApplicationBean.getSingletonServices()) == null) continue;
            String string = ApplicationVersionUtils.getVersionId(appDeploymentMBeanArray[i].getApplicationIdentifier());
            for (int j = 0; j < singletonServiceBeanArray.length; ++j) {
                String string2 = SingletonServicesManager.Util.getAppscopedSingletonServiceName(singletonServiceBeanArray[j].getName(), string);
                if (this.allSingletons.containsKey(string2)) continue;
                this.allSingletons.put(string2, new SingletonDataObject(string2, appDeploymentMBeanArray[i].getApplicationIdentifier(), this.getApplicationTargets(appDeploymentMBeanArray[i])));
            }
        }
    }

    private synchronized void populateServerList() {
        ServerMBean[] serverMBeanArray = this.domain.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i].getCluster() == null || !serverMBeanArray[i].getCluster().getName().equals(this.cluster.getName())) continue;
            this.allServers.add(serverMBeanArray[i]);
        }
    }

    public List getServerList(String string) {
        SingletonDataObject singletonDataObject = (SingletonDataObject)this.allSingletons.get(string);
        if (singletonDataObject != null && singletonDataObject.isAppScopedSingleton()) {
            return singletonDataObject.getTargets();
        }
        return this.allServers;
    }

    public void register(String string) {
        this.allSingletons.put(string, new SingletonDataObject(string));
    }

    public void registerJTA(String string) {
        this.allSingletons.put(string, new SingletonDataObject(string, true));
    }

    public void unregister(String string) {
        this.allSingletons.remove(string);
    }

    private List getApplicationTargets(AppDeploymentMBean appDeploymentMBean) {
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        List<TargetMBean> list = null;
        if (targetMBeanArray != null && targetMBeanArray.length > 0) {
            if (targetMBeanArray[0].getName().equals(this.cluster.getName())) {
                ServerMBean[] serverMBeanArray = this.cluster.getServers();
                list = Arrays.asList(serverMBeanArray);
            } else {
                list = Arrays.asList(targetMBeanArray);
            }
        }
        return list;
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
    }

    public synchronized void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            ConfigurationMBean configurationMBean;
            Object object;
            if (propertyUpdateArray[i].getUpdateType() == 2) {
                object = propertyUpdateArray[i].getAddedObject();
                if (object instanceof ServerMBean) {
                    configurationMBean = (ConfigurationMBean)object;
                    this.allServers.add(configurationMBean);
                    continue;
                }
                if (object instanceof MigratableTargetMBean) {
                    configurationMBean = (MigratableTargetMBean)object;
                    if (configurationMBean.getMigrationPolicy().equals("manual") || !this.cluster.equals(configurationMBean.getCluster())) continue;
                    this.allSingletons.put(configurationMBean.getName(), new SingletonDataObject(configurationMBean.getName()));
                    continue;
                }
                if (!(object instanceof SingletonServiceMBean) || !this.cluster.equals((configurationMBean = (SingletonServiceMBean)object).getCluster()) || this.allSingletons.containsKey(configurationMBean.getName())) continue;
                this.allSingletons.put(configurationMBean.getName(), new SingletonDataObject(configurationMBean.getName()));
                continue;
            }
            if (propertyUpdateArray[i].getUpdateType() != 3) continue;
            object = propertyUpdateArray[i].getRemovedObject();
            if (object instanceof ServerMBean) {
                configurationMBean = (ConfigurationMBean)object;
                this.allServers.remove(configurationMBean);
                continue;
            }
            if (object instanceof MigratableTargetMBean) {
                configurationMBean = (MigratableTargetMBean)object;
                if (!this.allSingletons.containsKey(configurationMBean.getName())) continue;
                this.allSingletons.remove(configurationMBean.getName());
                continue;
            }
            if (!(object instanceof SingletonServiceMBean) || !this.allSingletons.containsKey((configurationMBean = (SingletonServiceMBean)object).getName())) continue;
            this.allSingletons.remove(configurationMBean.getName());
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public void applicationRedeployed(DeploymentEvent deploymentEvent) {
    }

    public synchronized void applicationDeleted(DeploymentEvent deploymentEvent) {
        AppDeploymentMBean appDeploymentMBean = deploymentEvent.getAppDeployment();
        if (appDeploymentMBean == null) {
            return;
        }
        for (SingletonDataObject singletonDataObject : this.values()) {
            if (!singletonDataObject.isAppScopedSingleton() || !singletonDataObject.getAppName().equals(appDeploymentMBean.getApplicationIdentifier())) continue;
            this.allSingletons.remove(singletonDataObject.getName());
        }
    }

    public synchronized void applicationActivated(DeploymentEvent deploymentEvent) {
        AppDeploymentMBean appDeploymentMBean = deploymentEvent.getAppDeployment();
        if (appDeploymentMBean == null) {
            return;
        }
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(appDeploymentMBean.getApplicationIdentifier());
        if (applicationContextInternal == null) {
            return;
        }
        WeblogicApplicationBean weblogicApplicationBean = applicationContextInternal.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return;
        }
        SingletonServiceBean[] singletonServiceBeanArray = weblogicApplicationBean.getSingletonServices();
        if (singletonServiceBeanArray == null || singletonServiceBeanArray.length == 0) {
            return;
        }
        List list = this.getApplicationTargets(appDeploymentMBean);
        String string = ApplicationVersionUtils.getVersionId(appDeploymentMBean.getApplicationIdentifier());
        for (int i = 0; i < singletonServiceBeanArray.length; ++i) {
            if (this.allSingletons.containsKey(singletonServiceBeanArray[i].getName())) continue;
            String string2 = SingletonServicesManager.Util.getAppscopedSingletonServiceName(singletonServiceBeanArray[i].getName(), string);
            this.allSingletons.put(string2, new SingletonDataObject(string2, appDeploymentMBean.getApplicationIdentifier(), list));
        }
    }

    public synchronized void applicationDeployed(DeploymentEvent deploymentEvent) {
        this.applicationActivated(deploymentEvent);
    }

    private void p(Object object) {
        System.out.println("<SingletonMonitorServiceTracker> " + object.toString());
    }

    private void p(Object object, Exception exception) {
        System.out.println("<SingletonMonitorServiceTracker> " + object.toString() + " --- " + exception);
    }
}

