/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseManagerFactory;
import weblogic.cluster.singleton.SingletonService;

public class SingletonServiceWrapper
implements SingletonService,
LeaseLostListener {
    private SingletonService delegate;
    private boolean active = false;

    public SingletonServiceWrapper(SingletonService singletonService) {
        this.delegate = singletonService;
    }

    public void onRelease() {
        this.deactivate();
    }

    public synchronized void activate() {
        if (this.active) {
            return;
        }
        this.delegate.activate();
        this.registerWithSingletonMonitorLeaseManager();
        this.active = true;
    }

    public synchronized void deactivate() {
        if (!this.active) {
            return;
        }
        this.unregisterWithSingletonMonitorLeaseManager();
        this.delegate.deactivate();
        this.active = false;
    }

    private void registerWithSingletonMonitorLeaseManager() {
        LeaseManager leaseManager = LeaseManagerFactory.singleton().getLeaseManager("service");
        leaseManager.addLeaseLostListener(this);
    }

    private void unregisterWithSingletonMonitorLeaseManager() {
        LeaseManager leaseManager = LeaseManagerFactory.singleton().getLeaseManager("service");
        leaseManager.removeLeaseLostListener(this);
    }
}

