/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.rmi.RemoteException;
import java.security.AccessController;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.StackTraceUtils;

public class SingletonServicesBatchManager
implements ServerService,
TimerListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static SingletonServicesBatchManager singleton;
    private boolean started = false;
    private static final long SINGLETON_MONITOR_DISCOVERY_PERIOD_MILLIS = 10000L;

    public String getName() {
        return "Singleton Services Batch Manager";
    }

    public String getVersion() {
        return "1.0";
    }

    synchronized boolean hasStarted() {
        return this.started;
    }

    static SingletonServicesBatchManager theOne() {
        return singleton;
    }

    public synchronized void startService(String string) throws IllegalArgumentException {
        try {
            this.registerWithSingletonMonitor(string);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Unable to register singleton service '" + string + "'\n" + StackTraceUtils.throwable2StackTrace((Throwable)remoteException)));
        }
        catch (LeasingException leasingException) {
            throw new AssertionError((Object)("Unable to register singleton service '" + string + "'\n" + StackTraceUtils.throwable2StackTrace((Throwable)leasingException)));
        }
    }

    public synchronized void start() throws ServiceFailureException {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean.getCluster() == null) {
            return;
        }
        singleton = new SingletonServicesBatchManager();
        SingletonServicesBatchManager.singleton.started = true;
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 0L, 10000L);
    }

    private void registerWithSingletonMonitor(String string) throws RemoteException, LeasingException {
        SingletonMonitorRemote singletonMonitorRemote = MigratableServerService.theOne().getSingletonMasterRemote();
        if (singletonMonitorRemote == null) {
            throw new LeasingException("Could not contact Singleton Monitor.");
        }
        singletonMonitorRemote.register(string);
    }

    public void timerExpired(Timer timer) {
        Object[] objectArray;
        try {
            objectArray = MigratableServerService.theOne().getSingletonMasterRemote();
            if (objectArray == null) {
                return;
            }
        }
        catch (LeasingException leasingException) {
            return;
        }
        objectArray = SingletonServicesManager.getInstance().getInternalSingletonServices();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            try {
                this.registerWithSingletonMonitor(string);
                continue;
            }
            catch (RemoteException remoteException) {
                throw new AssertionError((Object)("Unable to register singleton service '" + string + "'\n" + StackTraceUtils.throwable2StackTrace((Throwable)remoteException)));
            }
            catch (LeasingException leasingException) {
                throw new AssertionError((Object)("Unable to register singleton service '" + string + "'\n" + StackTraceUtils.throwable2StackTrace((Throwable)leasingException)));
            }
        }
        timer.cancel();
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }
}

