/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.singleton;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.migration.MigratableGroup;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.RemoteSingletonServicesControl;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServiceWrapper;
import weblogic.cluster.singleton.SingletonServicesBatchManager;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.work.InheritableThreadContext;

public final class SingletonServicesManager
implements RemoteSingletonServicesControl,
BeanUpdateListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final SingletonServicesManager THE_ONE = new SingletonServicesManager();
    private LeaseManager manager;
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    private final HashMap nameToServiceMap = new HashMap();
    private final HashMap internalServiceMap = new HashMap();
    private final HashMap nameToContextMap = new HashMap();
    private final HashMap constructedClassesMap = new HashMap();
    private final ArrayList activeServices = new ArrayList();
    private ClusterMBean myCluster;
    private ServerMBean myserver;
    private boolean started = false;

    public void start() throws ServiceFailureException {
        this.myserver = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.myCluster = this.myserver.getCluster();
        this.manager = ClusterService.getServices().getDefaultLeaseManager("service");
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        domainMBean.addBeanUpdateListener(SingletonServicesManager.getInstance());
        this.started = true;
        this.startSingletonServices();
        try {
            ServerHelper.exportObject((Remote)this, (int)ClusterService.getClusterService().getHeartbeatTimeoutMillis());
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
    }

    public void stop() {
        for (String string : (ArrayList)this.activeServices.clone()) {
            try {
                this.deactivateService(string);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized String[] getActiveServiceNames() {
        Object[] objectArray = this.activeServices.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    Object[] getRegisteredSingletonServices() {
        return this.nameToServiceMap.keySet().toArray();
    }

    Object[] getInternalSingletonServices() {
        return this.internalServiceMap.keySet().toArray();
    }

    public static SingletonServicesManager getInstance() {
        return THE_ONE;
    }

    public void startSingletonServices() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        SingletonServiceMBean[] singletonServiceMBeanArray = domainMBean.getSingletonServices();
        for (int i = 0; i < singletonServiceMBeanArray.length; ++i) {
            try {
                if (singletonServiceMBeanArray[i].getCluster() != null && !singletonServiceMBeanArray[i].getCluster().getName().equals(this.myCluster.getName()) || !singletonServiceMBeanArray[i].isCandidate(this.myserver)) continue;
                this.addConfiguredService(singletonServiceMBeanArray[i].getName(), SingletonServicesManager.constructSingletonService(singletonServiceMBeanArray[i].getClassName(), null));
                continue;
            }
            catch (DeploymentException deploymentException) {
                if (!DEBUG) continue;
                this.p("Couldn't deploy " + singletonServiceMBeanArray[i].getClassName(), (Exception)((Object)deploymentException));
            }
        }
    }

    public synchronized SingletonService getService(String string) {
        return (SingletonService)this.nameToServiceMap.get(string);
    }

    public boolean isServiceActive(String string) {
        boolean bl = false;
        SingletonService singletonService = this.getService(string);
        if (singletonService != null && this.activeServices.contains(string)) {
            bl = true;
        }
        return bl;
    }

    public boolean isServiceRegistered(String string) {
        boolean bl = false;
        SingletonService singletonService = this.getService(string);
        if (singletonService != null) {
            bl = true;
        }
        return bl;
    }

    public synchronized void activateService(String string) throws RemoteException {
        SingletonService singletonService;
        if (ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) {
            String string2 = "Service named " + string + " cannot be activated as the server is shutting down";
            if (DEBUG) {
                this.p(string2);
            }
            throw new RemoteException(string2);
        }
        if (DEBUG) {
            this.p("Activating Singleton Service: " + string);
        }
        if ((singletonService = (SingletonService)this.nameToServiceMap.get(string)) == null) {
            throw new RemoteException("No service named " + string + " found on this server.");
        }
        try {
            if (!(singletonService instanceof MigratableGroup) && !this.manager.tryAcquire(string)) {
                if (DEBUG) {
                    this.p("Could not acquire lease for " + string + ", stopping activation.");
                }
                throw new RemoteException("Could not start service " + string + " because could not claim lease");
            }
        }
        catch (LeasingException leasingException) {
            if (DEBUG) {
                this.p("Could not acquire lease for " + string + ", stopping activation.");
            }
            throw new RemoteException("Could not start service because could not claim lease." + leasingException, leasingException);
        }
        InheritableThreadContext inheritableThreadContext = null;
        try {
            try {
                if (this.nameToContextMap.get(string) != null) {
                    inheritableThreadContext = (InheritableThreadContext)this.nameToContextMap.get(string);
                    if (DEBUG) {
                        this.p("Setting up thread context for activation of " + string);
                    }
                    inheritableThreadContext.push();
                }
                singletonService.activate();
                if (DEBUG) {
                    this.p(string + " successfully activated.");
                }
                ClusterLogger.logActivatedSingletonService((String)string);
                this.activeServices.add(string);
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    this.p("Failed to activate service " + string + " - " + throwable.getMessage());
                }
                try {
                    this.manager.release(string);
                }
                catch (LeasingException leasingException) {
                    throw new RemoteException("Error trying to release lease because of failed activation: " + leasingException, leasingException);
                }
                throw new RemoteException("Error trying to activate service " + string + ": " + throwable, throwable);
            }
            Object var7_6 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivateService(String string) throws RemoteException {
        SingletonService singletonService;
        block12: {
            if (DEBUG) {
                this.p("Deactivating Singleton Service: " + string);
            }
            if ((singletonService = (SingletonService)this.nameToServiceMap.get(string)) == null) {
                throw new RemoteException("No service named " + string + " found on this server.");
            }
            if (!(singletonService instanceof MigratableGroup) && !this.internalServiceMap.containsKey(string)) {
                try {
                    this.manager.release(string);
                }
                catch (LeasingException leasingException) {
                    if (!DEBUG) break block12;
                    this.p("Could not release lease for " + string + ". Ignoring and continuing " + "with the deactivation, since we do not own the lease.");
                }
            }
        }
        InheritableThreadContext inheritableThreadContext = null;
        try {
            if (this.nameToContextMap.get(string) != null) {
                inheritableThreadContext = (InheritableThreadContext)this.nameToContextMap.get(string);
                if (DEBUG) {
                    this.p("Setting up thread context for deactivation of " + string);
                }
                inheritableThreadContext.push();
            }
            singletonService.deactivate();
            if (DEBUG) {
                this.p(string + " successfully deactivated.");
            }
            ClusterLogger.logDeactivatedSingletonService((String)string);
            this.activeServices.remove(string);
            Object var5_5 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restartService(String string) throws RemoteException {
        SingletonService singletonService = (SingletonService)this.nameToServiceMap.get(string);
        if (singletonService == null) {
            throw new RemoteException("No service named " + string + " found on this server.");
        }
        if (!(singletonService instanceof MigratableGroup)) {
            throw new RemoteException("Only migratable targets can be restarted.");
        }
        InheritableThreadContext inheritableThreadContext = null;
        try {
            if (this.nameToContextMap.get(string) != null) {
                inheritableThreadContext = (InheritableThreadContext)this.nameToContextMap.get(string);
                if (DEBUG) {
                    this.p("Setting up thread context for deactivation of " + string);
                }
                inheritableThreadContext.push();
            }
            ((MigratableGroup)singletonService).restart();
            if (DEBUG) {
                this.p(string + " successfully restarted.");
            }
            Object var5_4 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inheritableThreadContext != null) {
                inheritableThreadContext.pop();
            }
            throw throwable;
        }
    }

    public synchronized void addConfiguredService(String string, SingletonService singletonService) throws IllegalArgumentException {
        if (!this.started) {
            throw new IllegalArgumentException("Cannot add Singleton Service " + string + " as SingletonServicesManager not started. " + " Check if MigrationBasis for cluster is configured.");
        }
        if (this.getService(string) != null) {
            throw new IllegalArgumentException(string + " has been registered as a singleton service already.");
        }
        if (DEBUG) {
            this.p("Registering " + string + " on this server.");
        }
        ClusterLogger.logRegisteredSingletonService((String)string);
        this.nameToServiceMap.put(string, singletonService);
    }

    public synchronized void addConfiguredService(String string, SingletonService singletonService, InheritableThreadContext inheritableThreadContext) throws IllegalArgumentException {
        this.addConfiguredService(string, singletonService);
        this.nameToContextMap.put(string, inheritableThreadContext);
    }

    public synchronized void add(String string, SingletonService singletonService) throws IllegalArgumentException {
        this.addConfiguredService(string, singletonService);
        this.internalServiceMap.put(string, singletonService);
        if (SingletonServicesBatchManager.theOne() != null && SingletonServicesBatchManager.theOne().hasStarted()) {
            SingletonServicesBatchManager.theOne().startService(string);
        }
    }

    public synchronized void add(String string, SingletonService singletonService, InheritableThreadContext inheritableThreadContext) throws IllegalArgumentException {
        this.add(string, singletonService);
        this.nameToContextMap.put(string, inheritableThreadContext);
    }

    public synchronized void remove(String string) {
        if (DEBUG) {
            this.p("De-registering " + string + " on this server.");
        }
        try {
            this.deactivateService(string);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.nameToServiceMap.remove(string);
        this.nameToContextMap.remove(string);
        ClusterLogger.logUnregisteredSingletonService((String)string);
    }

    public static SingletonService constructSingletonService(String string, ClassLoader classLoader) throws DeploymentException {
        try {
            Class<?> clazz = null;
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            SingletonService singletonService = (SingletonService)constructor.newInstance(new Object[0]);
            return new SingletonServiceWrapper(singletonService);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException("Could not find specified class: " + string, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeploymentException("No permission to construct specified class: " + string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DeploymentException("Could not find constructor for: " + string, noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DeploymentException("Could not construct specified class: " + string, invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new DeploymentException("Could not construct specified class: " + string, instantiationException);
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            if (propertyUpdateArray[i].getAddedObject() instanceof SingletonServiceMBean) {
                this.prepareSingletonBean((SingletonServiceMBean)propertyUpdateArray[i].getAddedObject());
                continue;
            }
            if (!(propertyUpdateArray[i].getRemovedObject() instanceof SingletonServiceMBean)) continue;
            this.checkDeactivateSingletonBean((SingletonServiceMBean)propertyUpdateArray[i].getRemovedObject());
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            if (propertyUpdateArray[i].getAddedObject() instanceof SingletonServiceMBean) {
                this.activateSingletonBean((SingletonServiceMBean)propertyUpdateArray[i].getAddedObject());
                continue;
            }
            if (!(propertyUpdateArray[i].getRemovedObject() instanceof SingletonServiceMBean)) continue;
            this.deactivateSingletonBean((SingletonServiceMBean)propertyUpdateArray[i].getRemovedObject());
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    private void prepareSingletonBean(SingletonServiceMBean singletonServiceMBean) throws BeanUpdateRejectedException {
        SingletonServiceMBean singletonServiceMBean2 = singletonServiceMBean;
        if (singletonServiceMBean2.getCluster() != null && !singletonServiceMBean2.getCluster().getName().equals(this.myCluster.getName())) {
            return;
        }
        if (this.getService(singletonServiceMBean2.getName()) != null) {
            throw new BeanUpdateRejectedException(singletonServiceMBean2.getName() + " has already been deployed.");
        }
        if (DEBUG) {
            this.p("Preparing " + singletonServiceMBean2 + " for deployment on this server.");
        }
        String string = singletonServiceMBean2.getClassName();
        try {
            SingletonService singletonService = SingletonServicesManager.constructSingletonService(string, null);
            this.constructedClassesMap.put(string, singletonService);
        }
        catch (DeploymentException deploymentException) {
            throw new BeanUpdateRejectedException("Error updating bean: " + (Object)((Object)deploymentException), (Throwable)((Object)deploymentException));
        }
    }

    private void activateSingletonBean(SingletonServiceMBean singletonServiceMBean) throws BeanUpdateFailedException {
        if (singletonServiceMBean.getCluster() != null && !singletonServiceMBean.getCluster().getName().equals(this.myCluster.getName())) {
            return;
        }
        if (this.isServiceActive(singletonServiceMBean.getName())) {
            return;
        }
        if (DEBUG) {
            this.p("Activating " + singletonServiceMBean);
        }
        SingletonService singletonService = (SingletonService)this.constructedClassesMap.get(singletonServiceMBean.getClassName());
        try {
            if (singletonServiceMBean.isCandidate(this.myserver)) {
                this.addConfiguredService(singletonServiceMBean.getName(), singletonService);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanUpdateFailedException("Could not activate bean: " + illegalArgumentException, (Throwable)illegalArgumentException);
        }
    }

    private void checkDeactivateSingletonBean(SingletonServiceMBean singletonServiceMBean) {
    }

    private void deactivateSingletonBean(SingletonServiceMBean singletonServiceMBean) {
        if (DEBUG) {
            this.p("Deactivating " + singletonServiceMBean);
        }
        this.remove(singletonServiceMBean.getName());
        if (singletonServiceMBean.getCluster() != null && !singletonServiceMBean.getCluster().getName().equals(this.myCluster.getName())) {
            return;
        }
        this.constructedClassesMap.remove(singletonServiceMBean.getClassName());
    }

    public void addActiveService(String string) {
        SingletonService singletonService = this.getService(string);
        if (singletonService != null && !this.activeServices.contains(string)) {
            this.activeServices.add(string);
            return;
        }
    }

    public void removeActiveService(String string) {
        this.activeServices.remove(string);
    }

    private void p(Object object) {
        SingletonServicesDebugLogger.debug("SingletonServicesManager " + object.toString());
    }

    private void p(Object object, Exception exception) {
        SingletonServicesDebugLogger.debug("SingletonServicesManager " + object.toString(), exception);
    }

    public static abstract class Util {
        private static final String DELIMITER = "#";

        public static String getAppscopedSingletonServiceName(String string, String string2) {
            return string2 == null || string2.length() == 0 ? string : string + DELIMITER + string2;
        }
    }
}

