/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import weblogic.common.ClientCallback;
import weblogic.common.CommonLogger;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.RemoteRequest;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class CallbackDispatcher
implements RemoteInvokable {
    private final ClientCallback callback;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public CallbackDispatcher(ClientCallback clientCallback) {
        this.callback = clientCallback;
    }

    public void invoke(final RemoteRequest remoteRequest) throws RemoteException {
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter(){

            public void run() {
                try {
                    CallbackDispatcher.this.dispatch(remoteRequest);
                }
                catch (Exception exception) {
                    CommonLogger.logCallbackFailed((String)"error during dispatch", (Throwable)exception);
                }
            }
        });
    }

    private void dispatch(RemoteRequest remoteRequest) throws Exception {
        final RemoteRequest remoteRequest2 = remoteRequest;
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)((AuthenticatedSubject)remoteRequest.getSubject()), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public Object run() throws IOException, ClassNotFoundException {
                CallbackDispatcher.this.callback.dispatch(null, remoteRequest2.readObjectWL());
                return null;
            }
        });
    }
}

