/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import weblogic.common.LogServicesDef;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.common.internal.LogMsg;
import weblogic.utils.StackTraceUtils;

final class LogServicesImpl
implements LogServicesDef {
    T3Client t3;

    public LogServicesImpl(T3Client t3Client) {
        this.t3 = t3Client;
    }

    public synchronized void log(String string, Throwable throwable) throws T3Exception {
        this.error(string, throwable);
    }

    public synchronized void log(String string) throws T3Exception {
        this.info(string);
    }

    public synchronized void info(String string) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(0, string));
    }

    public synchronized void info(String string, Throwable throwable) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(0, string, StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
    }

    public synchronized void error(String string, Throwable throwable) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(1, string, StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
    }

    public synchronized void error(Throwable throwable) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(1, null, StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
    }

    public synchronized void error(String string) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(1, string));
    }

    public synchronized void error(String string, String string2) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(1, string, string2));
    }

    public synchronized void warning(String string) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(2, string));
    }

    public synchronized void security(String string) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(3, string));
    }

    public synchronized void debug(String string) throws T3Exception {
        this.t3.sendOneWay("weblogic.common.internal.LogProxyLazy", new LogMsg(4, string));
    }
}

