/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.util.Date;
import weblogic.common.ParamSetException;
import weblogic.common.ParamValue;
import weblogic.common.internal.VectorTable;

public final class ParamSet
implements Cloneable,
Externalizable {
    private VectorTable ht;
    private boolean readonly;
    private boolean verbose = false;
    public boolean trap = false;
    private boolean loose = true;

    public void initialize() {
    }

    public void destroy() {
        this.ht = null;
    }

    public int size() {
        return this.ht.size();
    }

    public int used() {
        return this.ht.used();
    }

    public boolean isEmpty() {
        return this.ht.isEmpty();
    }

    public final void private_setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public final boolean private_isReadonly() {
        return this.readonly;
    }

    public final void private_setLoose(boolean bl) {
        this.loose = bl;
    }

    public final boolean private_isLoose() {
        return this.loose;
    }

    public ParamValue getValue(String string) {
        return this.ht.get(string);
    }

    public ParamValue get(int n) {
        return this.ht.get(n);
    }

    public ParamSet(int n) {
        if (n < 1) {
            n = 1;
        }
        this.ht = new VectorTable(n);
    }

    public ParamSet() {
        this.ht = new VectorTable();
    }

    private ParamSet(ParamSet paramSet) {
        this.ht = (VectorTable)paramSet.ht.clone();
        this.readonly = paramSet.readonly;
        this.verbose = paramSet.verbose;
        this.trap = paramSet.trap;
    }

    public ParamValue declareParam(String string, int n, String string2) throws ParamSetException {
        ParamValue paramValue = new ParamValue(string, n, 42, string2);
        return this.ht.put(paramValue);
    }

    public ParamValue declareParam(String string, int n) throws ParamSetException {
        return this.declareParam(string, n, "");
    }

    public ParamValue getParam(String string) throws ParamSetException {
        ParamValue paramValue = this.getValue(string);
        if (paramValue == null) {
            if (this.loose) {
                paramValue = this.declareParam(string, 43, "");
            } else {
                throw new ParamSetException("No such parameter: " + string);
            }
        }
        return paramValue;
    }

    public ParamValue getParam(String string, int n) throws ParamSetException {
        return this.getParam(string).elementAt(n);
    }

    public void setParams(ParamSet paramSet) throws ParamSetException {
        ParamValue paramValue = null;
        for (int i = 0; i < paramSet.size(); ++i) {
            paramValue = paramSet.get(i);
            if (paramValue == null) continue;
            this.setParam(paramValue.name(), paramValue);
        }
    }

    public void setParam(String string, String string2, ParamSet paramSet) throws ParamSetException {
        ParamValue paramValue = null;
        int n = 0;
        for (int i = 0; i < paramSet.size(); ++i) {
            paramValue = paramSet.get(i);
            if (paramValue == null) continue;
            this.setParam(string, n, paramValue.name());
            this.setParam(string2, n, paramValue);
            ++n;
        }
    }

    public ParamValue setParam(String string, ParamValue paramValue) throws ParamSetException {
        return this.getParam(string).set(paramValue);
    }

    public ParamValue setParam(String string, double d) throws ParamSetException {
        return this.getParam(string).set(d);
    }

    public ParamValue setParam(String string, float f) throws ParamSetException {
        return this.getParam(string).set(f);
    }

    public ParamValue setParam(String string, long l) throws ParamSetException {
        return this.getParam(string).set(l);
    }

    public ParamValue setParam(String string, int n) throws ParamSetException {
        return this.getParam(string).set(n);
    }

    public ParamValue setParam(String string, short s) throws ParamSetException {
        return this.getParam(string).set(s);
    }

    public ParamValue setParam(String string, byte by) throws ParamSetException {
        return this.getParam(string).set(by);
    }

    public ParamValue setParam(String string, boolean bl) throws ParamSetException {
        return this.getParam(string).set(bl);
    }

    public ParamValue setParam(String string, char c) throws ParamSetException {
        return this.getParam(string).set(c);
    }

    public ParamValue setParam(String string, String string2) throws ParamSetException {
        return this.getParam(string).set(string2);
    }

    public ParamValue setParam(String string, Date date) throws ParamSetException {
        return this.getParam(string).set(date);
    }

    public ParamValue setParam(String string, Object object) throws ParamSetException {
        return this.getParam(string).set(object);
    }

    public ParamValue setParam(String string, int n, ParamValue paramValue) throws ParamSetException {
        return this.getParam(string).set(paramValue, n);
    }

    public ParamValue setParam(String string, int n, double d) throws ParamSetException {
        return this.getParam(string).set(d, n);
    }

    public ParamValue setParam(String string, int n, float f) throws ParamSetException {
        return this.getParam(string).set(f, n);
    }

    public ParamValue setParam(String string, int n, long l) throws ParamSetException {
        return this.getParam(string).set(l, n);
    }

    public ParamValue setParam(String string, int n, int n2) throws ParamSetException {
        return this.getParam(string).set(n2, n);
    }

    public ParamValue setParam(String string, int n, short s) throws ParamSetException {
        return this.getParam(string).set(s, n);
    }

    public ParamValue setParam(String string, byte by, int n) throws ParamSetException {
        return this.getParam(string).set(n, (int)by);
    }

    public ParamValue setParam(String string, int n, boolean bl) throws ParamSetException {
        return this.getParam(string).set(bl, n);
    }

    public ParamValue setParam(String string, int n, char c) throws ParamSetException {
        return this.getParam(string).set(c, n);
    }

    public ParamValue setParam(String string, int n, String string2) throws ParamSetException {
        return this.getParam(string).set(string2, n);
    }

    public ParamValue setParam(String string, int n, Date date) throws ParamSetException {
        return this.getParam(string).set(date, n);
    }

    public ParamValue setParam(String string, int n, Object object) throws ParamSetException {
        return this.getParam(string).set(object, n);
    }

    private void remove(String string) throws ParamSetException {
        if (this.ht.get(string) == null) {
            throw new ParamSetException("Cannot remove non-existent item: " + string + " .");
        }
        this.ht.remove(string);
    }

    private void clear() throws ParamSetException {
        if (this.private_isReadonly()) {
            throw new ParamSetException("ParamSet is read only.");
        }
        this.ht.clear();
    }

    public Object clone() {
        return new ParamSet(this);
    }

    public String toString() {
        return this.display();
    }

    public String dump() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            ParamValue paramValue = this.get(i);
            if (paramValue == null) continue;
            string = string + "\n" + paramValue.dump();
        }
        return string;
    }

    public String display() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            ParamValue paramValue = this.get(i);
            if (paramValue == null) continue;
            string = string + paramValue.name() + " = " + paramValue + "\n";
        }
        return string;
    }

    public void print(PrintStream printStream) {
        printStream.println(this.display());
    }

    public String[] getNames() throws ParamSetException {
        String[] stringArray = new String[this.used()];
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            ParamValue paramValue = this.get(i);
            if (paramValue == null) continue;
            stringArray[n++] = paramValue.name();
        }
        return stringArray;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (this.verbose) {
            System.out.println("PS: readcount: " + n);
        }
        this.ht = new VectorTable(n + 1);
        for (int i = 0; i < n; ++i) {
            ParamValue paramValue = new ParamValue();
            paramValue.readExternal(objectInput);
            try {
                this.setParam(paramValue.name(), paramValue);
                continue;
            }
            catch (ParamSetException paramSetException) {
                throw new IOException("" + paramSetException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.used();
        if (this.verbose) {
            System.out.println("PS: write count/size: " + n + "/" + this.size());
        }
        objectOutput.writeInt(n);
        try {
            int n2 = 0;
            for (int i = 0; i < this.size() && n2 < n; ++i) {
                ParamValue paramValue = this.get(i);
                if (this.verbose) {
                    System.out.print("PS #" + i + ": writing:");
                }
                if (paramValue != null) {
                    if (this.verbose) {
                        System.out.println(paramValue.toString());
                    }
                    paramValue.writeExternal(objectOutput);
                    ++n2;
                    continue;
                }
                if (!this.verbose) continue;
                System.out.println("null");
            }
        }
        finally {
            if (this.verbose) {
                System.out.println("This.size() now " + this.size());
            }
        }
    }
}

