/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.common.ParamSetException;
import weblogic.common.ParamTypes;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;

public final class ParamValue
implements Cloneable,
Externalizable {
    protected String paramName;
    protected String paramDesc;
    protected int paramType;
    protected int paramMode;
    private Object value;
    boolean verbose;
    private Vector valuevect = null;

    public void initialize() {
        this.paramName = null;
        this.paramDesc = null;
        this.paramType = 15;
        this.paramMode = 40;
        this.value = null;
        this.verbose = false;
        this.valuevect = null;
    }

    public void destroy() {
        this.paramName = null;
        this.paramDesc = null;
        this.paramType = 15;
        this.paramMode = 40;
        this.value = null;
        this.verbose = false;
        this.valuevect = null;
    }

    private Object currval(Object object) {
        if (this.verbose) {
            System.out.println(this.paramName + " now set to " + (object == null ? "(null)" : object.toString()));
        }
        this.value = object;
        return this.currval();
    }

    private Object currval() {
        return this.value;
    }

    public ParamValue() {
        this.initialize();
    }

    public ParamValue(String string, int n, int n2, String string2) {
        this.initialize();
        this.paramName = string;
        this.paramType = n;
        this.paramMode = n2;
        this.paramDesc = string2;
    }

    private ParamValue(ParamValue paramValue) {
        this.paramName = paramValue.paramName;
        this.paramDesc = paramValue.paramDesc;
        this.paramType = paramValue.paramType;
        this.paramMode = paramValue.paramMode;
        this.value = paramValue.value;
        this.verbose = paramValue.verbose;
        this.valuevect = paramValue.valuevect;
        if (this.isVector() && this.valuevect != null) {
            this.valuevect = new Vector(paramValue.valuevect.size());
            Enumeration enumeration = this.valuevect.elements();
            while (enumeration.hasMoreElements()) {
                ParamValue paramValue2 = (ParamValue)enumeration.nextElement();
                this.valuevect.addElement(paramValue2.clone());
            }
        }
    }

    public Object clone() {
        return new ParamValue(this);
    }

    private void readValue(WLObjectInput wLObjectInput) throws IOException, ParamSetException {
        Object object = null;
        boolean bl = wLObjectInput.readBoolean();
        if (bl) {
            return;
        }
        switch (this.paramType()) {
            case 51: {
                int n = wLObjectInput.readInt();
                this.valuevect = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    ParamValue paramValue = new ParamValue();
                    paramValue.readExternal((ObjectInput)wLObjectInput);
                    this.set(paramValue, i);
                }
                break;
            }
            case 1: {
                object = new Boolean(wLObjectInput.readBoolean());
                break;
            }
            case 2: {
                object = new Byte(wLObjectInput.readByte());
                break;
            }
            case 3: {
                object = new Integer(wLObjectInput.readInt());
                break;
            }
            case 19: {
                object = new Short(wLObjectInput.readShort());
                break;
            }
            case 4: {
                object = new Long(wLObjectInput.readLong());
                break;
            }
            case 5: {
                object = new Double(wLObjectInput.readDouble());
                break;
            }
            case 6: {
                object = new Float(wLObjectInput.readFloat());
                break;
            }
            case 7: {
                object = wLObjectInput.readString();
                break;
            }
            case 8: {
                object = wLObjectInput.readString();
                break;
            }
            case 9: {
                object = wLObjectInput.readDate();
                break;
            }
            case 16: {
                try {
                    object = wLObjectInput.readObjectWL();
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ParamSetException("Class not found: " + classNotFoundException);
                }
            }
            default: {
                throw new ParamSetException("Internal Error - Unknown Type: " + this.paramType);
            }
        }
        this.currval(object);
        if (this.verbose) {
            System.out.println("Reading " + this.dump());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.paramName = wLObjectInput.readAbbrevString();
        this.paramType = wLObjectInput.readInt();
        try {
            this.readValue(wLObjectInput);
        }
        catch (ParamSetException paramSetException) {
            throw new IOException("" + paramSetException);
        }
    }

    private void writeValue(WLObjectOutput wLObjectOutput) throws IOException, ParamSetException {
        if (this.verbose) {
            System.out.println("PV writing:" + this.dump());
        }
        boolean bl = this.isNull();
        wLObjectOutput.writeBoolean(bl);
        if (bl) {
            return;
        }
        switch (this.paramType()) {
            case 51: {
                int n = this.size();
                wLObjectOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.elementAt(i).writeExternal((ObjectOutput)wLObjectOutput);
                }
                break;
            }
            case 1: {
                wLObjectOutput.writeBoolean(this.asBoolean());
                break;
            }
            case 2: {
                wLObjectOutput.writeByte((int)this.asByte());
                break;
            }
            case 3: {
                wLObjectOutput.writeInt(this.asInt());
                break;
            }
            case 19: {
                wLObjectOutput.writeShort((int)this.asShort());
                break;
            }
            case 4: {
                wLObjectOutput.writeLong(this.asLong());
                break;
            }
            case 5: {
                wLObjectOutput.writeDouble(this.asDouble());
                break;
            }
            case 6: {
                wLObjectOutput.writeFloat(this.asFloat());
                break;
            }
            case 7: {
                wLObjectOutput.writeString(this.asString());
                break;
            }
            case 8: {
                wLObjectOutput.writeString(this.asString());
                break;
            }
            case 9: {
                wLObjectOutput.writeDate(this.asDate());
                break;
            }
            case 16: {
                wLObjectOutput.writeObjectWL(this.asObject());
                break;
            }
            default: {
                throw new ParamSetException("Unknown Type: " + this.paramType() + " for " + this.getClass().getName());
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeAbbrevString(this.name());
        wLObjectOutput.writeInt(this.paramType());
        try {
            this.writeValue(wLObjectOutput);
        }
        catch (ParamSetException paramSetException) {
            throw new IOException("" + paramSetException);
        }
    }

    public String name() {
        return this.paramName;
    }

    public String paramDesc() {
        return this.paramDesc;
    }

    public int paramType() {
        return this.paramType;
    }

    public String paramTypeString() {
        return ParamTypes.toString(this.paramType);
    }

    public String paramModeString() {
        return ParamTypes.toString(this.paramMode);
    }

    public boolean isNull(int n) throws ParamSetException {
        return this.elementAt(n).isNull();
    }

    public boolean isNull() {
        if (this.isVector()) {
            return this.valuevect == null;
        }
        return this.currval() == null;
    }

    public int paramMode() {
        return this.paramMode;
    }

    public boolean isScalar() {
        return this.paramType != 51;
    }

    public boolean isVector() {
        return this.paramType == 51;
    }

    public boolean isInt() {
        return this.paramType == 3;
    }

    public boolean isShort() {
        return this.paramType == 19;
    }

    public boolean isFloat() {
        return this.paramType == 6;
    }

    public boolean isDouble() {
        return this.paramType == 5;
    }

    public boolean isDate() {
        return this.paramType == 9;
    }

    public boolean isString() {
        return this.paramType == 8;
    }

    public boolean isChar() {
        return this.paramType == 7;
    }

    public boolean isBoolean() {
        return this.paramType == 1;
    }

    public boolean isByte() {
        return this.paramType == 2;
    }

    public boolean isLong() {
        return this.paramType == 4;
    }

    public boolean isObject() {
        return this.paramType == 16;
    }

    void paramType(int n) {
        this.paramType = 3;
    }

    void paramType(short s) {
        this.paramType = 19;
    }

    void paramType(float f) {
        this.paramType = 6;
    }

    void paramType(double d) {
        this.paramType = 5;
    }

    void paramType(Date date) {
        this.paramType = 9;
    }

    void paramType(String string) {
        this.paramType = 8;
    }

    void paramType(char c) {
        this.paramType = 7;
    }

    void paramType(boolean bl) {
        this.paramType = 1;
    }

    void paramType(byte by) {
        this.paramType = 2;
    }

    void paramType(long l) {
        this.paramType = 4;
    }

    void paramType(Object object) {
        this.paramType = 16;
    }

    public ParamValue elementAt(int n) throws ParamSetException {
        ParamValue paramValue;
        if (n + 1 > this.size()) {
            this.valuevect.setSize(n + 1);
        }
        if ((paramValue = (ParamValue)this.valuevect.elementAt(n)) == null) {
            paramValue = new ParamValue(this.name() + "[" + n + "]", 43, this.paramMode(), this.paramDesc());
            this.valuevect.setElementAt(paramValue, n);
        }
        if (this.verbose) {
            System.out.println("elementAt: [" + this.dump() + "]" + "\n\tfor item #" + n + "is " + "\n\t[" + paramValue.dump() + "]");
        }
        return paramValue;
    }

    public void setElementAt(Object object, int n) throws ParamSetException {
        ParamValue paramValue = this.elementAt(n);
        paramValue.currval(object);
    }

    public int size() throws ParamSetException {
        if (!this.isVector()) {
            throw new ParamSetException("Cannot get size of a " + this.paramTypeString() + "[" + this.dump() + "]");
        }
        if (this.valuevect == null) {
            this.valuevect = new Vector(0);
        }
        if (this.verbose) {
            System.out.println("Vectorsize of " + this.dump() + " is " + this.valuevect.size());
        }
        return this.valuevect.size();
    }

    public ParamValue set(ParamValue paramValue, int n) throws ParamSetException {
        if (this.verbose) {
            System.out.println("\n-----------\nVthis = (" + this.dump() + ")\nVval  = (" + paramValue.dump() + ")\n");
        }
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(paramValue);
        } else {
            this.currval(this.toObject(paramValue));
        }
        if (this.verbose) {
            System.out.println("Vnow = (" + this.dump() + ")\n----------");
        }
        return this;
    }

    public ParamValue set(boolean bl, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(bl);
        } else {
            this.currval(this.toObject(bl));
        }
        return this;
    }

    public ParamValue set(short s, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(s);
        } else {
            this.currval(this.toObject(s));
        }
        return this;
    }

    public ParamValue set(int n, int n2) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n2).set(n);
        } else {
            this.currval(this.toObject(n));
        }
        return this;
    }

    public ParamValue set(long l, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(l);
        } else {
            this.currval(this.toObject(l));
        }
        return this;
    }

    public ParamValue set(double d, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(d);
        } else {
            this.currval(this.toObject(d));
        }
        return this;
    }

    public ParamValue set(float f, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(f);
        } else {
            this.currval(this.toObject(f));
        }
        return this;
    }

    public ParamValue set(char c, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(c);
        } else {
            this.currval(this.toObject(c));
        }
        return this;
    }

    public ParamValue set(String string, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(string);
        } else {
            this.currval(this.toObject(string));
        }
        return this;
    }

    public ParamValue set(Date date, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(date);
        } else {
            this.currval(this.toObject(date));
        }
        return this;
    }

    public ParamValue set(Object object, int n) throws ParamSetException {
        if (this.paramType() == 43) {
            this.paramType = 51;
        }
        if (this.isVector()) {
            this.elementAt(n).set(object);
        } else {
            this.currval(this.toObject(object));
        }
        return this;
    }

    public ParamValue set(ParamValue paramValue) throws ParamSetException {
        if (this.verbose) {
            System.out.println("\n-----------\nthis = (" + this.dump() + ")\nval  = (" + paramValue.dump() + ")\n");
        }
        if (this.paramType == 43) {
            this.paramType = paramValue.paramType();
            if (this.verbose) {
                System.out.println("Converting unknown   " + this.dump() + " to " + paramValue.dump());
            }
        }
        if (this.isVector()) {
            if (paramValue.isVector()) {
                for (int i = 0; i < paramValue.size(); ++i) {
                    this.elementAt(i).set(paramValue.elementAt(i));
                }
            } else {
                this.set(paramValue, 0);
            }
        } else {
            this.currval(this.toObject(paramValue));
        }
        if (this.verbose) {
            System.out.println("now = (" + this.dump() + ")\n----------");
        }
        return this;
    }

    public ParamValue set(boolean bl) throws ParamSetException {
        if (this.isVector()) {
            this.set(bl, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(bl);
            }
            this.currval(this.toObject(bl));
        }
        return this;
    }

    public ParamValue set(int n) throws ParamSetException {
        if (this.isVector()) {
            this.set(n, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(n);
            }
            this.currval(this.toObject(n));
        }
        return this;
    }

    public ParamValue set(short s) throws ParamSetException {
        if (this.isVector()) {
            this.set(s, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(s);
            }
            this.currval(this.toObject(s));
        }
        return this;
    }

    public ParamValue set(byte by) throws ParamSetException {
        if (this.isVector()) {
            this.set(by, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(by);
            }
            this.currval(this.toObject(by));
        }
        return this;
    }

    public ParamValue set(long l) throws ParamSetException {
        if (this.isVector()) {
            this.set(l, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(l);
            }
            this.currval(this.toObject(l));
        }
        return this;
    }

    public ParamValue set(double d) throws ParamSetException {
        if (this.isVector()) {
            this.set(d, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(d);
            }
            this.currval(this.toObject(d));
        }
        return this;
    }

    public ParamValue set(float f) throws ParamSetException {
        if (this.isVector()) {
            this.set(f, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(f);
            }
            this.currval(this.toObject(f));
        }
        return this;
    }

    public ParamValue set(char c) throws ParamSetException {
        if (this.isVector()) {
            this.set(c, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(c);
            }
            this.currval(this.toObject(c));
        }
        return this;
    }

    public ParamValue set(String string) throws ParamSetException {
        if (this.isVector()) {
            this.set(string, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(string);
            }
            this.currval(this.toObject(string));
        }
        return this;
    }

    public ParamValue set(Date date) throws ParamSetException {
        if (this.isVector()) {
            this.set(date, 0);
        } else {
            if (this.paramType == 43) {
                this.paramType(date);
            }
            this.currval(this.toObject(date));
        }
        return this;
    }

    public ParamValue set(Object object) throws ParamSetException {
        if (this.isVector()) {
            this.set(object, 0);
        } else {
            if (this.paramType == 43 || this.paramType == 15) {
                this.paramType(object);
            }
            this.currval(this.toObject(object));
        }
        return this;
    }

    Object toObject(ParamValue paramValue) throws ParamSetException {
        switch (paramValue.paramType()) {
            case 1: {
                return this.toObject(paramValue.asBoolean());
            }
            case 2: {
                return this.toObject(paramValue.asByte());
            }
            case 3: {
                return this.toObject(paramValue.asInt());
            }
            case 19: {
                return this.toObject(paramValue.asShort());
            }
            case 4: {
                return this.toObject(paramValue.asLong());
            }
            case 5: {
                return this.toObject(paramValue.asDouble());
            }
            case 6: {
                return this.toObject(paramValue.asFloat());
            }
            case 7: {
                return this.toObject(paramValue.asChar());
            }
            case 9: {
                return this.toObject(paramValue.asDate());
            }
            case 16: {
                return this.toObject(paramValue.asObject());
            }
            case 51: {
                return null;
            }
        }
        return this.toObject(paramValue.asString());
    }

    Object toObject(boolean bl) throws ParamSetException {
        switch (this.paramType()) {
            case 1: {
                return new Boolean(bl);
            }
            case 8: {
                return String.valueOf(bl);
            }
        }
        throw new ParamSetException("Unknown Conversion from boolean to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(short s) throws ParamSetException {
        switch (this.paramType()) {
            case 19: {
                return new Short(s);
            }
            case 8: {
                return String.valueOf(s);
            }
        }
        throw new ParamSetException("Unknown Conversion from short to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(int n) throws ParamSetException {
        switch (this.paramType()) {
            case 3: {
                return new Integer(n);
            }
            case 8: {
                return String.valueOf(n);
            }
            case 4: {
                return new Long(n);
            }
            case 5: {
                return new Double(n);
            }
            case 6: {
                return new Float(n);
            }
        }
        throw new ParamSetException("Unknown Conversion from int to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(byte by) throws ParamSetException {
        switch (this.paramType()) {
            case 2: {
                return new Integer(by);
            }
            case 3: {
                return new Integer(by);
            }
            case 8: {
                return String.valueOf(by);
            }
            case 4: {
                return new Long(by);
            }
            case 5: {
                return new Double(by);
            }
            case 6: {
                return new Float(by);
            }
        }
        throw new ParamSetException("Unknown Conversion from byte to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(long l) throws ParamSetException {
        switch (this.paramType()) {
            case 4: {
                return new Long(l);
            }
            case 8: {
                return String.valueOf(l);
            }
            case 5: {
                return new Double(l);
            }
            case 6: {
                return new Float(l);
            }
        }
        throw new ParamSetException("Unknown Conversion from long to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(double d) throws ParamSetException {
        switch (this.paramType()) {
            case 5: {
                return new Double(d);
            }
            case 8: {
                return String.valueOf(d);
            }
        }
        throw new ParamSetException("Unknown Conversion from double to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(float f) throws ParamSetException {
        switch (this.paramType()) {
            case 6: {
                return new Float(f);
            }
            case 8: {
                return String.valueOf(f);
            }
            case 5: {
                return new Double(f);
            }
        }
        throw new ParamSetException("Unknown Conversion from float to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(char c) throws ParamSetException {
        switch (this.paramType()) {
            case 8: {
                return String.valueOf(c);
            }
            case 7: {
                return String.valueOf(c);
            }
        }
        throw new ParamSetException("Unknown Conversion from char to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(String string) throws ParamSetException {
        try {
            if (string == null) {
                return null;
            }
            switch (this.paramType()) {
                case 8: {
                    return string;
                }
                case 1: {
                    return new Boolean(string);
                }
                case 2: {
                    return new Byte(string);
                }
                case 3: {
                    return new Integer(string);
                }
                case 19: {
                    return new Short(string);
                }
                case 4: {
                    return new Long(string);
                }
                case 5: {
                    return new Double(string);
                }
                case 6: {
                    return new Float(string);
                }
                case 7: {
                    return string.substring(0, 1);
                }
                case 9: {
                    return new Date(string);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParamSetException("[" + numberFormatException + "] to type " + this.paramTypeString());
        }
        throw new ParamSetException("Unknown Conversion from String to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(Date date) throws ParamSetException {
        if (date == null) {
            return null;
        }
        switch (this.paramType()) {
            case 9: {
                return date;
            }
            case 8: {
                return date.toString();
            }
        }
        throw new ParamSetException("Unknown Conversion from Date to " + this.paramTypeString() + " for " + this.dump());
    }

    Object toObject(Object object) throws ParamSetException {
        if (object == null) {
            return null;
        }
        switch (this.paramType()) {
            case 16: {
                return object;
            }
            case 8: {
                return object.toString();
            }
        }
        throw new ParamSetException("Unknown Conversion from Object to " + this.paramTypeString() + " for " + this.dump());
    }

    ParamSetException convertFromExc(String string) {
        return new ParamSetException("Unknown conversion from " + this.currval().getClass().getName() + " to " + string + " for " + this.dump());
    }

    public boolean asBoolean() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asBoolean();
        }
        if (this.isNull()) {
            return false;
        }
        if (this.currval() instanceof Boolean) {
            return (Boolean)this.currval();
        }
        if (this.currval() instanceof String) {
            return Boolean.valueOf((String)this.currval());
        }
        throw this.convertFromExc("boolean");
    }

    public byte asByte() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asByte();
        }
        if (this.isNull()) {
            return 0;
        }
        if (this.currval() instanceof Number) {
            return (byte)((Number)this.currval()).intValue();
        }
        if (this.currval() instanceof String) {
            return (byte)Integer.valueOf((String)this.currval()).intValue();
        }
        throw this.convertFromExc("byte");
    }

    public int asInt() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asInt();
        }
        if (this.isNull()) {
            return 0;
        }
        if (this.currval() instanceof Number) {
            return ((Number)this.currval()).intValue();
        }
        if (this.currval() instanceof String) {
            return Integer.valueOf((String)this.currval());
        }
        throw this.convertFromExc("int");
    }

    public short asShort() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asShort();
        }
        if (this.isNull()) {
            return 0;
        }
        if (this.currval() instanceof Number) {
            return (short)((Number)this.currval()).intValue();
        }
        if (this.currval() instanceof String) {
            return Short.valueOf((String)this.currval());
        }
        throw this.convertFromExc("short");
    }

    public long asLong() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asLong();
        }
        if (this.isNull()) {
            return 0L;
        }
        if (this.currval() instanceof Number) {
            return ((Number)this.currval()).longValue();
        }
        if (this.currval() instanceof String) {
            return Long.valueOf((String)this.currval());
        }
        throw this.convertFromExc("long");
    }

    public double asDouble() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asDouble();
        }
        if (this.isNull()) {
            return 0.0;
        }
        if (this.currval() instanceof Number) {
            return ((Number)this.currval()).floatValue();
        }
        if (this.currval() instanceof String) {
            return Double.valueOf((String)this.currval());
        }
        throw this.convertFromExc("double");
    }

    public float asFloat() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asFloat();
        }
        if (this.isNull()) {
            return 0.0f;
        }
        if (this.currval() instanceof Number) {
            return ((Number)this.currval()).floatValue();
        }
        if (this.currval() instanceof String) {
            return Float.valueOf((String)this.currval()).floatValue();
        }
        throw this.convertFromExc("float");
    }

    public char asChar() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asChar();
        }
        if (this.isNull()) {
            return ' ';
        }
        if (this.currval() instanceof Character) {
            return ((Character)this.currval()).charValue();
        }
        if (this.currval() instanceof String) {
            String string = (String)this.currval();
            if (string.length() == 1) {
                return string.charAt(0);
            }
            if (string.length() == 0) {
                return ' ';
            }
        }
        throw this.convertFromExc("char");
    }

    public String asString() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asString();
        }
        if (this.isNull()) {
            return "";
        }
        return this.currval().toString();
    }

    public String toString() {
        try {
            if (this.isVector()) {
                return this.valuevect.toString();
            }
            return this.currval().toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String dump() {
        return "" + this.name() + "/" + this.paramTypeString() + "/" + this.paramModeString() + "/" + this.paramDesc() + "/" + (this.currval() != null ? this.currval().toString() : (this.valuevect != null ? this.valuevect.toString() : ""));
    }

    public Date asDate() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asDate();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.currval() instanceof Date) {
            return (Date)this.currval();
        }
        if (this.currval() instanceof String) {
            return new Date((String)this.currval());
        }
        throw this.convertFromExc("Date");
    }

    public Object asObject() throws ParamSetException {
        if (this.isVector()) {
            return this.elementAt(0).asObject();
        }
        if (this.isNull()) {
            return null;
        }
        return this.currval();
    }
}

