/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.common.CallbackDispatcher;
import weblogic.common.ClientCallback;
import weblogic.common.DisconnectEvent;
import weblogic.common.DisconnectListener;
import weblogic.common.T3ClientServices;
import weblogic.common.T3Connection;
import weblogic.common.T3Exception;
import weblogic.common.T3ExecuteException;
import weblogic.common.T3ServicesDef;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.BootServicesStub;
import weblogic.common.internal.T3ClientParams;
import weblogic.kernel.Kernel;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.Response;
import weblogic.rjvm.ServerURL;
import weblogic.rmi.ConnectIOException;
import weblogic.rmi.MarshalException;
import weblogic.rmi.UnmarshalException;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.utils.Utilities;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.AssertionError;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.URLClassFinder;

public final class T3Client
implements PeerGoneListener,
ClientCallback {
    public static final int DISCONNECT_TIMEOUT_DEFAULT = -2;
    public static final int DISCONNECT_TIMEOUT_NEVER = -1;
    private T3Connection connection;
    private RJVM rjvm;
    private T3ClientParams cm;
    private int idleCallbackID;
    private Thread loginThread = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public T3ServicesDef services;
    private String workspace;
    private Vector disconnectListeners = new Vector();
    private boolean disconnectEventSent = false;
    public static final int INVALID_CALLBACK_ID = -1;
    private ClassLoader loader;

    public T3ServicesDef getT3Services() {
        return this.services;
    }

    public RJVM private_getRJVM() {
        return this.rjvm;
    }

    public boolean isConnected() {
        return this.cm != null;
    }

    public T3Connection getT3Connection() {
        return this.connection;
    }

    public boolean timeTraceEnabled() {
        return false;
    }

    public boolean timeTraceEnable(PrintStream printStream) {
        return false;
    }

    public T3Client(T3Connection t3Connection, String string) {
        Kernel.ensureInitialized();
        this.connection = t3Connection;
        this.workspace = string;
        this.services = new T3ClientServices(this);
    }

    public T3Client(T3Connection t3Connection) {
        this(t3Connection, null);
    }

    public T3Client(String string, String string2, UserInfo userInfo) throws UnknownHostException, T3Exception, IOException {
        this(new T3Connection(string, userInfo), string2);
    }

    public T3Client(String string, String string2) throws UnknownHostException, T3Exception, IOException {
        this(string, string2, null);
    }

    public T3Client(String string) throws UnknownHostException, T3Exception, IOException {
        this(string, null, null);
    }

    public T3Client(String string, UserInfo userInfo) throws UnknownHostException, T3Exception, IOException {
        this(string, null, userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T3Client connect() throws IOException, T3Exception, T3ExecuteException, SecurityException {
        if (this.connection == null) {
            throw new T3Exception("Improperly initalized.");
        }
        Protocol protocol = ProtocolManager.getProtocolByName((String)this.connection.getProtocol());
        if (protocol.isUnknown()) {
            throw new MalformedURLException("Unknown protocol: '" + this.connection.getProtocol() + "'");
        }
        this.rjvm = new ServerURL(this.connection.getURL()).findOrCreateRJVM();
        this.rjvm.addPeerGoneListener((PeerGoneListener)this);
        this.idleCallbackID = this.registerCallback(this);
        this.cm = null;
        try {
            BootServicesStub bootServicesStub = new BootServicesStub(this.rjvm, protocol);
            this.cm = bootServicesStub.findOrCreateClientContext(this.workspace, this.connection.getUser(), this.idleCallbackID);
            if (this.connection.getUser() instanceof AuthenticatedUser && SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)SecurityServiceManager.getASFromAU((AuthenticatedUser)((AuthenticatedUser)this.connection.getUser())))) {
                this.cm.user = (AuthenticatedUser)this.connection.getUser();
            }
            this.loginThread = Thread.currentThread();
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getASFromAU((AuthenticatedUser)this.cm.user);
            SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject);
        }
        finally {
            if (this.cm == null) {
                this.shutdown(true);
            }
        }
        if (this.cm == null) {
            throw new T3Exception("Error attempting to initialize.");
        }
        if (this.cm.verbose) {
            System.out.println("New WSID: " + this.cm.wsID);
            System.out.println("Connected as user=" + this.cm.user);
        }
        return this;
    }

    public void addDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListeners.addElement(disconnectListener);
    }

    public void removeDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListeners.removeElement(disconnectListener);
    }

    private synchronized void disconnectOccurred(DisconnectEvent disconnectEvent) {
        if (!this.disconnectEventSent) {
            this.disconnectEventSent = true;
            Enumeration enumeration = this.disconnectListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((DisconnectListener)enumeration.nextElement()).disconnectOccurred(disconnectEvent);
            }
        }
    }

    private void shutdown(boolean bl) {
        this.cm = null;
        if (bl && this.rjvm != null) {
            this.rjvm.removePeerGoneListener((PeerGoneListener)this);
        }
        this.unregisterCallback(this.idleCallbackID);
        this.rjvm = null;
    }

    public synchronized T3Client disconnect() throws IOException, T3Exception {
        if (!this.isConnected()) {
            System.out.println("Ignoring request to disconnect client that is already disconnected.");
            return this;
        }
        this.sendOneWay("XZZdisconnectZZX", null);
        this.shutdown(true);
        this.disconnectOccurred(new DisconnectEvent(this, "clean disconnect"));
        if (Thread.currentThread() != this.loginThread) {
            System.out.println("Warning: T3Client.disconnect() called in a different thread than the one connect was called in");
            return this;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
        return this;
    }

    public void peerGone(PeerGoneEvent peerGoneEvent) {
        this.shutdown(false);
        this.disconnectOccurred(new DisconnectEvent(this, "connection to peer went down"));
    }

    public void dispatch(Throwable throwable, Object object) {
        this.shutdown(true);
        this.disconnectOccurred(new DisconnectEvent(this, "idle time out from Server"));
    }

    public int getHardDisconnectTimeoutMins() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.cm.hardDisconnectTimeoutMins;
    }

    public synchronized T3Client setHardDisconnectTimeoutMins(int n) throws weblogic.rmi.RemoteException, T3Exception {
        if (!this.isConnected()) {
            throw new T3Exception("T3Client not connected");
        }
        if (n < -2) {
            throw new T3Exception("Invalid timeout value: " + n);
        }
        this.cm.rcc.setHardDisconnectTimeoutMins(n);
        this.cm.hardDisconnectTimeoutMins = n;
        return this;
    }

    public int getSoftDisconnectTimeoutMins() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.cm.softDisconnectTimeoutMins;
    }

    public synchronized T3Client setSoftDisconnectTimeoutMins(int n) throws weblogic.rmi.RemoteException, T3Exception {
        if (!this.isConnected()) {
            throw new T3Exception("T3Client not connected");
        }
        if (n < -2) {
            throw new T3Exception("Invalid timeout value: " + n);
        }
        this.cm.rcc.setSoftDisconnectTimeoutMins(n);
        this.cm.softDisconnectTimeoutMins = n;
        return this;
    }

    public int getIdleDisconnectTimeoutMins() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.cm.idleSoftDisconnectTimeoutMins;
    }

    public synchronized T3Client setIdleDisconnectTimeoutMins(int n) throws weblogic.rmi.RemoteException, T3Exception {
        if (!this.isConnected()) {
            throw new T3Exception("T3Client not connected");
        }
        if (n < -2) {
            throw new T3Exception("Invalid timeout value: " + n);
        }
        this.cm.rcc.setIdleDisconnectTimeoutMins(n);
        this.cm.idleSoftDisconnectTimeoutMins = n;
        return this;
    }

    public String getServerName() {
        if (!this.isConnected()) {
            return "";
        }
        return this.cm.serverName;
    }

    public boolean getVerbose() {
        if (!this.isConnected()) {
            return false;
        }
        return this.cm.verbose;
    }

    public synchronized T3Client setVerbose(boolean bl) throws weblogic.rmi.RemoteException {
        if (!this.isConnected()) {
            throw new ConnectIOException("T3Client not connected");
        }
        this.cm.rcc.setVerbose(bl);
        this.cm.verbose = bl;
        return this;
    }

    public String toString() {
        return super.toString() + " - connection: '" + this.getT3Connection() + "', wsid: '" + (this.cm != null ? this.cm.wsID : "unconnected") + "'";
    }

    public void sendOneWay(String string, Object object) throws weblogic.rmi.RemoteException {
        if (this.rjvm == null) {
            throw new ConnectIOException("T3Client not connected");
        }
        MsgAbbrevOutputStream msgAbbrevOutputStream = null;
        try {
            msgAbbrevOutputStream = this.rjvm.getRequestStream(null);
            msgAbbrevOutputStream.writeAbbrevString(string);
            msgAbbrevOutputStream.writeObjectWL(object);
        }
        catch (IOException iOException) {
            throw new MarshalException("Failed to marshal arguments", (Throwable)iOException);
        }
        try {
            msgAbbrevOutputStream.sendOneWay(this.cm.ccID);
        }
        catch (RemoteException remoteException) {
            throw (weblogic.rmi.RemoteException)Utilities.theOtherException((RemoteException)remoteException);
        }
    }

    public Response sendRecvAsync(String string, Object object) throws weblogic.rmi.RemoteException {
        if (this.rjvm == null) {
            throw new ConnectIOException("T3Client not connected");
        }
        MsgAbbrevOutputStream msgAbbrevOutputStream = null;
        try {
            msgAbbrevOutputStream = this.rjvm.getRequestStream(null);
            msgAbbrevOutputStream.writeAbbrevString(string);
            msgAbbrevOutputStream.writeObjectWL(object);
        }
        catch (IOException iOException) {
            throw new MarshalException("Failed to marshal arguments", (Throwable)iOException);
        }
        try {
            return msgAbbrevOutputStream.sendRecv(this.cm.ccID);
        }
        catch (RemoteException remoteException) {
            throw (weblogic.rmi.RemoteException)Utilities.theOtherException((RemoteException)remoteException);
        }
    }

    public Object sendRecv(String string, Object object) throws T3Exception {
        Response response = this.sendRecvAsync(string, object);
        Throwable throwable = response.getThrowable();
        if (throwable != null) {
            if (throwable instanceof weblogic.rmi.RemoteException) {
                throw (weblogic.rmi.RemoteException)throwable;
            }
            if (throwable instanceof T3Exception) {
                throw (T3Exception)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof Exception) {
                throw new T3Exception("Exception in sendRecv", throwable);
            }
        }
        WLObjectInput wLObjectInput = null;
        try {
            wLObjectInput = response.getMsg();
            Object object2 = wLObjectInput.readObjectWL();
            return object2;
        }
        catch (IOException iOException) {
            throw new UnmarshalException("reading payload failed: ", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("reading payload failed: ", (Throwable)classNotFoundException);
        }
        finally {
            if (wLObjectInput != null) {
                try {
                    wLObjectInput.close();
                }
                catch (IOException iOException) {
                    throw new AssertionError((Throwable)iOException);
                }
            }
        }
    }

    private int registerCallback(ClientCallback clientCallback) {
        if (this.rjvm == null) {
            return -1;
        }
        CallbackDispatcher callbackDispatcher = new CallbackDispatcher(clientCallback);
        int n = System.identityHashCode(callbackDispatcher);
        RJVMManager.getLocalRJVM().getFinder().put(n, (RemoteInvokable)callbackDispatcher);
        return n;
    }

    private void unregisterCallback(int n) {
        RJVMManager.getLocalRJVM().getFinder().remove(n);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.rjvm == null) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Connection failure while trying to load class: '" + string + "'");
            }
        }
        if (this.loader == null) {
            String string2 = ChannelHelper.createCodebaseURL((Channel)this.rjvm.getID());
            URLClassFinder uRLClassFinder = new URLClassFinder(string2);
            this.loader = new GenericClassLoader((ClassFinder)uRLClassFinder);
        }
        return this.loader.loadClass(string);
    }
}

