/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import weblogic.common.T3Exception;
import weblogic.common.T3User;
import weblogic.rjvm.ServerURL;
import weblogic.security.acl.UserInfo;
import weblogic.utils.http.HttpParsing;

public final class T3Connection {
    private String protocol;
    private String host;
    private int port;
    private String path;
    private Hashtable queryParams;
    private UserInfo user;
    private String url;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public String getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public Hashtable getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParam(String string) {
        return this.getQueryParams() == null ? null : (String)this.getQueryParams().get(string);
    }

    public T3Connection(String string) throws UnknownHostException, MalformedURLException {
        this(string, T3User.GUEST);
    }

    public T3Connection(String string, UserInfo userInfo) throws UnknownHostException, MalformedURLException {
        this.url = string;
        this.user = userInfo;
        if (this.user == null) {
            this.user = T3User.GUEST;
        }
        ServerURL serverURL = new ServerURL(string);
        this.protocol = serverURL.getProtocol();
        this.host = serverURL.getHost();
        this.port = serverURL.getPort();
        this.path = serverURL.getFile();
        if (serverURL.getQuery().length() == 0) {
            return;
        }
        this.queryParams = new Hashtable();
        HttpParsing.parseQueryString((String)serverURL.getQuery().replace('?', '&'), (Map)this.queryParams);
    }

    public boolean isConnected() {
        return true;
    }

    public T3Connection connect() throws IOException, T3Exception {
        return this;
    }

    public void disconnect() throws IOException, T3Exception {
    }

    public String toString() {
        return "[T3Connection host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", hashCode=" + this.hashCode() + "]";
    }
}

