/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;

public final class AdminMsg
implements Serializable {
    private static final long serialVersionUID = -6671831720088467261L;
    public static final String PROXYCLASS = "weblogic.common.internal.AdminProxy";
    public static final int PROXYCLASSNUM = 1;
    public static final byte CMD_NONE = 0;
    public static final byte CMD_ECHO = 1;
    public static final byte CMD_SHUT = 2;
    public static final byte CMD_VERSION = 5;
    public static final byte CMD_WD_ENABLE = 6;
    public static final byte CMD_WD_DISABLE = 7;
    public static final byte CMD_CONPOOL_RESET = 8;
    public static final byte CMD_IS_PRIVILEDGED_USER = 9;
    public static final byte CMD_LOCK = 10;
    public static final byte CMD_UNLOCK = 11;
    public static final byte CMD_CANCEL_SHUT = 12;
    public static final byte CMD_THREAD_DUMP = 13;
    private static boolean verbose = false;
    protected byte cmd;
    protected int intervalSecs;
    protected String argString;
    protected byte[] echo;

    public String toString() {
        return "AdminMsg " + AdminMsg.getCmdVerb(this.cmd());
    }

    private static String getCmdVerb(byte by) {
        switch (by) {
            case 0: {
                return "CMD_NONE";
            }
            case 1: {
                return "CMD_ECHO";
            }
            case 2: {
                return "CMD_SHUT";
            }
            case 5: {
                return "CMD_VERSION";
            }
            case 6: {
                return "CMD_WD_ENABLE";
            }
            case 7: {
                return "CMD_WD_DISABLE";
            }
            case 8: {
                return "CMD_CONPOOL_RESET";
            }
            case 9: {
                return "CMD_IS_PRIVILEDGED_USER";
            }
            case 10: {
                return "CMD_LOCK";
            }
            case 11: {
                return "CMD_UNLOCK";
            }
            case 12: {
                return "CMD_CANCEL_SHUT";
            }
            case 13: {
                return "CMD_THREAD_DUMP";
            }
        }
        return new Integer(by).toString();
    }

    public byte cmd() {
        return this.cmd;
    }

    public int intervalSecs() {
        return this.intervalSecs;
    }

    public String argString() {
        return this.argString;
    }

    public byte[] echo() {
        return this.echo;
    }

    public void destroy() {
        this.cmd = 0;
        this.echo = null;
    }

    public void initialize() {
        this.cmd = 0;
        this.echo = null;
    }

    public AdminMsg() {
    }

    public AdminMsg(byte by) {
        this.cmd = by;
    }

    public AdminMsg setEcho(byte[] byArray) {
        this.echo = byArray;
        return this;
    }

    public AdminMsg setIntervalSecs(int n) {
        this.intervalSecs = n;
        return this;
    }

    public AdminMsg setArgString(String string) {
        this.argString = string;
        return this;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            AdminMsg adminMsg = (AdminMsg)object;
            return this.cmd == adminMsg.cmd && this.intervalSecs == adminMsg.intervalSecs && (this.echo == null && adminMsg.echo == null || this.echo.equals(adminMsg.echo)) && (this.argString == null && adminMsg.argString == null || this.argString.equals(adminMsg.argString));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int hashCode() {
        return this.cmd << 24 | this.intervalSecs | (this.echo == null ? 0 : this.echo.hashCode()) | (this.argString == null ? 0 : this.argString.hashCode());
    }
}

