/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.security.AccessController;
import javax.security.auth.Subject;
import weblogic.common.CommonTextTextFormatter;
import weblogic.common.T3Exception;
import weblogic.common.T3Executable;
import weblogic.common.internal.AdminMsg;
import weblogic.common.internal.AdminProxyWatchDog;
import weblogic.management.provider.ManagementService;
import weblogic.platform.VM;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServerLifecycleException;
import weblogic.t3.srvr.ExecutionContext;
import weblogic.t3.srvr.T3Srvr;
import weblogic.version;

public final class AdminProxy
implements T3Executable {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void initialize() {
    }

    public void destroy() {
    }

    public Object execute(ExecutionContext executionContext, Object object) throws Exception {
        AdminMsg adminMsg = (AdminMsg)object;
        switch (adminMsg.cmd) {
            case 1: {
                AdminProxyWatchDog adminProxyWatchDog = (AdminProxyWatchDog)executionContext.get("WEBLOGIC.WATCHDOG");
                if (adminProxyWatchDog != null) {
                    adminProxyWatchDog.echoReceived();
                }
                return "It's alive!";
            }
            case 2: {
                AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                if (!SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) && !SubjectUtils.isUserInGroup((Subject)authenticatedSubject.getSubject(), (String)"Operators")) {
                    throw new SecurityException("User is not an administrator");
                }
                if (adminMsg.intervalSecs() >= 0) {
                    T3Srvr.getT3Srvr().setShutdownWaitSecs(adminMsg.intervalSecs());
                }
                try {
                    ManagementService.getRuntimeAccess(kernelId).getServerRuntime().shutdown();
                }
                catch (ServerLifecycleException serverLifecycleException) {
                    throw new ServerLifecycleException(serverLifecycleException);
                }
                CommonTextTextFormatter commonTextTextFormatter = new CommonTextTextFormatter();
                return commonTextTextFormatter.getServerShutdownSuccessfully(ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getName());
            }
            case 12: {
                return T3Srvr.getT3Srvr().cancelShutdown();
            }
            case 5: {
                return version.getVersions();
            }
            case 7: {
                AdminProxyWatchDog adminProxyWatchDog = (AdminProxyWatchDog)executionContext.remove("WEBLOGIC.WATCHDOG");
                if (adminProxyWatchDog != null) {
                    adminProxyWatchDog.disable();
                }
                return null;
            }
            case 6: {
                AdminProxyWatchDog adminProxyWatchDog = (AdminProxyWatchDog)executionContext.get("WEBLOGIC.WATCHDOG");
                if (adminProxyWatchDog == null) {
                    adminProxyWatchDog = new AdminProxyWatchDog(SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId), adminMsg.intervalSecs);
                    adminProxyWatchDog.initialize();
                    executionContext.put("WEBLOGIC.WATCHDOG", adminProxyWatchDog);
                }
                return null;
            }
            case 9: {
                AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
                    return null;
                }
                throw new SecurityException("Invalid password for system administrator.");
            }
            case 10: {
                return T3Srvr.getT3Srvr().getLockoutManager().lockServer(adminMsg.argString());
            }
            case 11: {
                return T3Srvr.getT3Srvr().getLockoutManager().unlockServer();
            }
            case 13: {
                this.checkThreadDumpPrivileges();
                VM.getVM().threadDump();
                return null;
            }
        }
        throw new T3Exception("Unknown AdminMsg Command: " + adminMsg.cmd);
    }

    private void checkThreadDumpPrivileges() throws SecurityException {
        if (ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled()) {
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            if (SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)authenticatedSubject)) {
                return;
            }
            throw new SecurityException("User: '" + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + "' does not have permission to take thread dumps. " + "Only Admin role users are permitted to take thread dumps in " + "production mode servers");
        }
    }
}

