/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.security.AccessController;
import weblogic.common.CommonLogger;
import weblogic.common.internal.Manufacturable;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;

class AdminProxyWatchDog
implements TimerListener,
Manufacturable {
    Timer timeRegistration;
    AuthenticatedSubject subject;
    int intervalSecs;
    long lastEcho = TimeEventGenerator.getCurrentSecs();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    AdminProxyWatchDog(AuthenticatedSubject authenticatedSubject, int n) {
        this.intervalSecs = n;
        this.subject = authenticatedSubject;
    }

    public void initialize() {
        this.timeRegistration = TimerManagerFactory.getTimerManagerFactory().getTimerManager("AdminProxyWatchDog").scheduleAtFixedRate((TimerListener)this, 0L, (long)(this.intervalSecs * 1000));
        CommonLogger.logEnabled((long)this.intervalSecs);
    }

    void disable() {
        if (this.timeRegistration != null) {
            this.timeRegistration.cancel();
            this.timeRegistration = null;
        }
        CommonLogger.logDisabled();
    }

    public void destroy() {
        if (this.timeRegistration != null) {
            CommonLogger.logLost();
            this.disable();
            try {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().forceShutdown();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                CommonLogger.logErrorWhileServerShutdown((Throwable)serverLifecycleException);
            }
            this.subject = null;
        }
    }

    public void timerExpired(Timer timer) {
        int n = TimeEventGenerator.deltaSecs(this.lastEcho);
        CommonLogger.logTick((int)n);
        if (n > this.intervalSecs) {
            CommonLogger.logNoEcho((int)n);
            try {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().forceShutdown();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                CommonLogger.logErrorWhileServerShutdown((Throwable)serverLifecycleException);
            }
        }
    }

    public void echoReceived() {
        CommonLogger.logEcho();
        this.lastEcho = TimeEventGenerator.getCurrentSecs();
    }
}

