/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import weblogic.common.CommonLogger;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.BootServices;
import weblogic.common.internal.T3ClientParams;
import weblogic.protocol.Protocol;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.Response;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedUser;

public class BootServicesStub
implements BootServices {
    private static int ID = 1;
    private RJVM rjvm;
    private Protocol protocol;

    public static WLObjectInput getMsg(Response response) throws RemoteException {
        Throwable throwable = response.getThrowable();
        if (throwable == null) {
            return response.getMsg();
        }
        if (throwable instanceof RemoteException) {
            throw (RemoteException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        CommonLogger.logUnexpectedProblem((Throwable)throwable);
        throw new ClassCastException("Expected RemoteException, RuntimeException, or Error but received: '" + throwable.toString() + "'");
    }

    public BootServicesStub(RJVM rJVM, Protocol protocol) {
        this.rjvm = rJVM;
        this.protocol = protocol;
    }

    public AuthenticatedUser authenticate(UserInfo userInfo) throws RemoteException {
        MsgAbbrevOutputStream msgAbbrevOutputStream = null;
        try {
            msgAbbrevOutputStream = this.rjvm.getRequestStreamForDefaultUser(this.protocol);
            msgAbbrevOutputStream.marshalCustomCallData();
            msgAbbrevOutputStream.writeByte(1);
            msgAbbrevOutputStream.writeObject((Object)userInfo);
            return (AuthenticatedUser)BootServicesStub.getMsg(msgAbbrevOutputStream.sendRecv(ID, this.protocol.getQOS())).readObject();
        }
        catch (IOException iOException) {
            throw new UnexpectedException("Marshalling: ", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnexpectedException("Marshalling: ", classNotFoundException);
        }
    }

    public T3ClientParams findOrCreateClientContext(String string, UserInfo userInfo, int n) throws RemoteException {
        MsgAbbrevOutputStream msgAbbrevOutputStream = null;
        try {
            msgAbbrevOutputStream = this.rjvm.getRequestStream(null);
            msgAbbrevOutputStream.marshalCustomCallData();
            msgAbbrevOutputStream.writeByte(2);
            msgAbbrevOutputStream.writeString(string);
            msgAbbrevOutputStream.writeObjectWL((Object)userInfo);
            msgAbbrevOutputStream.writeInt(n);
            msgAbbrevOutputStream.writeByte((int)this.protocol.getQOS());
            return (T3ClientParams)BootServicesStub.getMsg(msgAbbrevOutputStream.sendRecv(ID, this.protocol.getQOS())).readObjectWL();
        }
        catch (IOException iOException) {
            throw new UnexpectedException("Marshalling: ", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnexpectedException("Marshalling: ", classNotFoundException);
        }
    }
}

