/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;

public final class LogMsg
implements Externalizable {
    private static final long serialVersionUID = -4898439307567022541L;
    public static final String PROXYCLASS = "weblogic.common.internal.LogProxy";
    public static final String PROXYLAZYCLASS = "weblogic.common.internal.LogProxyLazy";
    private static boolean verbose = false;
    public byte cmd;
    public String logmsg;
    public String exception;
    public static final byte INFO = 0;
    public static final byte ERROR = 1;
    public static final byte WARNING = 2;
    public static final byte SECURITY = 3;
    public static final byte DEBUG = 4;

    public String toString() {
        return "LogMsg " + LogMsg.getCmdVerb(this.cmd) + " - " + this.logmsg;
    }

    private static String getCmdVerb(byte by) {
        switch (by) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "SECURITY";
            }
            case 4: {
                return "DEBUG";
            }
        }
        return new Integer(by).toString();
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public LogMsg() {
    }

    public LogMsg(byte by) {
        this.cmd = by;
    }

    public LogMsg(byte by, String string) {
        this(by);
        this.logmsg = string;
    }

    public LogMsg(byte by, String string, String string2) {
        this(by, string);
        this.exception = string2;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.cmd = wLObjectInput.readByte();
        this.logmsg = wLObjectInput.readString();
        this.exception = wLObjectInput.readString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeByte((int)this.cmd);
        wLObjectOutput.writeString(this.logmsg);
        wLObjectOutput.writeString(this.exception);
    }
}

