/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.util.EmptyStackException;
import java.util.Stack;
import weblogic.common.internal.Manufacturable;
import weblogic.utils.collections.ConcurrentHashMap;

public final class ObjectFactory {
    private static final boolean VERBOSE = false;
    private static final ConcurrentHashMap objBags = new ConcurrentHashMap();

    private static final Stack bag(String string) {
        Stack stack = (Stack)objBags.get((Object)string);
        if (stack == null) {
            stack = new Stack();
            objBags.put((Object)string, stack);
        }
        return stack;
    }

    public static Manufacturable get(String string) {
        Manufacturable manufacturable;
        Stack stack = ObjectFactory.bag(string);
        try {
            manufacturable = (Manufacturable)stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            try {
                manufacturable = (Manufacturable)Class.forName(string).newInstance();
            }
            catch (ClassCastException classCastException) {
                throw new Error("Class " + string + " must be implement Manufacturable " + "(or some subInterface). [" + classCastException + "]");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Class " + string + " was not found. [" + classNotFoundException + "]");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Class " + string + " must be declared \"public\" and have " + "a \"public\" constructor. [" + illegalAccessException + "]");
            }
            catch (InstantiationException instantiationException) {
                throw new Error("Class " + string + " could not be instantiated. " + "Is it abstract? [" + instantiationException + "]");
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new Error("Class " + string + " must have a default constructor. [" + noSuchMethodError + "].");
            }
        }
        manufacturable.initialize();
        return manufacturable;
    }

    public static void put(Manufacturable manufacturable) {
        String string = manufacturable.getClass().getName();
        manufacturable.destroy();
        Stack stack = ObjectFactory.bag(string);
        stack.push(manufacturable);
    }
}

