/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class PassivationUtils {
    private PassivationUtils() {
    }

    public static byte[] toByteArray(Object object) throws IOException {
        return PassivationUtils.toByteArray(object, RemoteObjectReplacer.getReplacer());
    }

    public static byte[] toByteArray(Object object, Replacer replacer) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
        wLObjectOutputStream.setReplacer(replacer);
        wLObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
        wLObjectOutputStream.writeObject(object);
        wLObjectOutputStream.flush();
        wLObjectOutputStream.close();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static Object toObject(byte[] byArray) throws ClassNotFoundException, IOException {
        return PassivationUtils.toObject(byArray, RemoteObjectReplacer.getReplacer());
    }

    public static Object toObject(byte[] byArray, Replacer replacer) throws ClassNotFoundException, IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        WLObjectInputStream wLObjectInputStream = new WLObjectInputStream((InputStream)unsyncByteArrayInputStream);
        wLObjectInputStream.setReplacer(replacer);
        return wLObjectInputStream.readObject();
    }

    public static int sizeOf(Object object) throws IOException {
        return PassivationUtils.toByteArray(object).length;
    }

    public static Object copy(Object object) throws ClassNotFoundException, IOException {
        return PassivationUtils.toObject(PassivationUtils.toByteArray(object));
    }

    public static boolean isSerializable(Object object) {
        try {
            PassivationUtils.toByteArray(object);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

