/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import weblogic.application.AppClassLoaderManager;
import weblogic.j2ee.ApplicationManager;
import weblogic.kernel.Kernel;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

public class ProxyClassResolver {
    private static final boolean DEBUG = false;
    private static final boolean isServer = Kernel.isServer();
    private static final boolean isApplet = Kernel.isApplet();
    private static final ClassLoader sysClassLoader = isApplet ? null : ClassLoader.getSystemClassLoader();

    public static Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        return ProxyClassResolver.resolveProxyClass(stringArray, null, null);
    }

    public static Class resolveProxyClass(String[] stringArray, String string, String string2) throws IOException, ClassNotFoundException {
        return ProxyClassResolver.resolveProxyClass(stringArray, string, string2, false);
    }

    public static Class resolveProxyClass(String[] stringArray, String string, String string2, boolean bl) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < stringArray.length; ++i) {
            Class clazz;
            block9: {
                clazz = null;
                try {
                    clazz = ApplicationManager.loadClass(stringArray[i], string, string2, classLoader2, bl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz == null && !bl) {
                    try {
                        clazz = AppClassLoaderManager.getAppClassLoaderManager().loadApplicationClass(new Annotation(string), stringArray[i]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!isServer) break block9;
                        throw classNotFoundException;
                    }
                }
            }
            if (clazz == null) continue;
            arrayList.add(clazz);
            if (classLoader != null || !(clazz.getClassLoader() instanceof GenericClassLoader)) continue;
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ProxyClassResolver.getProxyLoader();
        }
        Class[] classArray = new Class[arrayList.size()];
        classArray = arrayList.toArray(classArray);
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    private static ClassLoader getProxyLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = sysClassLoader;
        }
        return classLoader;
    }
}

