/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.spi.InboundRequest;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;

public final class RMIBootServiceImpl
implements SecurityService {
    private static boolean turnOffIA;
    private static boolean propogatePE;
    private static final AuthenticatedSubject kernelId;

    public AuthenticatedUser authenticate(UserInfo userInfo) throws RemoteException {
        throw new AssertionError((Object)"authenticate()");
    }

    public AuthenticatedUser authenticate(UserInfo userInfo, InboundRequest inboundRequest) throws RemoteException {
        Debug.assertion((inboundRequest != null ? 1 : 0) != 0, (String)"Request cannot be null");
        ServerChannel serverChannel = inboundRequest.getServerChannel();
        AuthenticatedUser authenticatedUser = null;
        AuthenticatedSubject authenticatedSubject = null;
        X509Certificate[] x509CertificateArray = inboundRequest.getCertificateChain();
        if (userInfo instanceof AuthenticatedUser) {
            authenticatedUser = (AuthenticatedUser)userInfo;
        } else {
            Object object;
            String string = "weblogicDEFAULT";
            PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            Debug.assertion((principalAuthenticator != null ? 1 : 0) != 0, (String)"Security system not initialized");
            if (turnOffIA && x509CertificateArray != null) {
                return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            }
            if (x509CertificateArray != null) {
                try {
                    object = "X.509";
                    authenticatedSubject = principalAuthenticator.assertIdentity((String)object, (Object)x509CertificateArray, inboundRequest.getContextHandler());
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
            if (authenticatedSubject == null) {
                if (userInfo instanceof DefaultUserInfoImpl) {
                    object = (DefaultUserInfoImpl)userInfo;
                    String string2 = ((DefaultUserInfoImpl)object).getName();
                    String string3 = ((DefaultUserInfoImpl)object).getPassword();
                    if (string2 == null || string2.length() == 0) {
                        return SubjectUtils.getAnonymousSubject();
                    }
                    try {
                        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string2, string3);
                        authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler, inboundRequest.getContextHandler());
                    }
                    catch (LoginException loginException) {
                        SecurityException securityException = null;
                        securityException = propogatePE ? new SecurityException(loginException.getMessage()) : new SecurityException("User: " + string2 + ", failed to be authenticated.");
                        throw new RemoteException(securityException.getMessage(), securityException);
                    }
                } else {
                    object = new SecurityException("Received bad UserInfo: " + userInfo.getClass().getName());
                    throw new RemoteException(((Throwable)object).getMessage(), (Throwable)object);
                }
            }
            this.checkAdminPort(authenticatedSubject, ChannelHelper.isAdminChannel((ServerChannel)serverChannel));
            authenticatedUser = authenticatedSubject;
        }
        RMIBootServiceImpl.setQOS(authenticatedUser, serverChannel);
        return authenticatedUser;
    }

    private void checkAdminPort(AuthenticatedSubject authenticatedSubject, boolean bl) throws RemoteException {
        if (ChannelHelper.isLocalAdminChannelEnabled() && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) && !bl) {
            SecurityException securityException = new SecurityException("User '" + authenticatedSubject + "' has administration role. " + "All tasks by adminstrators must go through an " + "Administration Port.");
            throw new RemoteException(securityException.getMessage(), securityException);
        }
    }

    private static void setQOS(AuthenticatedUser authenticatedUser, ServerChannel serverChannel) {
        if (ChannelHelper.isLocalAdminChannelEnabled() && authenticatedUser instanceof AuthenticatedSubject && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)((AuthenticatedSubject)authenticatedUser)) && ChannelHelper.isAdminChannel((ServerChannel)serverChannel)) {
            authenticatedUser.setQOS((byte)103);
        } else {
            authenticatedUser.setQOS(serverChannel.getProtocol().getQOS());
        }
    }

    static {
        try {
            turnOffIA = Boolean.getBoolean("weblogic.security.disableIdentityAssertion");
            propogatePE = Boolean.getBoolean("weblogic.security.propogateProviderException");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

