/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.ParamSet;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;

public class RemoteEntryPoint
implements Externalizable {
    private static final long serialVersionUID = -6860805964340299268L;
    private transient T3Client t3;
    protected transient Object theObject;
    protected String className;
    protected ParamSet params;

    public String className() {
        return this.className;
    }

    public ParamSet params() {
        return this.params;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.className = wLObjectInput.readAbbrevString();
        this.params = (ParamSet)wLObjectInput.readObjectWL();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeAbbrevString(this.className);
        wLObjectOutput.writeObjectWL((Object)this.params);
    }

    public void initialize() {
    }

    public void destroy() {
        this.t3 = null;
        this.theObject = null;
        this.className = null;
        this.params = null;
    }

    public RemoteEntryPoint() {
        this.initialize();
    }

    public RemoteEntryPoint(Object object, ParamSet paramSet) {
        this.theObject = object;
        this.className = object.getClass().getName();
        this.params = paramSet;
        this.t3 = null;
    }

    public RemoteEntryPoint(Object object) {
        this(object, null);
    }

    public RemoteEntryPoint(String string, ParamSet paramSet) {
        this(null, string, paramSet);
    }

    public RemoteEntryPoint(String string) {
        this(null, string, null);
    }

    public RemoteEntryPoint(T3Client t3Client, String string, ParamSet paramSet) {
        this.t3 = t3Client;
        this.className = string;
        this.params = paramSet;
    }

    public T3Client getT3() {
        return this.t3;
    }

    public ParamSet getParamSet() {
        if (this.params == null) {
            this.params = new ParamSet(0);
        }
        return this.params;
    }

    public String getName() {
        return this.className;
    }

    void advertise() {
    }

    void retract() {
    }

    public Object newInstance() throws T3Exception {
        if (this.theObject == null) {
            try {
                this.theObject = Class.forName(this.getName(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new T3Exception("Class " + this.getName() + " must implement a default constructor.", (Throwable)noSuchMethodError);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new T3Exception("class: " + this.getName(), (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new T3Exception("class: " + this.getName(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new T3Exception("class: " + this.getName(), (Throwable)illegalAccessException);
            }
        }
        return this.theObject();
    }

    public Object theObject() {
        return this.theObject;
    }

    public boolean equals(Object object) {
        return object instanceof RemoteEntryPoint && this.getName().equals(((RemoteEntryPoint)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

