/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import weblogic.common.internal.ProxyClassResolver;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.Resolver;

public final class ReplacerObjectInputStream
extends ObjectInputStream {
    private final Replacer replacer;
    private final Resolver resolver;

    public ReplacerObjectInputStream(InputStream inputStream, Replacer replacer, Resolver resolver) throws IOException {
        super(inputStream);
        this.enableResolveObject(replacer != null);
        this.replacer = replacer;
        this.resolver = resolver;
    }

    protected Object resolveObject(Object object) throws IOException {
        Object object2 = this.replacer.resolveObject(object);
        return object2;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class clazz;
        if (this.resolver != null && (clazz = this.resolver.resolveClass(objectStreamClass)) != null) {
            return clazz;
        }
        return super.resolveClass(objectStreamClass);
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        return ProxyClassResolver.resolveProxyClass(stringArray);
    }
}

