/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import weblogic.common.AdminServicesDef;
import weblogic.common.LogServicesDef;
import weblogic.common.NameServicesDef;
import weblogic.common.T3ServicesDef;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.io.common.IOServicesDef;
import weblogic.jdbc.common.JdbcServicesDef;
import weblogic.jndi.Environment;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.time.common.TimeServicesDef;
import weblogic.utils.AssertionError;

public final class T3BindableServices
implements T3ServicesDef,
Externalizable {
    private static final long serialVersionUID = -9045561245277800956L;
    private JVMID hostID;
    private T3ServicesDef services;

    public T3BindableServices(JVMID jVMID) {
        try {
            this.setHostID(jVMID);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("Unexpected exception: " + remoteException);
        }
    }

    public T3BindableServices() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof WLObjectOutput) {
            ((WLObjectOutput)objectOutput).writeObjectWL((Object)this.hostID);
        } else {
            objectOutput.writeObject(this.hostID);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        JVMID jVMID = objectInput instanceof WLObjectInput ? (JVMID)((WLObjectInput)objectInput).readObjectWL() : (JVMID)objectInput.readObject();
        this.setHostID(jVMID);
    }

    private void setHostID(JVMID jVMID) throws RemoteException {
        if (jVMID.equals((Object)JVMID.localID())) {
            try {
                this.services = (T3ServicesDef)Class.forName("weblogic.t3.srvr.T3ServerServices").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Throwable)illegalAccessException);
            }
        } else {
            RJVM rJVM = RJVMManager.getRJVMManager().findOrCreate(jVMID);
            this.services = (T3ServicesDef)rJVM.getColocatedServices();
        }
        this.hostID = jVMID;
    }

    public AdminServicesDef admin() {
        return this.services.admin();
    }

    public JdbcServicesDef jdbc() {
        return null;
    }

    public LogServicesDef log() {
        return this.services.log();
    }

    public NameServicesDef name() {
        return this.services.name();
    }

    public IOServicesDef io() {
        return this.services.io();
    }

    public TimeServicesDef time() {
        return this.services.time();
    }

    public static void initialize() {
        try {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            environment.setReplicateBindings(false);
            environment.getInitialContext().bind("weblogic.common.T3Services", (Object)new T3BindableServices(JVMID.localID()));
        }
        catch (NamingException namingException) {
            throw new AssertionError((Throwable)namingException);
        }
    }
}

