/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;
import weblogic.common.ParamValue;

public final class VectorTable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4749091629973897117L;
    ParamValue[] pvs;
    int[] hints;
    int used;
    boolean verbose;
    public static final int NOTFOUND = -1;
    private boolean nohashing = true;

    public static void main(String[] stringArray) {
        System.out.println("testing the VectorTable");
        VectorTable vectorTable = new VectorTable();
        vectorTable.setVerbose(true);
        ParamValue paramValue = new ParamValue("foo", 1, 1, "testdescr foo");
        ParamValue paramValue2 = new ParamValue("bar", 1, 1, "testdescr bar");
        if (vectorTable.get("FOO") != null) {
            System.out.println("Failed #1");
        } else {
            System.out.println("OK#1");
        }
        if (vectorTable.put(paramValue) != paramValue) {
            System.out.println("Failed #2");
        } else {
            System.out.println("OK#2");
        }
        if (vectorTable.get("FOO") != paramValue) {
            System.out.println("Failed #3");
        } else {
            System.out.println("OK#3");
        }
        if (vectorTable.put(paramValue2) != paramValue2) {
            System.out.println("Failed #4");
        } else {
            System.out.println("OK#4");
        }
        if (vectorTable.get("FOO") != paramValue) {
            System.out.println("Failed #5");
        } else {
            System.out.println("OK#5");
        }
        if (vectorTable.get("bAr") != paramValue2) {
            System.out.println("Failed #6");
        } else {
            System.out.println("OK#6");
        }
        vectorTable.clear();
        if (vectorTable.get("bAr") != null) {
            System.out.println("Failed #7");
        } else {
            System.out.println("OK#7");
        }
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final int used() {
        return this.used;
    }

    public final int size() {
        return this.pvs.length;
    }

    public VectorTable() {
        this(1);
    }

    public VectorTable(int n) {
        this.pvs = new ParamValue[n];
        this.hints = new int[n];
        this.used = 0;
    }

    private VectorTable(VectorTable vectorTable) {
        this.pvs = new ParamValue[vectorTable.pvs.length];
        this.hints = new int[vectorTable.hints.length];
        this.used = vectorTable.used;
        this.verbose = vectorTable.verbose;
        System.arraycopy(vectorTable.hints, 0, this.hints, 0, vectorTable.hints.length);
        for (int i = 0; i < vectorTable.pvs.length; ++i) {
            if (vectorTable.pvs[i] == null) continue;
            this.pvs[i] = (ParamValue)vectorTable.pvs[i].clone();
        }
    }

    public synchronized Object clone() {
        return new VectorTable(this);
    }

    private void realloc() {
        if (this.used() < this.size()) {
            return;
        }
        int n = this.size();
        int n2 = 2 * n;
        ParamValue[] paramValueArray = this.pvs;
        this.pvs = new ParamValue[n2];
        System.arraycopy(paramValueArray, 0, this.pvs, 0, n);
        int[] nArray = this.hints;
        this.hints = new int[n2];
        System.arraycopy(nArray, 0, this.hints, 0, n);
        if (this.verbose) {
            System.out.println(this.toString() + "Expanded from " + n + " to " + n2 + "; size=" + this.size());
        }
    }

    private int hashhint(String string) {
        if (this.nohashing) {
            return 0;
        }
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0);
    }

    private void clearOne(int n) {
        if (this.verbose) {
            System.out.println(this.toString() + "cleared item " + n);
        }
        if (this.pvs[n] != null) {
            this.pvs[n] = null;
            this.hints[n] = 0;
            --this.used;
        }
    }

    private ParamValue replaceOne(int n, ParamValue paramValue) {
        if (this.verbose) {
            System.out.println(this.toString() + " replaced item " + n);
        }
        this.hints[n] = this.hashhint(paramValue.name());
        this.pvs[n] = paramValue;
        return paramValue;
    }

    private int getEmpty() {
        int n;
        int n2 = this.size();
        this.realloc();
        for (n = n2; n < this.size(); ++n) {
            if (this.pvs[n] != null) continue;
            if (this.verbose) {
                System.out.println(this.toString() + " gotEmpty#1 " + n);
            }
            return n;
        }
        for (n = 0; n < n2; ++n) {
            if (this.pvs[n] != null) continue;
            if (this.verbose) {
                System.out.println(this.toString() + " gotEmpty#2 " + n);
            }
            return n;
        }
        if (this.verbose) {
            System.out.println(this.toString() + "failed miserably ");
        }
        n = this.size() * 2;
        ParamValue paramValue = this.pvs[n];
        return -1;
    }

    private int getOne(String string) {
        int n;
        int n2 = this.hashhint(string);
        int n3 = 0;
        int n4 = this.size();
        for (n3 = 0; n3 < n4 - 1 && this.hints[n3] != n2; ++n3) {
        }
        for (n = n3; n < n4; ++n) {
            if (this.pvs[n] == null || !string.equalsIgnoreCase(this.pvs[n].name())) continue;
            if (this.verbose) {
                System.out.println(this.toString() + " gotOne#1 " + n);
            }
            return n;
        }
        for (n = 0; n < n3; ++n) {
            if (this.pvs[n] == null || !string.equalsIgnoreCase(this.pvs[n].name())) continue;
            if (this.verbose) {
                System.out.println(this.toString() + " gotOne#1 " + n);
            }
            return n;
        }
        return -1;
    }

    public String toString() {
        return "[" + super.toString() + " used: " + this.used() + " size: " + this.size() + "]";
    }

    public synchronized ParamValue get(int n) {
        if (n >= this.size()) {
            return null;
        }
        return this.pvs[n];
    }

    public synchronized ParamValue get(String string) {
        int n = this.getOne(string);
        if (n != -1) {
            return this.pvs[n];
        }
        return null;
    }

    public synchronized ParamValue put(ParamValue paramValue) {
        int n = this.getOne(paramValue.name());
        if (n != -1) {
            return this.replaceOne(n, paramValue);
        }
        ++this.used;
        return this.replaceOne(this.getEmpty(), paramValue);
    }

    public synchronized void remove(String string) {
        int n = this.getOne(string);
        if (n != -1) {
            this.clearOne(n);
        }
    }

    public boolean isEmpty() {
        return this.used() == 0;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.clearOne(i);
        }
    }
}

