/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.ProxyClassResolver;
import weblogic.j2ee.ApplicationManager;
import weblogic.utils.AssertionError;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.DelegatingInputStream;
import weblogic.utils.io.Replacer;

public class WLObjectInputStream
extends ObjectInputStream
implements WLObjectInput {
    private final DelegatingInputStream delegate;
    private Replacer replacer = null;

    public WLObjectInputStream(InputStream inputStream) throws IOException {
        this(new DelegatingInputStream(inputStream));
    }

    private WLObjectInputStream(DelegatingInputStream delegatingInputStream) throws IOException {
        super((InputStream)delegatingInputStream);
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.delegate = delegatingInputStream;
    }

    public final void setDelegate(InputStream inputStream) {
        this.delegate.setDelegate(inputStream);
    }

    protected final Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = null;
        try {
            string = this.readUTF();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        return ApplicationManager.loadClass(objectStreamClass.getName(), string, this.useInterAppClassLoader());
    }

    protected boolean useInterAppClassLoader() {
        return false;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        String string = null;
        try {
            string = this.readUTF();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        return ProxyClassResolver.resolveProxyClass(stringArray, string, null, this.useInterAppClassLoader());
    }

    public String readUTF() throws IOException {
        return DataIO.readUTF((InputStream)this);
    }

    public final void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    protected Object resolveObject(Object object) throws IOException {
        return this.replacer == null ? object : this.replacer.resolveObject(object);
    }

    protected final void readStreamHeader() throws IOException {
    }

    public final void reset() throws IOException {
    }

    public final void close() throws IOException {
    }

    public Object readObjectWL() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    public final String readString() throws IOException {
        byte by = this.readByte();
        if (by == 112) {
            return null;
        }
        return this.readUTF();
    }

    public final Date readDate() throws IOException {
        try {
            return (Date)this.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Couldn't find class", (Throwable)classNotFoundException);
        }
    }

    public final ArrayList readArrayList() throws IOException, ClassNotFoundException {
        return (ArrayList)this.readObject();
    }

    public final Properties readProperties() throws IOException {
        try {
            return (Properties)this.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Couldn't find class", (Throwable)classNotFoundException);
        }
    }

    public final byte[] readBytes() throws IOException {
        try {
            return (byte[])this.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Couldn't find class", (Throwable)classNotFoundException);
        }
    }

    public final Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
        return (Object[])this.readObject();
    }

    public Object readImmutable() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    public final String readAbbrevString() throws IOException {
        return this.readString();
    }
}

